/*
 * Decompiled with CFR 0.152.
 */
package org.restlet.data;

import java.util.List;
import java.util.Set;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.CopyOnWriteArraySet;
import org.restlet.data.ChallengeRequest;
import org.restlet.data.CookieSetting;
import org.restlet.data.Dimension;
import org.restlet.data.Message;
import org.restlet.data.Method;
import org.restlet.data.Reference;
import org.restlet.data.Request;
import org.restlet.data.ServerInfo;
import org.restlet.data.Status;
import org.restlet.util.Series;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Response
extends Message {
    private static final ThreadLocal<Response> CURRENT = new ThreadLocal();
    private volatile Set<Method> allowedMethods = null;
    private volatile List<ChallengeRequest> challengeRequests = null;
    private volatile Series<CookieSetting> cookieSettings = null;
    private volatile Set<Dimension> dimensions = null;
    private volatile Reference locationRef = null;
    private volatile Request request;
    private volatile ServerInfo serverInfo;
    private volatile Status status;

    public static Response getCurrent() {
        return CURRENT.get();
    }

    public static void setCurrent(Response response) {
        CURRENT.set(response);
    }

    public Response(Request request) {
        this.request = request;
        this.serverInfo = null;
        this.status = Status.SUCCESS_OK;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Set<Method> getAllowedMethods() {
        Set<Method> a = this.allowedMethods;
        if (a == null) {
            Response response = this;
            synchronized (response) {
                a = this.allowedMethods;
                if (a == null) {
                    this.allowedMethods = a = new CopyOnWriteArraySet<Method>();
                }
            }
        }
        return a;
    }

    @Deprecated
    public ChallengeRequest getChallengeRequest() {
        List<ChallengeRequest> requests = this.challengeRequests;
        if (requests != null && requests.size() > 0) {
            return requests.get(0);
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<ChallengeRequest> getChallengeRequests() {
        List<ChallengeRequest> cr = this.challengeRequests;
        if (cr == null) {
            Response response = this;
            synchronized (response) {
                cr = this.challengeRequests;
                if (cr == null) {
                    this.challengeRequests = cr = new CopyOnWriteArrayList<ChallengeRequest>();
                }
            }
        }
        return cr;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Series<CookieSetting> getCookieSettings() {
        CookieSettingSeries c = this.cookieSettings;
        if (c == null) {
            Response response = this;
            synchronized (response) {
                c = this.cookieSettings;
                if (c == null) {
                    this.cookieSettings = c = new CookieSettingSeries();
                }
            }
        }
        return c;
    }

    public Set<Dimension> getDimensions() {
        if (this.dimensions == null) {
            this.dimensions = new CopyOnWriteArraySet<Dimension>();
        }
        return this.dimensions;
    }

    public Reference getLocationRef() {
        return this.locationRef;
    }

    @Deprecated
    public Reference getRedirectRef() {
        return this.getLocationRef();
    }

    public Request getRequest() {
        return this.request;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ServerInfo getServerInfo() {
        ServerInfo s = this.serverInfo;
        if (s == null) {
            Response response = this;
            synchronized (response) {
                s = this.serverInfo;
                if (s == null) {
                    this.serverInfo = s = new ServerInfo();
                }
            }
        }
        return s;
    }

    public Status getStatus() {
        return this.status;
    }

    public void redirectPermanent(Reference targetRef) {
        this.setLocationRef(targetRef);
        this.setStatus(Status.REDIRECTION_PERMANENT);
    }

    public void redirectPermanent(String targetUri) {
        this.setLocationRef(targetUri);
        this.setStatus(Status.REDIRECTION_PERMANENT);
    }

    public void redirectSeeOther(Reference targetRef) {
        this.setLocationRef(targetRef);
        this.setStatus(Status.REDIRECTION_SEE_OTHER);
    }

    public void redirectSeeOther(String targetUri) {
        this.setLocationRef(targetUri);
        this.setStatus(Status.REDIRECTION_SEE_OTHER);
    }

    public void redirectTemporary(Reference targetRef) {
        this.setLocationRef(targetRef);
        this.setStatus(Status.REDIRECTION_TEMPORARY);
    }

    public void redirectTemporary(String targetUri) {
        this.setLocationRef(targetUri);
        this.setStatus(Status.REDIRECTION_TEMPORARY);
    }

    public void setAllowedMethods(Set<Method> allowedMethods) {
        this.allowedMethods = allowedMethods;
    }

    public void setChallengeRequest(ChallengeRequest request) {
        CopyOnWriteArrayList<ChallengeRequest> requests = new CopyOnWriteArrayList<ChallengeRequest>();
        requests.add(request);
        this.setChallengeRequests(requests);
    }

    public void setChallengeRequests(List<ChallengeRequest> requests) {
        this.challengeRequests = requests;
    }

    public void setCookieSettings(Series<CookieSetting> cookieSettings) {
        this.cookieSettings = cookieSettings;
    }

    public void setDimensions(Set<Dimension> dimensions) {
        this.dimensions = dimensions;
    }

    public void setLocationRef(Reference locationRef) {
        this.locationRef = locationRef;
    }

    public void setLocationRef(String locationUri) {
        Reference baseRef = null;
        if (this.getRequest().getResourceRef() != null) {
            baseRef = this.getRequest().getResourceRef().getBaseRef() != null ? this.getRequest().getResourceRef().getBaseRef() : this.getRequest().getResourceRef();
        }
        this.setLocationRef(new Reference(baseRef, locationUri).getTargetRef());
    }

    @Deprecated
    public void setRedirectRef(Reference locationRef) {
        this.setLocationRef(locationRef);
    }

    @Deprecated
    public void setRedirectRef(String locationUri) {
        this.setLocationRef(locationUri);
    }

    public void setRequest(Request request) {
        this.request = request;
    }

    public void setServerInfo(ServerInfo serverInfo) {
        this.serverInfo = serverInfo;
    }

    public void setStatus(Status status) {
        this.status = status;
    }

    public void setStatus(Status status, String message) {
        this.setStatus(new Status(status, message));
    }

    public void setStatus(Status status, Throwable throwable) {
        this.setStatus(new Status(status, throwable));
    }

    public void setStatus(Status status, Throwable throwable, String message) {
        this.setStatus(new Status(status, throwable, message));
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class CookieSettingSeries
    extends Series<CookieSetting> {
        public CookieSettingSeries() {
        }

        public CookieSettingSeries(List<CookieSetting> delegate) {
            super(delegate);
        }

        @Override
        public CookieSetting createEntry(String name, String value) {
            return new CookieSetting(name, value);
        }

        @Override
        public Series<CookieSetting> createSeries(List<CookieSetting> delegate) {
            if (delegate != null) {
                return new CookieSettingSeries(delegate);
            }
            return new CookieSettingSeries();
        }
    }
}

