/*
 * Decompiled with CFR 0.152.
 */
package org.restlet.example.book.restlet.ch05.sec2.verifier.jaas;

import org.restlet.Application;
import org.restlet.Component;
import org.restlet.Restlet;
import org.restlet.Server;
import org.restlet.data.ChallengeScheme;
import org.restlet.data.Protocol;
import org.restlet.example.book.restlet.ch05.sec2.verifier.jaas.MailServerResource;
import org.restlet.ext.jaas.JaasVerifier;
import org.restlet.routing.Router;
import org.restlet.security.ChallengeAuthenticator;
import org.restlet.security.Verifier;
import org.restlet.util.Series;

public class MailServerApplication
extends Application {
    public static void main(String[] args) throws Exception {
        Component mailServer = new Component();
        Server server = mailServer.getServers().add(Protocol.HTTPS, 8183);
        Series parameters = server.getContext().getParameters();
        parameters.add("keystorePath", "src/org/restlet/example/book/restlet/ch05/serverKey.jks");
        parameters.add("keystorePassword", "password");
        parameters.add("keystoreType", "JKS");
        parameters.add("keyPassword", "password");
        mailServer.getDefaultHost().attach((Restlet)new MailServerApplication());
        mailServer.start();
    }

    public Restlet createInboundRoot() {
        Router router = new Router(this.getContext());
        router.attach("/accounts/{accountId}/mails/{mailId}", MailServerResource.class);
        ChallengeAuthenticator authenticator = new ChallengeAuthenticator(this.getContext(), ChallengeScheme.HTTP_BASIC, "My Realm");
        JaasVerifier verifier = new JaasVerifier("MailServerApplication");
        verifier.setUserPrincipalClassName("com.sun.security.auth.UserPrincipal");
        authenticator.setVerifier((Verifier)verifier);
        authenticator.setNext((Restlet)router);
        return authenticator;
    }
}

