/*
 * Decompiled with CFR 0.152.
 */
package org.restlet.example.book.restlet.ch06.sec2.server;

import org.restlet.example.book.restlet.ch02.sec5.sub5.common.AccountResource;
import org.restlet.example.book.restlet.ch06.sec2.server.AccountsServerResource;
import org.restlet.ext.wadl.MethodInfo;
import org.restlet.ext.wadl.RepresentationInfo;
import org.restlet.ext.wadl.WadlServerResource;
import org.restlet.representation.Variant;
import org.restlet.resource.ResourceException;

public class AccountServerResource
extends WadlServerResource
implements AccountResource {
    private int accountId;

    protected RepresentationInfo describe(MethodInfo methodInfo, Class<?> representationClass, Variant variant) {
        RepresentationInfo result = super.describe(methodInfo, representationClass, variant);
        result.setReference("account");
        return result;
    }

    protected void doInit() throws ResourceException {
        String accountIdAttribute = this.getAttribute("accountId");
        if (accountIdAttribute != null) {
            this.accountId = Integer.parseInt(accountIdAttribute);
            this.setName("Resource for mail account '" + this.accountId + "'");
            this.setDescription("The resource describing the mail account number '" + this.accountId + "'");
        } else {
            this.setName("Mail account resource");
            this.setDescription("The resource describing a mail account");
        }
    }

    @Override
    public void remove() {
        AccountsServerResource.getAccounts().remove(this.accountId);
    }

    @Override
    public String represent() {
        return AccountsServerResource.getAccounts().get(this.accountId);
    }

    @Override
    public void store(String account) {
        AccountsServerResource.getAccounts().set(this.accountId, account);
    }
}

