/*
 * Decompiled with CFR 0.152.
 */
package org.restlet.example.book.restlet.ch07.sec5.website;

import java.io.OutputStream;
import java.util.List;
import org.apache.commons.fileupload.FileItem;
import org.apache.commons.fileupload.FileItemFactory;
import org.apache.commons.fileupload.disk.DiskFileItemFactory;
import org.restlet.Uniform;
import org.restlet.data.LocalReference;
import org.restlet.data.MediaType;
import org.restlet.example.book.restlet.ch07.sec5.webapi.common.MailRepresentation;
import org.restlet.ext.fileupload.RestletFileUpload;
import org.restlet.ext.freemarker.TemplateRepresentation;
import org.restlet.representation.InputRepresentation;
import org.restlet.representation.Representation;
import org.restlet.resource.ClientResource;
import org.restlet.resource.Get;
import org.restlet.resource.Put;
import org.restlet.resource.ServerResource;

public class MailServerResource
extends ServerResource {
    @Get
    Representation retrieve() {
        String accountId = this.getAttribute("accountId");
        String mailId = this.getAttribute("mailId");
        String mailApiUri = "riap://component/api/accounts/" + accountId + "/mails/" + mailId;
        ClientResource cr = new ClientResource(mailApiUri);
        cr.setNext((Uniform)this.getContext().getServerDispatcher());
        MailRepresentation mail = (MailRepresentation)cr.get(MailRepresentation.class);
        Representation mailFtl = new ClientResource(LocalReference.createClapReference((Package)((Object)((Object)this)).getClass().getPackage()) + "/Mail.ftl").get();
        return new TemplateRepresentation(mailFtl, (Object)mail, MediaType.TEXT_HTML);
    }

    @Put
    public String store(Representation input) throws Exception {
        RestletFileUpload fileUpload = new RestletFileUpload((FileItemFactory)new DiskFileItemFactory());
        List fileItems = fileUpload.parseRepresentation(input);
        for (FileItem fileItem : fileItems) {
            if (fileItem.isFormField()) {
                System.out.println(fileItem.getFieldName() + "=" + fileItem.getString());
                continue;
            }
            InputRepresentation attachment = new InputRepresentation(fileItem.getInputStream());
            attachment.write((OutputStream)System.out);
        }
        return "Mail updated!";
    }
}

