/*
 * Decompiled with CFR 0.152.
 */
package org.restlet.example.book.restlet.ch10.sec3.server;

import java.util.Map;
import org.restlet.data.Reference;
import org.restlet.example.book.restlet.ch10.sec3.FoafConstants;
import org.restlet.example.book.restlet.ch10.sec3.api.AccountRepresentation;
import org.restlet.example.book.restlet.ch10.sec3.api.AccountResource;
import org.restlet.example.book.restlet.ch10.sec3.model.Account;
import org.restlet.example.book.restlet.ch10.sec3.model.Contact;
import org.restlet.example.book.restlet.ch10.sec3.server.MailServerApplication;
import org.restlet.ext.rdf.Graph;
import org.restlet.ext.rdf.Literal;
import org.restlet.resource.ResourceException;
import org.restlet.resource.ServerResource;

public class AccountServerResource
extends ServerResource
implements AccountResource {
    private Account account;

    public Map<String, Account> getAccounts() {
        return ((MailServerApplication)this.getApplication()).getAccounts();
    }

    protected void doInit() throws ResourceException {
        String accountId = this.getAttribute("accountId");
        this.account = this.getAccounts().get(accountId);
    }

    public void remove() {
        this.getAccounts().remove(this.account);
    }

    @Override
    public Graph getFoafProfile() {
        Graph result = null;
        if (this.account != null) {
            result = new Graph();
            result.add(this.getReference(), FoafConstants.MBOX, new Literal("mailto:" + this.account.getEmailAddress()));
            result.add(this.getReference(), FoafConstants.FIRST_NAME, new Literal(this.account.getFirstName()));
            result.add(this.getReference(), FoafConstants.LAST_NAME, new Literal(this.account.getLastName()));
            result.add(this.getReference(), FoafConstants.NICK, new Literal(this.account.getNickName()));
            result.add(this.getReference(), FoafConstants.NAME, new Literal(this.account.getSenderName()));
            for (Contact contact : this.account.getContacts()) {
                result.add(this.getReference(), FoafConstants.KNOWS, new Reference(this.getReference(), contact.getProfileRef()).getTargetRef());
            }
        }
        return result;
    }

    @Override
    public AccountRepresentation represent() {
        AccountRepresentation result = null;
        if (this.account != null) {
            result = new AccountRepresentation();
            result.setEmailAddress(this.account.getEmailAddress());
            result.setFirstName(this.account.getFirstName());
            result.setLastName(this.account.getLastName());
            result.setLogin(this.account.getLogin());
            result.setNickName(this.account.getNickName());
            result.setSenderName(this.account.getSenderName());
            for (Contact contact : this.account.getContacts()) {
                result.getContactRefs().add(contact.getProfileRef());
            }
        }
        return result;
    }
}

