/*
 * Decompiled with CFR 0.152.
 */
package org.restlet.example.ext.jaxrs.employees;

import java.util.HashMap;
import java.util.Map;
import org.restlet.example.ext.jaxrs.employees.Employee;
import org.restlet.example.ext.jaxrs.employees.EmployeeList;
import org.restlet.example.ext.jaxrs.employees.SmallEmployee;

public class EmployeeMgr {
    private static EmployeeMgr singelton = new EmployeeMgr();
    private final Map<Integer, Employee> employees = new HashMap<Integer, Employee>();

    public EmployeeMgr() {
        Employee employee1 = new Employee();
        employee1.setStaffNo(1234);
        employee1.setFirstname("Lucy");
        employee1.setLastname("Smith");
        employee1.setSex("w");
        employee1.setDepartment("research");
        this.employees.put(employee1.getStaffNo(), employee1);
        Employee employee2 = new Employee();
        employee2.setStaffNo(3210);
        employee2.setFirstname("Jack");
        employee2.setLastname("Jonson");
        employee2.setSex("m");
        employee2.setDepartment("purchase");
        this.employees.put(employee2.getStaffNo(), employee2);
    }

    public static EmployeeMgr get() {
        return singelton;
    }

    public synchronized int createEmployee(Employee employee) {
        int staffNo = this.createNewStaffNo();
        employee.setStaffNo(staffNo);
        this.employees.put(employee.getStaffNo(), employee);
        return staffNo;
    }

    private synchronized int createNewStaffNo() {
        int newStaffNo = 3456;
        while (this.exists(newStaffNo)) {
            ++newStaffNo;
        }
        return newStaffNo;
    }

    private synchronized SmallEmployee createSmall(Employee employee) {
        SmallEmployee smallEmployee = new SmallEmployee();
        smallEmployee.setStaffNo(employee.getStaffNo());
        smallEmployee.setFirstname(employee.getFirstname());
        smallEmployee.setLastname(employee.getLastname());
        return smallEmployee;
    }

    public synchronized boolean exists(int staffNo) {
        return this.employees.get(staffNo) != null;
    }

    public synchronized EmployeeList getAll() {
        EmployeeList employees = new EmployeeList();
        for (Employee employee : this.employees.values()) {
            employees.add(this.createSmall(employee));
        }
        return employees;
    }

    public synchronized Employee getFull(int staffNo) {
        return this.employees.get(staffNo);
    }

    public synchronized SmallEmployee getSmall(int staffNo) {
        Employee employee = this.getFull(staffNo);
        return this.createSmall(employee);
    }

    public synchronized void remove(int staffNo) {
        this.employees.remove(staffNo);
    }

    public synchronized void update(int staffNo, Employee employee) {
        employee.setStaffNo(staffNo);
        this.employees.put(staffNo, employee);
    }
}

