/*
 * Decompiled with CFR 0.152.
 */
package org.restlet.example.ext.oauth.mongo;

import com.mongodb.DBObject;
import java.util.List;
import org.restlet.ext.oauth.OAuthResourceDefs;
import org.restlet.ext.oauth.internal.ServerToken;

public class MongoToken
implements ServerToken,
OAuthResourceDefs {
    public static final String TIMESTAMP = "timestamp";
    private DBObject token;

    public MongoToken(DBObject token) {
        this.token = token;
    }

    public boolean isExpired() {
        int currentTime = (int)(System.currentTimeMillis() / 1000L);
        int elapsedTime = currentTime - this.getTimestamp();
        return elapsedTime >= this.getExpirePeriod();
    }

    public int getTimestamp() {
        return ((Number)this.token.get(TIMESTAMP)).intValue();
    }

    public String getAccessToken() {
        return this.token.get("access_token").toString();
    }

    public String getTokenType() {
        return this.token.get("token_type").toString();
    }

    public int getExpirePeriod() {
        return ((Number)this.token.get("expires_in")).intValue();
    }

    public String getRefreshToken() {
        return this.token.get("refresh_token").toString();
    }

    public String[] getScope() {
        List list = (List)this.token.get("scope");
        String[] scope = new String[list.size()];
        for (int i = 0; i < list.size(); ++i) {
            scope[i] = list.get(i).toString();
        }
        return scope;
    }

    public String getUsername() {
        if (this.token.containsField("username")) {
            return this.token.get("username").toString();
        }
        return null;
    }

    public String getClientId() {
        return this.token.get("client_id").toString();
    }
}

