/*
 * Decompiled with CFR 0.152.
 */
package org.restlet.example.ext.oauth.server;

import freemarker.cache.TemplateLoader;
import freemarker.template.Configuration;
import java.util.HashMap;
import org.restlet.data.MediaType;
import org.restlet.example.ext.oauth.server.OAuth2Sample;
import org.restlet.example.ext.oauth.server.SampleUser;
import org.restlet.ext.freemarker.ContextTemplateLoader;
import org.restlet.ext.freemarker.TemplateRepresentation;
import org.restlet.ext.oauth.AuthorizationBaseServerResource;
import org.restlet.ext.oauth.OAuthException;
import org.restlet.representation.EmptyRepresentation;
import org.restlet.representation.Representation;
import org.restlet.resource.Get;
import org.restlet.resource.Post;
import org.restlet.security.SecretVerifier;

public class LoginPageServerResource
extends AuthorizationBaseServerResource {
    @Get(value="html")
    @Post(value="html")
    public Representation getPage() throws OAuthException {
        this.getLogger().info("Get Login");
        String userId = this.getQueryValue("user_id");
        HashMap<String, String> data = new HashMap<String, String>();
        if (userId != null && !userId.isEmpty()) {
            String password = this.getQueryValue("password");
            this.getLogger().info("User=" + userId + ", Pass=" + password);
            SampleUser sampleUser = OAuth2Sample.getSampleUserManager().findUserById(userId);
            if (sampleUser == null) {
                data.put("error", "Authentication failed.");
                data.put("error_description", "ID is invalid.");
            } else {
                boolean result = SecretVerifier.compare((char[])password.toCharArray(), (char[])sampleUser.getPassword());
                if (result) {
                    this.getAuthSession().setScopeOwner(userId);
                    String uri = this.getQueryValue("continue");
                    this.getLogger().info("URI: " + uri);
                    this.redirectTemporary(uri);
                    return new EmptyRepresentation();
                }
                data.put("error", "Authentication failed.");
                data.put("error_description", "Password is invalid.");
            }
        }
        String continueURI = this.getQueryValue("continue");
        TemplateRepresentation response = this.getLoginPage("login.html");
        data.put("continue", continueURI);
        response.setDataModel(data);
        return response;
    }

    protected TemplateRepresentation getLoginPage(String loginPage) {
        Configuration config = new Configuration();
        config.setTemplateLoader((TemplateLoader)new ContextTemplateLoader(this.getContext(), "clap:///"));
        this.getLogger().fine("loading: " + loginPage);
        return new TemplateRepresentation(loginPage, config, MediaType.TEXT_HTML);
    }
}

