/*
 * Decompiled with CFR 0.152.
 */
package org.restlet.example.ext.rdf.foaf.resources;

import java.util.TreeMap;
import org.restlet.data.Form;
import org.restlet.data.MediaType;
import org.restlet.example.ext.rdf.foaf.objects.Contact;
import org.restlet.example.ext.rdf.foaf.objects.User;
import org.restlet.example.ext.rdf.foaf.resources.BaseResource;
import org.restlet.representation.Representation;
import org.restlet.representation.Variant;
import org.restlet.resource.Delete;
import org.restlet.resource.Get;
import org.restlet.resource.Put;
import org.restlet.resource.ResourceException;

public class ContactResource
extends BaseResource {
    private Contact contact;
    private User user;

    public void doInit() {
        String userId = (String)this.getRequestAttributes().get("userId");
        this.user = this.getObjectsFacade().getUserById(userId);
        if (this.user != null) {
            String contactId = (String)this.getRequestAttributes().get("contactId");
            this.contact = this.getObjectsFacade().getContactById(contactId);
        }
        this.setExisting(this.contact != null);
    }

    @Delete
    public void removeContact() throws ResourceException {
        this.getObjectsFacade().deleteContact(this.user, this.contact);
        this.getResponse().redirectSeeOther(this.getRequest().getResourceRef().getParentRef());
    }

    @Put
    public void storeContact(Representation entity) throws ResourceException {
        Form form = new Form(entity);
        this.contact.setFirstName(form.getFirstValue("firstName"));
        this.contact.setLastName(form.getFirstValue("lastName"));
        this.contact.setImage(form.getFirstValue("image"));
        this.contact.setNickname(form.getFirstValue("nickname"));
        this.contact.setFoafUri(form.getFirstValue("foafUri"));
        this.getObjectsFacade().updateContact(this.user, this.contact);
        this.getResponse().redirectSeeOther(this.getRequest().getResourceRef());
    }

    @Get(value="html")
    public Representation toHtml(Variant variant) throws ResourceException {
        TreeMap<String, Object> dataModel = new TreeMap<String, Object>();
        dataModel.put("user", this.user);
        dataModel.put("contact", this.contact);
        dataModel.put("resourceRef", this.getRequest().getResourceRef());
        dataModel.put("rootRef", this.getRequest().getRootRef());
        return this.getTemplateRepresentation("contact.html", dataModel, MediaType.TEXT_HTML);
    }

    @Get(value="rdf")
    public Representation toFoaf() throws ResourceException {
        return this.getFoafRepresentation(this.contact, this.getRequest().getResourceRef());
    }
}

