/*
 * Decompiled with CFR 0.152.
 */
package org.restlet.ext.gson;

import java.io.IOException;
import java.util.List;
import org.restlet.data.MediaType;
import org.restlet.data.Preference;
import org.restlet.engine.converter.ConverterHelper;
import org.restlet.engine.resource.VariantInfo;
import org.restlet.ext.gson.GsonRepresentation;
import org.restlet.representation.Representation;
import org.restlet.representation.Variant;
import org.restlet.resource.Resource;

public class GsonConverter
extends ConverterHelper {
    private static final VariantInfo VARIANT_JSON = new VariantInfo(MediaType.APPLICATION_JSON);

    protected <T> GsonRepresentation<T> create(Representation source, Class<T> objectClass) {
        return new GsonRepresentation<T>(source, objectClass);
    }

    protected <T> GsonRepresentation<T> create(T source) {
        return new GsonRepresentation<T>(source);
    }

    public List<Class<?>> getObjectClasses(Variant source) {
        List result = null;
        if (VARIANT_JSON.isCompatible(source)) {
            result = this.addObjectClass(result, Object.class);
            result = this.addObjectClass(result, GsonRepresentation.class);
        }
        return result;
    }

    public List<VariantInfo> getVariants(Class<?> source) {
        List result = null;
        if (source != null) {
            result = this.addVariant(result, VARIANT_JSON);
        }
        return result;
    }

    public float score(Object source, Variant target, Resource resource) {
        float result = -1.0f;
        result = source instanceof GsonRepresentation ? 1.0f : (target == null ? 0.5f : (VARIANT_JSON.isCompatible(target) ? 0.8f : 0.5f));
        return result;
    }

    public <T> float score(Representation source, Class<T> target, Resource resource) {
        float result = -1.0f;
        if (source instanceof GsonRepresentation) {
            result = 1.0f;
        } else if (target != null && GsonRepresentation.class.isAssignableFrom(target)) {
            result = 1.0f;
        } else if (VARIANT_JSON.isCompatible((Variant)source)) {
            result = 0.8f;
        }
        return result;
    }

    public <T> T toObject(Representation source, Class<T> target, Resource resource) throws IOException {
        GsonRepresentation<T> result = null;
        GsonRepresentation<T> gsonSource = null;
        if (source instanceof GsonRepresentation) {
            gsonSource = (GsonRepresentation<T>)source;
        } else if (VARIANT_JSON.isCompatible((Variant)source)) {
            gsonSource = this.create(source, target);
        }
        if (gsonSource != null) {
            result = target != null && GsonRepresentation.class.isAssignableFrom(target) ? gsonSource : (GsonRepresentation<T>)((Object)gsonSource.getObject());
        }
        return (T)((Object)result);
    }

    public Representation toRepresentation(Object source, Variant target, Resource resource) throws IOException {
        GsonRepresentation<Object> result = null;
        if (source instanceof GsonRepresentation) {
            result = (GsonRepresentation<Object>)((Object)source);
        } else {
            if (target.getMediaType() == null) {
                target.setMediaType(MediaType.APPLICATION_JSON);
            }
            if (VARIANT_JSON.isCompatible(target)) {
                GsonRepresentation<Object> gsonRepresentation;
                result = gsonRepresentation = this.create(source);
            }
        }
        return result;
    }

    public <T> void updatePreferences(List<Preference<MediaType>> preferences, Class<T> entity) {
        this.updatePreferences(preferences, MediaType.APPLICATION_JSON, 1.0f);
    }
}

