/*
 * Decompiled with CFR 0.152.
 */
package org.restlet.ext.json;

import java.io.IOException;
import java.util.List;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;
import org.json.JSONTokener;
import org.restlet.data.MediaType;
import org.restlet.data.Metadata;
import org.restlet.data.Preference;
import org.restlet.engine.converter.ConverterHelper;
import org.restlet.engine.resource.VariantInfo;
import org.restlet.ext.json.JsonRepresentation;
import org.restlet.representation.Representation;
import org.restlet.representation.Variant;
import org.restlet.resource.Resource;

public class JsonConverter
extends ConverterHelper {
    private static final VariantInfo VARIANT_JSON = new VariantInfo(MediaType.APPLICATION_JSON);

    public List<Class<?>> getObjectClasses(Variant source) {
        List result = null;
        if (VARIANT_JSON.isCompatible(source)) {
            result = this.addObjectClass(result, JSONArray.class);
            result = this.addObjectClass(result, JSONObject.class);
            result = this.addObjectClass(result, JSONTokener.class);
        }
        return result;
    }

    public List<VariantInfo> getVariants(Class<?> source) {
        List result = null;
        if (JSONArray.class.isAssignableFrom(source)) {
            result = this.addVariant(result, VARIANT_JSON);
        } else if (JSONObject.class.isAssignableFrom(source)) {
            result = this.addVariant(result, VARIANT_JSON);
        } else if (JSONTokener.class.isAssignableFrom(source)) {
            result = this.addVariant(result, VARIANT_JSON);
        }
        return result;
    }

    public float score(Object source, Variant target, Resource resource) {
        float result = -1.0f;
        if (source instanceof JSONArray || source instanceof JSONObject || source instanceof JSONTokener) {
            result = target == null ? 0.5f : (MediaType.APPLICATION_JSON.isCompatible((Metadata)target.getMediaType()) ? 1.0f : 0.5f);
        }
        return result;
    }

    public <T> float score(Representation source, Class<T> target, Resource resource) {
        float result = -1.0f;
        if (target != null) {
            if (JsonRepresentation.class.isAssignableFrom(target)) {
                result = 1.0f;
            } else if (JSONArray.class.isAssignableFrom(target)) {
                result = MediaType.APPLICATION_JSON.isCompatible((Metadata)source.getMediaType()) ? 1.0f : 0.5f;
            } else if (JSONObject.class.isAssignableFrom(target)) {
                result = MediaType.APPLICATION_JSON.isCompatible((Metadata)source.getMediaType()) ? 1.0f : 0.5f;
            } else if (JSONTokener.class.isAssignableFrom(target)) {
                result = MediaType.APPLICATION_JSON.isCompatible((Metadata)source.getMediaType()) ? 1.0f : 0.5f;
            }
        }
        return result;
    }

    public <T> T toObject(Representation source, Class<T> target, Resource resource) throws IOException {
        Object result = null;
        if (JSONArray.class.isAssignableFrom(target)) {
            try {
                result = new JSONArray(source.getText());
            }
            catch (JSONException e) {
                IOException ioe = new IOException("Unable to convert to JSON array");
                ioe.initCause(e);
            }
        } else if (JSONObject.class.isAssignableFrom(target)) {
            try {
                result = new JSONObject(source.getText());
            }
            catch (JSONException e) {
                IOException ioe = new IOException("Unable to convert to JSON object");
                ioe.initCause(e);
                throw ioe;
            }
        } else if (JSONTokener.class.isAssignableFrom(target)) {
            result = new JSONTokener(source.getText());
        } else if (JsonRepresentation.class.isAssignableFrom(target)) {
            result = new JsonRepresentation(source);
        }
        return (T)result;
    }

    public Representation toRepresentation(Object source, Variant target, Resource resource) {
        JsonRepresentation result = null;
        if (source instanceof JSONArray) {
            result = new JsonRepresentation((JSONArray)source);
        } else if (source instanceof JSONObject) {
            result = new JsonRepresentation((JSONObject)source);
        } else if (source instanceof JSONTokener) {
            result = new JsonRepresentation((JSONTokener)source);
        }
        return result;
    }

    public <T> void updatePreferences(List<Preference<MediaType>> preferences, Class<T> entity) {
        if (JSONArray.class.isAssignableFrom(entity) || JSONObject.class.isAssignableFrom(entity) || JSONTokener.class.isAssignableFrom(entity)) {
            this.updatePreferences(preferences, MediaType.APPLICATION_JSON, 1.0f);
        }
    }
}

