/*
 * Decompiled with CFR 0.152.
 */
package org.restlet.ext.ssl.internal;

import java.io.IOException;
import java.nio.ByteBuffer;
import javax.net.ssl.SSLEngineResult;
import org.restlet.engine.io.Buffer;
import org.restlet.engine.io.IoState;
import org.restlet.engine.io.WakeupListener;
import org.restlet.engine.io.WritableBufferedChannel;
import org.restlet.engine.io.WritableSelectionChannel;
import org.restlet.ext.ssl.internal.SslConnection;
import org.restlet.ext.ssl.internal.TasksListener;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class WritableSslChannel
extends WritableBufferedChannel
implements TasksListener {
    private final SslConnection<?> connection;

    public WritableSslChannel(WritableSelectionChannel target, SslConnection<?> connection, WakeupListener wakeupListener) {
        super(new Buffer(connection.getPacketBufferSize(), connection.getHelper().isDirectBuffers()), target, wakeupListener);
        this.connection = connection;
    }

    public boolean canLoop(Buffer buffer, Object ... args) {
        return this.getConnection().getOutboundWay().canLoop(buffer, args) || this.getConnection().isSslHandshaking();
    }

    public boolean couldFill(Buffer buffer, Object ... args) {
        return super.couldFill(buffer, args) && this.getConnection().getSslEngineStatus() != SSLEngineResult.Status.CLOSED && (this.getConnection().getSslHandshakeStatus() == SSLEngineResult.HandshakeStatus.NOT_HANDSHAKING || this.getConnection().getSslHandshakeStatus() == SSLEngineResult.HandshakeStatus.NEED_WRAP);
    }

    protected SslConnection<?> getConnection() {
        return this.connection;
    }

    @Override
    public void onCompleted() {
        if (this.getConnection().getOutboundWay().getIoState() == IoState.IDLE) {
            this.getConnection().getOutboundWay().setIoState(IoState.INTEREST);
        }
    }

    public int onFill(Buffer buffer, Object ... args) throws IOException {
        int srcSize = buffer.remaining();
        ByteBuffer applicationBuffer = (ByteBuffer)args[0];
        SSLEngineResult sslResult = this.getConnection().getSslEngine().wrap(applicationBuffer, buffer.getBytes());
        this.getConnection().setSslResult(sslResult);
        return srcSize - buffer.remaining();
    }

    public void postProcess(int drained) throws IOException {
        this.getConnection().handleSslResult();
    }

    public int write(ByteBuffer sourceBuffer) throws IOException {
        return super.write(sourceBuffer);
    }
}

