/*
 * Decompiled with CFR 0.152.
 */
package org.restlet.ext.xdb;

import java.io.IOException;
import java.sql.CallableStatement;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.Enumeration;
import java.util.logging.Logger;
import javax.servlet.ServletContext;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.restlet.Context;
import org.restlet.Request;
import org.restlet.Response;
import org.restlet.Restlet;
import org.restlet.data.Reference;
import org.restlet.engine.adapter.HttpRequest;
import org.restlet.engine.adapter.HttpResponse;
import org.restlet.engine.adapter.ServerAdapter;
import org.restlet.engine.adapter.ServerCall;
import org.restlet.ext.servlet.internal.ServletLogger;
import org.restlet.ext.xdb.XdbServerServlet;
import org.restlet.ext.xdb.internal.XdbServletCall;

public class XdbServletAdapter
extends ServerAdapter {
    private volatile Restlet target;
    private volatile Connection conn;
    private volatile String localAddress = null;
    private volatile int localPort = -1;

    public XdbServletAdapter(ServletContext context) {
        this(context, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    public XdbServletAdapter(ServletContext context, Restlet target) {
        super(new Context((Logger)new ServletLogger(context)));
        this.target = target;
        CallableStatement preparedstatement = null;
        try {
            this.conn = XdbServerServlet.getConnection();
            int endPoint = 1;
            preparedstatement = this.conn.prepareCall("{ call dbms_xdb.getListenerEndPoint(1,?,?,?) }");
            preparedstatement.registerOutParameter(1, 12);
            preparedstatement.registerOutParameter(2, 4);
            preparedstatement.registerOutParameter(3, 4);
            preparedstatement.execute();
            this.localAddress = preparedstatement.getString(1);
            if (this.localAddress == null) {
                this.localAddress = "127.0.0.1";
            }
            this.localPort = preparedstatement.getInt(2);
            endPoint = preparedstatement.getInt(3);
            this.getLogger().info("[Restlet Framework] - The ServerServlet address = " + this.localAddress + " port = " + this.localPort + " endPoint = " + endPoint);
        }
        catch (ServletException e) {
            context.log("Failed to get SQL Connection", (Throwable)e);
            XdbServerServlet.closeDbResources(preparedstatement, null);
        }
        catch (SQLException s) {
            context.log("Failed to get Listener Endpoint", (Throwable)s);
            {
                catch (Throwable throwable) {
                    XdbServerServlet.closeDbResources(preparedstatement, null);
                    throw throwable;
                }
            }
            XdbServerServlet.closeDbResources(preparedstatement, null);
        }
        XdbServerServlet.closeDbResources(preparedstatement, null);
    }

    public Reference getBaseRef(HttpServletRequest request) {
        Reference result = null;
        String requestUrl = request.getServletPath() + request.getRequestURI();
        result = new Reference(requestUrl);
        return result;
    }

    public Reference getRootRef(HttpServletRequest request) {
        return this.getBaseRef(request);
    }

    public Restlet getTarget() {
        return this.target;
    }

    public void service(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        if (this.getTarget() != null) {
            Context.setCurrent((Context)this.getContext());
            XdbServletCall servletCall = new XdbServletCall(this.localAddress, this.localPort, request, response);
            HttpRequest httpRequest = this.toRequest(servletCall);
            HttpResponse httpResponse = new HttpResponse((ServerCall)servletCall, (Request)httpRequest);
            httpRequest.getResourceRef().setBaseRef(this.getBaseRef(request));
            httpRequest.setRootRef(this.getRootRef(request));
            this.getTarget().handle((Request)httpRequest, (Response)httpResponse);
            this.commit(httpResponse);
        } else {
            this.getLogger().warning("Unable to find the Restlet target");
        }
    }

    public void setTarget(Restlet target) {
        this.target = target;
    }

    public HttpRequest toRequest(XdbServletCall servletCall) {
        HttpRequest result = super.toRequest((ServerCall)servletCall);
        Enumeration namesEnum = servletCall.getRequest().getAttributeNames();
        while (namesEnum.hasMoreElements()) {
            String attributeName = (String)namesEnum.nextElement();
            result.getAttributes().put(attributeName, servletCall.getRequest().getAttribute(attributeName));
        }
        return result;
    }
}

