/*
 * Decompiled with CFR 0.152.
 */
package com.google.gdata.data.extensions;

import com.google.gdata.client.CoreErrorDomain;
import com.google.gdata.data.Extension;
import com.google.gdata.data.ExtensionDescription;
import com.google.gdata.data.ExtensionPoint;
import com.google.gdata.data.ExtensionProfile;
import com.google.gdata.util.ErrorContent;
import com.google.gdata.util.Namespaces;
import com.google.gdata.util.ParseException;
import com.google.gdata.util.XmlParser;
import com.google.gdata.util.common.xml.XmlWriter;
import java.io.IOException;
import java.util.ArrayList;
import org.xml.sax.Attributes;

public class Image
extends ExtensionPoint
implements Extension {
    protected String rel;
    protected Integer width;
    protected Integer height;
    protected String src;

    public String getRel() {
        return this.rel;
    }

    public void setRel(String v) {
        this.rel = v;
    }

    public int getWidth() {
        return this.width;
    }

    public void setWidth(int w) {
        this.width = w;
    }

    public int getHeight() {
        return this.height;
    }

    public void setHeight(int w) {
        this.height = w;
    }

    public String getSrc() {
        return this.src;
    }

    public void setSrc(String s) {
        this.src = s;
    }

    public static ExtensionDescription getDefaultDescription() {
        ExtensionDescription desc = new ExtensionDescription();
        desc.setExtensionClass(Image.class);
        desc.setNamespace(Namespaces.gNs);
        desc.setLocalName("image");
        desc.setRepeatable(true);
        return desc;
    }

    public void generate(XmlWriter w, ExtensionProfile extProfile) throws IOException {
        ArrayList<XmlWriter.Attribute> attrs = new ArrayList<XmlWriter.Attribute>();
        if (this.rel != null) {
            attrs.add(new XmlWriter.Attribute("rel", this.rel));
        }
        if (this.width != null) {
            attrs.add(new XmlWriter.Attribute("width", this.width.toString()));
        }
        if (this.height != null) {
            attrs.add(new XmlWriter.Attribute("height", this.height.toString()));
        }
        if (this.src != null) {
            attrs.add(new XmlWriter.Attribute("src", this.src));
        }
        this.generateStartElement(w, Namespaces.gNs, "image", attrs, null);
        this.generateExtensions(w, extProfile);
        w.endElement(Namespaces.gNs, "image");
    }

    public XmlParser.ElementHandler getHandler(ExtensionProfile extProfile, String namespace, String localName, Attributes attrs) {
        return new Handler(extProfile);
    }

    private class Handler
    extends ExtensionPoint.ExtensionHandler {
        public Handler(ExtensionProfile extProfile) {
            super((ExtensionPoint)Image.this, extProfile, Image.class);
        }

        public void processAttribute(String namespace, String localName, String value) throws NumberFormatException {
            if (namespace.equals("")) {
                if (localName.equals("rel")) {
                    Image.this.rel = value;
                } else if (localName.equals("width")) {
                    Image.this.width = Integer.parseInt(value);
                } else if (localName.equals("height")) {
                    Image.this.height = Integer.parseInt(value);
                } else if (localName.equals("src")) {
                    Image.this.src = value;
                }
            }
        }

        public void processEndElement() throws ParseException {
            if (Image.this.src == null) {
                throw new ParseException((ErrorContent)CoreErrorDomain.ERR.missingSrcAttribute);
            }
        }
    }

    public static final class Rel {
        public static final String FULL = null;
        public static final String SCALABLE = "http://schemas.google.com/g/2005#scalable";
        public static final String RESIZED = "http://schemas.google.com/g/2005#resized";
        public static final String THUMBNAIL = "http://schemas.google.com/g/2005#thumbnail";
        public static final String RAW = "http://schemas.google.com/g/2005#raw";
    }
}

