package org.richfaces.renderkit.html;

import java.io.IOException;
import java.util.Map;
import javax.faces.component.UIComponent;
import javax.faces.context.FacesContext;
import javax.faces.context.ResponseWriter;
import org.richfaces.renderkit.DataScrollerBaseRenderer;
import org.richfaces.renderkit.RenderKitUtils;
import static org.richfaces.renderkit.RenderKitUtils.*;
import org.richfaces.renderkit.RenderKitUtils.Attributes;
import org.richfaces.renderkit.RenderKitUtils.ScriptHashVariableWrapper;


public class DataScrollerRenderer extends DataScrollerBaseRenderer {
	
private static final Attributes PASS_THROUGH_ATTRIBUTES15 = attributes()
	     .generic("title","title")
	     
;
	
	
private static String convertToString(Object object) 
 {
		return object != null ? object.toString() : "";
	}
	
private static boolean convertToBoolean(Object object) 
 {
		if (object == null) {
    return false;
}

if (object instanceof Boolean) {
    return Boolean.TRUE.equals(object);
}

return Boolean.valueOf(object.toString());

	}
	
@Override
public void encodeEnd(FacesContext facesContext, UIComponent component) 
		throws IOException
	 {
		ResponseWriter responseWriter = facesContext.getResponseWriter(); 
String clientId = component.getClientId(facesContext);
org.richfaces.renderkit.ControlsState controlsState  =  this.getControlsState(facesContext,component); 
Object style  =  component.getAttributes().get("style"); 
Object styleClass  =  component.getAttributes().get("styleClass"); 
responseWriter.startElement("span", component); 
   {
      String value = "rf-ds " + convertToString(styleClass);
      if(null != value &&
         value.length()>0
      ) {
        responseWriter.writeAttribute("class",value,null);
      }
      
   }

   {
      String value = clientId;
      if(null != value &&
         value.length()>0
      ) {
        responseWriter.writeAttribute("id",value,null);
      }
      
   }

   {
      Object value = (convertToBoolean(this.shouldRender(component)) ? style : "display:none");
      if(null != value &&
      shouldRenderAttribute(value)
      ) {
        responseWriter.writeAttribute("style",value,null);
      }
      
   }


	
renderPassThroughAttributes(facesContext, component, 
	PASS_THROUGH_ATTRIBUTES15);

	if (convertToBoolean(this.shouldRender(component))) {
		if (convertToBoolean(controlsState.getFirstRendered())) {
	boolean isEnabled  =  controlsState.getFirstEnabled(); 
	UIComponent facet  =  component.getFacet("first"); 
	String enabledStyles  =  "rf-ds-btn rf-ds-btn-first"; 
	String disabledStyles  =  "rf-ds-btn rf-ds-btn-first rf-ds-dis"; 
	String id  =  convertToString(clientId) + "_ds_f"; 
	String defaultText  =  "\u00AB\u00AB\u00AB\u00AB"; 
		if (convertToBoolean(isEnabled)) {
	responseWriter.startElement("a", component); 
	   {
      Object value = enabledStyles;
      if(null != value &&
      shouldRenderAttribute(value)
      ) {
        responseWriter.writeAttribute("class",value,null);
      }
      
   }

  responseWriter.writeURIAttribute("href","javascript:void(0);",null);

   {
      Object value = id;
      if(null != value &&
      shouldRenderAttribute(value)
      ) {
        responseWriter.writeAttribute("id",value,null);
      }
      
   }


		if ((facet != null)) {
	encodeFacet(facesContext, facet);;
	} else  { 
	{
	Object text = defaultText;
	if (text != null) {
		responseWriter.writeText(text, null); 
	}
}

}
	responseWriter.endElement("a"); 
	} else  { 
	responseWriter.startElement("span", component); 
	   {
      Object value = disabledStyles;
      if(null != value &&
      shouldRenderAttribute(value)
      ) {
        responseWriter.writeAttribute("class",value,null);
      }
      
   }

   {
      Object value = id;
      if(null != value &&
      shouldRenderAttribute(value)
      ) {
        responseWriter.writeAttribute("id",value,null);
      }
      
   }


		if ((facet != null)) {
	encodeFacet(facesContext, facet);;
	} else  { 
	{
	Object text = defaultText;
	if (text != null) {
		responseWriter.writeText(text, null); 
	}
}

}
	responseWriter.endElement("span"); 
}
}
		if (convertToBoolean(controlsState.getFastRewindRendered())) {
	boolean isEnabled  =  controlsState.getFastRewindEnabled(); 
	UIComponent facet  =  component.getFacet("fastRewind"); 
	String enabledStyles  =  "rf-ds-btn rf-ds-btn-fastrwd"; 
	String disabledStyles  =  "rf-ds-btn rf-ds-btn-fastrwd rf-ds-dis"; 
	String id  =  convertToString(clientId) + "_ds_fr"; 
	String defaultText  =  "\u00AB\u00AB"; 
		if (convertToBoolean(isEnabled)) {
	responseWriter.startElement("a", component); 
	   {
      Object value = enabledStyles;
      if(null != value &&
      shouldRenderAttribute(value)
      ) {
        responseWriter.writeAttribute("class",value,null);
      }
      
   }

  responseWriter.writeURIAttribute("href","javascript:void(0);",null);

   {
      Object value = id;
      if(null != value &&
      shouldRenderAttribute(value)
      ) {
        responseWriter.writeAttribute("id",value,null);
      }
      
   }


		if ((facet != null)) {
	encodeFacet(facesContext, facet);;
	} else  { 
	{
	Object text = defaultText;
	if (text != null) {
		responseWriter.writeText(text, null); 
	}
}

}
	responseWriter.endElement("a"); 
	} else  { 
	responseWriter.startElement("span", component); 
	   {
      Object value = disabledStyles;
      if(null != value &&
      shouldRenderAttribute(value)
      ) {
        responseWriter.writeAttribute("class",value,null);
      }
      
   }

   {
      Object value = id;
      if(null != value &&
      shouldRenderAttribute(value)
      ) {
        responseWriter.writeAttribute("id",value,null);
      }
      
   }


		if ((facet != null)) {
	encodeFacet(facesContext, facet);;
	} else  { 
	{
	Object text = defaultText;
	if (text != null) {
		responseWriter.writeText(text, null); 
	}
}

}
	responseWriter.endElement("span"); 
}
}
		if (convertToBoolean(controlsState.getPreviousRendered())) {
	Object isEnabled  =  controlsState.getPreviousEnabled(); 
	UIComponent facet  =  component.getFacet("previous"); 
	String enabledStyles  =  "rf-ds-btn rf-ds-btn-prev"; 
	String disabledStyles  =  "rf-ds-btn rf-ds-btn-prev rf-ds-dis"; 
	String id  =  convertToString(clientId) + "_ds_prev"; 
	String defaultText  =  "\u00AB"; 
		if (convertToBoolean(isEnabled)) {
	responseWriter.startElement("a", component); 
	   {
      Object value = enabledStyles;
      if(null != value &&
      shouldRenderAttribute(value)
      ) {
        responseWriter.writeAttribute("class",value,null);
      }
      
   }

  responseWriter.writeURIAttribute("href","javascript:void(0);",null);

   {
      Object value = id;
      if(null != value &&
      shouldRenderAttribute(value)
      ) {
        responseWriter.writeAttribute("id",value,null);
      }
      
   }


		if ((facet != null)) {
	encodeFacet(facesContext, facet);;
	} else  { 
	{
	Object text = defaultText;
	if (text != null) {
		responseWriter.writeText(text, null); 
	}
}

}
	responseWriter.endElement("a"); 
	} else  { 
	responseWriter.startElement("span", component); 
	   {
      Object value = disabledStyles;
      if(null != value &&
      shouldRenderAttribute(value)
      ) {
        responseWriter.writeAttribute("class",value,null);
      }
      
   }

   {
      Object value = id;
      if(null != value &&
      shouldRenderAttribute(value)
      ) {
        responseWriter.writeAttribute("id",value,null);
      }
      
   }


		if ((facet != null)) {
	encodeFacet(facesContext, facet);;
	} else  { 
	{
	Object text = defaultText;
	if (text != null) {
		responseWriter.writeText(text, null); 
	}
}

}
	responseWriter.endElement("span"); 
}
}
	Map digitals  =  this.renderPager(responseWriter,facesContext,component); 
		if (convertToBoolean(controlsState.getNextRendered())) {
	Object isEnabled  =  controlsState.getNextEnabled(); 
	UIComponent facet  =  component.getFacet("next"); 
	String enabledStyles  =  "rf-ds-btn rf-ds-btn-next"; 
	String disabledStyles  =  "rf-ds-btn rf-ds-btn-next rf-ds-dis"; 
	String id  =  convertToString(clientId) + "_ds_next"; 
	String defaultText  =  "\u00BB"; 
		if (convertToBoolean(isEnabled)) {
	responseWriter.startElement("a", component); 
	   {
      Object value = enabledStyles;
      if(null != value &&
      shouldRenderAttribute(value)
      ) {
        responseWriter.writeAttribute("class",value,null);
      }
      
   }

  responseWriter.writeURIAttribute("href","javascript:void(0);",null);

   {
      Object value = id;
      if(null != value &&
      shouldRenderAttribute(value)
      ) {
        responseWriter.writeAttribute("id",value,null);
      }
      
   }


		if ((facet != null)) {
	encodeFacet(facesContext, facet);;
	} else  { 
	{
	Object text = defaultText;
	if (text != null) {
		responseWriter.writeText(text, null); 
	}
}

}
	responseWriter.endElement("a"); 
	} else  { 
	responseWriter.startElement("span", component); 
	   {
      Object value = disabledStyles;
      if(null != value &&
      shouldRenderAttribute(value)
      ) {
        responseWriter.writeAttribute("class",value,null);
      }
      
   }

   {
      Object value = id;
      if(null != value &&
      shouldRenderAttribute(value)
      ) {
        responseWriter.writeAttribute("id",value,null);
      }
      
   }


		if ((facet != null)) {
	encodeFacet(facesContext, facet);;
	} else  { 
	{
	Object text = defaultText;
	if (text != null) {
		responseWriter.writeText(text, null); 
	}
}

}
	responseWriter.endElement("span"); 
}
}
		if (convertToBoolean(controlsState.getFastForwardRendered())) {
	Object isEnabled  =  controlsState.getFastForwardEnabled(); 
	UIComponent facet  =  component.getFacet("fastForward"); 
	String enabledStyles  =  "rf-ds-btn rf-ds-btn-fastfwd"; 
	String disabledStyles  =  "rf-ds-btn rf-ds-btn-fastfwd rf-ds-dis"; 
	String id  =  convertToString(clientId) + "_ds_ff"; 
	String defaultText  =  "\u00BB\u00BB"; 
		if (convertToBoolean(isEnabled)) {
	responseWriter.startElement("a", component); 
	   {
      Object value = enabledStyles;
      if(null != value &&
      shouldRenderAttribute(value)
      ) {
        responseWriter.writeAttribute("class",value,null);
      }
      
   }

  responseWriter.writeURIAttribute("href","javascript:void(0);",null);

   {
      Object value = id;
      if(null != value &&
      shouldRenderAttribute(value)
      ) {
        responseWriter.writeAttribute("id",value,null);
      }
      
   }


		if ((facet != null)) {
	encodeFacet(facesContext, facet);;
	} else  { 
	{
	Object text = defaultText;
	if (text != null) {
		responseWriter.writeText(text, null); 
	}
}

}
	responseWriter.endElement("a"); 
	} else  { 
	responseWriter.startElement("span", component); 
	   {
      Object value = disabledStyles;
      if(null != value &&
      shouldRenderAttribute(value)
      ) {
        responseWriter.writeAttribute("class",value,null);
      }
      
   }

   {
      Object value = id;
      if(null != value &&
      shouldRenderAttribute(value)
      ) {
        responseWriter.writeAttribute("id",value,null);
      }
      
   }


		if ((facet != null)) {
	encodeFacet(facesContext, facet);;
	} else  { 
	{
	Object text = defaultText;
	if (text != null) {
		responseWriter.writeText(text, null); 
	}
}

}
	responseWriter.endElement("span"); 
}
}
		if (convertToBoolean(controlsState.getLastRendered())) {
	Object isEnabled  =  controlsState.getLastEnabled(); 
	UIComponent facet  =  component.getFacet("last"); 
	String enabledStyles  =  "rf-ds-btn rf-ds-btn-last"; 
	String disabledStyles  =  "rf-ds-btn rf-ds-btn-last rf-ds-dis"; 
	String id  =  convertToString(clientId) + "_ds_l"; 
	String defaultText  =  "\u00BB\u00BB\u00BB\u00BB"; 
		if (convertToBoolean(isEnabled)) {
	responseWriter.startElement("a", component); 
	   {
      Object value = enabledStyles;
      if(null != value &&
      shouldRenderAttribute(value)
      ) {
        responseWriter.writeAttribute("class",value,null);
      }
      
   }

  responseWriter.writeURIAttribute("href","javascript:void(0);",null);

   {
      Object value = id;
      if(null != value &&
      shouldRenderAttribute(value)
      ) {
        responseWriter.writeAttribute("id",value,null);
      }
      
   }


		if ((facet != null)) {
	encodeFacet(facesContext, facet);;
	} else  { 
	{
	Object text = defaultText;
	if (text != null) {
		responseWriter.writeText(text, null); 
	}
}

}
	responseWriter.endElement("a"); 
	} else  { 
	responseWriter.startElement("span", component); 
	   {
      Object value = disabledStyles;
      if(null != value &&
      shouldRenderAttribute(value)
      ) {
        responseWriter.writeAttribute("class",value,null);
      }
      
   }

   {
      Object value = id;
      if(null != value &&
      shouldRenderAttribute(value)
      ) {
        responseWriter.writeAttribute("id",value,null);
      }
      
   }


		if ((facet != null)) {
	encodeFacet(facesContext, facet);;
	} else  { 
	{
	Object text = defaultText;
	if (text != null) {
		responseWriter.writeText(text, null); 
	}
}

}
	responseWriter.endElement("span"); 
}
}
	Map buttons  =  this.getControls(facesContext,component,controlsState); 
	responseWriter.startElement("script", component); 
	  responseWriter.writeAttribute("type","text/javascript",null);


	buildScript(responseWriter, facesContext, component, buttons, digitals);;
	responseWriter.endElement("script"); 
}
responseWriter.endElement("span"); 

	}
}

