/*
 * Decompiled with CFR 0.152.
 */
package org.riftsaw.engine.osgi;

import java.util.Map;
import java.util.Properties;
import javax.persistence.EntityManager;
import javax.persistence.EntityManagerFactory;
import javax.persistence.spi.PersistenceProvider;
import javax.sql.DataSource;
import javax.transaction.TransactionManager;
import org.apache.ode.dao.jpa.JpaConnection;
import org.apache.ode.dao.jpa.JpaOperator;
import org.apache.ode.dao.jpa.hibernate.HibernateUtil;
import org.apache.ode.dao.jpa.hibernate.JpaOperatorImpl;
import org.apache.ode.dao.jpa.store.ConfStoreDAOConnectionImpl;
import org.apache.ode.dao.store.ConfStoreDAOConnection;
import org.apache.ode.dao.store.ConfStoreDAOConnectionFactory;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleContext;
import org.osgi.framework.FrameworkUtil;
import org.osgi.framework.ServiceReference;

public class ConfStoreDAOConnectionFactoryImpl
implements ConfStoreDAOConnectionFactory {
    private EntityManagerFactory _emf;
    private TransactionManager _txm;
    private DataSource _ds;
    private JpaOperator _operator = new JpaOperatorImpl();

    public void init(Properties odeConfig, TransactionManager txm, Object env) {
        this._txm = txm;
        this._ds = (DataSource)env;
        Bundle thisBundle = FrameworkUtil.getBundle(this.getClass());
        BundleContext context = thisBundle.getBundleContext();
        ServiceReference serviceReference = context.getServiceReference(PersistenceProvider.class.getName());
        PersistenceProvider persistenceProvider = (PersistenceProvider)context.getService(serviceReference);
        Map emfProperties = HibernateUtil.buildConfig((String)"dao.factory.store.", (Properties)odeConfig, (TransactionManager)this._txm, (DataSource)this._ds);
        this._emf = persistenceProvider.createEntityManagerFactory("ode-store", emfProperties);
    }

    public ConfStoreDAOConnection getConnection() {
        ThreadLocal currentConnection = ConfStoreDAOConnectionImpl.getThreadLocal();
        ConfStoreDAOConnectionImpl conn = (ConfStoreDAOConnectionImpl)currentConnection.get();
        if (conn != null && HibernateUtil.isOpen((JpaConnection)conn)) {
            return conn;
        }
        EntityManager em = this._emf.createEntityManager();
        conn = new ConfStoreDAOConnectionImpl(em, this._txm, this._operator);
        currentConnection.set(conn);
        return conn;
    }

    public void shutdown() {
        this._emf.close();
    }
}

