/*
 * Decompiled with CFR 0.152.
 */
package org.robolectric.android;

import android.content.res.Resources;
import android.content.res.XmlResourceParser;
import com.android.internal.util.XmlUtils;
import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.util.Arrays;
import java.util.List;
import org.robolectric.res.AttributeResource;
import org.robolectric.res.ResName;
import org.robolectric.res.ResourceTable;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.xmlpull.v1.XmlPullParser;
import org.xmlpull.v1.XmlPullParserException;

public class XmlResourceParserImpl
implements XmlResourceParser {
    public static final String[] AVAILABLE_FEATURES = new String[]{"http://xmlpull.org/v1/doc/features.html#process-namespaces", "http://xmlpull.org/v1/doc/features.html#report-namespace-prefixes"};
    public static final String[] UNAVAILABLE_FEATURES = new String[]{"http://xmlpull.org/v1/doc/features.html#process-docdecl", "http://xmlpull.org/v1/doc/features.html#validation"};
    private final Document document;
    private final String fileName;
    private final String packageName;
    private final ResourceTable resourceTable;
    private final String applicationNamespace;
    private Node currentNode;
    private boolean mStarted = false;
    private boolean mDecNextDepth = false;
    private int mDepth = 0;
    private int mEventType = 0;

    public XmlResourceParserImpl(Document document, String fileName, String packageName, String applicationPackageName, ResourceTable resourceTable) {
        this.document = document;
        this.fileName = fileName;
        this.packageName = packageName;
        this.resourceTable = resourceTable;
        this.applicationNamespace = "http://schemas.android.com/apk/res/" + applicationPackageName;
    }

    public void setFeature(String name, boolean state) throws XmlPullParserException {
        if (XmlResourceParserImpl.isAndroidSupportedFeature(name) && state) {
            return;
        }
        throw new XmlPullParserException("Unsupported feature: " + name);
    }

    public boolean getFeature(String name) {
        return XmlResourceParserImpl.isAndroidSupportedFeature(name);
    }

    public void setProperty(String name, Object value) throws XmlPullParserException {
        throw new XmlPullParserException("setProperty() not supported");
    }

    public Object getProperty(String name) {
        return null;
    }

    public void setInput(Reader in) throws XmlPullParserException {
        throw new XmlPullParserException("setInput() not supported");
    }

    public void setInput(InputStream inputStream, String inputEncoding) throws XmlPullParserException {
        throw new XmlPullParserException("setInput() not supported");
    }

    public void defineEntityReplacementText(String entityName, String replacementText) throws XmlPullParserException {
        throw new XmlPullParserException("defineEntityReplacementText() not supported");
    }

    public String getNamespacePrefix(int pos) throws XmlPullParserException {
        throw new XmlPullParserException("getNamespacePrefix() not supported");
    }

    public String getInputEncoding() {
        return null;
    }

    public String getNamespace(String prefix) {
        throw new RuntimeException("getNamespaceCount() not supported");
    }

    public int getNamespaceCount(int depth) throws XmlPullParserException {
        throw new XmlPullParserException("getNamespaceCount() not supported");
    }

    public String getPositionDescription() {
        return "XML file " + this.fileName + " line #" + this.getLineNumber() + " (sorry, not yet implemented)";
    }

    public String getNamespaceUri(int pos) throws XmlPullParserException {
        throw new XmlPullParserException("getNamespaceUri() not supported");
    }

    public int getColumnNumber() {
        return -1;
    }

    public int getDepth() {
        return this.mDepth;
    }

    public String getText() {
        if (this.currentNode == null) {
            return "";
        }
        return this.currentNode.getTextContent();
    }

    public int getLineNumber() {
        return -1;
    }

    public int getEventType() throws XmlPullParserException {
        return this.mEventType;
    }

    public boolean isWhitespace(String text) throws XmlPullParserException {
        if (text == null) {
            return false;
        }
        return text.split("\\s").length == 0;
    }

    public boolean isWhitespace() throws XmlPullParserException {
        return this.isWhitespace(this.getText());
    }

    public String getPrefix() {
        throw new RuntimeException("getPrefix not supported");
    }

    public char[] getTextCharacters(int[] holderForStartAndLength) {
        String txt = this.getText();
        char[] chars = null;
        if (txt != null) {
            holderForStartAndLength[0] = 0;
            holderForStartAndLength[1] = txt.length();
            chars = new char[txt.length()];
            txt.getChars(0, txt.length(), chars, 0);
        }
        return chars;
    }

    public String getNamespace() {
        String namespace;
        String string = namespace = this.currentNode != null ? this.currentNode.getNamespaceURI() : null;
        if (namespace == null) {
            return "";
        }
        return this.maybeReplaceNamespace(namespace);
    }

    public String getName() {
        if (this.currentNode == null) {
            return "";
        }
        return this.currentNode.getNodeName();
    }

    Node getAttributeAt(int index) {
        if (this.currentNode == null) {
            throw new IndexOutOfBoundsException(String.valueOf(index));
        }
        NamedNodeMap map = this.currentNode.getAttributes();
        if (index >= map.getLength()) {
            throw new IndexOutOfBoundsException(String.valueOf(index));
        }
        return map.item(index);
    }

    public String getAttribute(String namespace, String name) {
        if (this.currentNode == null) {
            return null;
        }
        Element element = (Element)this.currentNode;
        if (element.hasAttributeNS(namespace, name)) {
            return element.getAttributeNS(namespace, name).trim();
        }
        if (this.applicationNamespace.equals(namespace) && element.hasAttributeNS("http://schemas.android.com/apk/res-auto", name)) {
            return element.getAttributeNS("http://schemas.android.com/apk/res-auto", name).trim();
        }
        return null;
    }

    public String getAttributeNamespace(int index) {
        Node attr = this.getAttributeAt(index);
        if (attr == null) {
            return null;
        }
        return this.maybeReplaceNamespace(attr.getNamespaceURI());
    }

    private String maybeReplaceNamespace(String namespace) {
        if ("http://schemas.android.com/apk/res-auto".equals(namespace)) {
            return this.applicationNamespace;
        }
        return namespace;
    }

    public String getAttributeName(int index) {
        try {
            Node attr = this.getAttributeAt(index);
            String namespace = this.maybeReplaceNamespace(attr.getNamespaceURI());
            return this.applicationNamespace.equals(namespace) ? attr.getLocalName() : attr.getNodeName();
        }
        catch (IndexOutOfBoundsException ex) {
            return null;
        }
    }

    public String getAttributePrefix(int index) {
        throw new RuntimeException("getAttributePrefix not supported");
    }

    public boolean isEmptyElementTag() throws XmlPullParserException {
        return false;
    }

    public int getAttributeCount() {
        if (this.currentNode == null) {
            return -1;
        }
        return this.currentNode.getAttributes().getLength();
    }

    public String getAttributeValue(int index) {
        return this.qualify(this.getAttributeAt(index).getNodeValue());
    }

    public String qualify(String value) {
        if (value == null) {
            return null;
        }
        if (AttributeResource.isResourceReference((String)value)) {
            return "@" + ResName.qualifyResourceName((String)value.substring(1).replace("+", ""), (String)this.packageName, (String)"attr");
        }
        if (AttributeResource.isStyleReference((String)value)) {
            return "?" + ResName.qualifyResourceName((String)value.substring(1), (String)this.packageName, (String)"attr");
        }
        return value;
    }

    public String getAttributeType(int index) {
        return "CDATA";
    }

    public boolean isAttributeDefault(int index) {
        return false;
    }

    public int nextToken() throws XmlPullParserException, IOException {
        return this.next();
    }

    public String getAttributeValue(String namespace, String name) {
        return this.qualify(this.getAttribute(namespace, name));
    }

    public int next() throws XmlPullParserException, IOException {
        if (!this.mStarted) {
            this.mStarted = true;
            return 0;
        }
        if (this.mEventType == 1) {
            return 1;
        }
        int ev = this.nativeNext();
        if (this.mDecNextDepth) {
            --this.mDepth;
            this.mDecNextDepth = false;
        }
        switch (ev) {
            case 2: {
                ++this.mDepth;
                break;
            }
            case 3: {
                this.mDecNextDepth = true;
            }
        }
        this.mEventType = ev;
        if (ev == 1) {
            this.close();
        }
        return ev;
    }

    private int nativeNext() throws XmlPullParserException {
        switch (this.mEventType) {
            case 5: {
                throw new IllegalArgumentException("CDSECT is not handled by Android");
            }
            case 9: {
                throw new IllegalArgumentException("COMMENT is not handled by Android");
            }
            case 10: {
                throw new IllegalArgumentException("DOCDECL is not handled by Android");
            }
            case 6: {
                throw new IllegalArgumentException("ENTITY_REF is not handled by Android");
            }
            case 1: {
                throw new IllegalArgumentException("END_DOCUMENT should not be found here.");
            }
            case 3: {
                return this.navigateToNextNode(this.currentNode);
            }
            case 7: {
                throw new IllegalArgumentException("IGNORABLE_WHITESPACE");
            }
            case 8: {
                throw new IllegalArgumentException("PROCESSING_INSTRUCTION");
            }
            case 0: {
                this.currentNode = this.document.getDocumentElement();
                return 2;
            }
            case 2: {
                if (this.currentNode.hasChildNodes()) {
                    return this.processNextNodeType(this.currentNode.getFirstChild());
                }
                return 3;
            }
            case 4: {
                return this.navigateToNextNode(this.currentNode);
            }
        }
        throw new RuntimeException("Robolectric-> Uknown XML event type: " + this.mEventType);
    }

    int processNextNodeType(Node node) throws XmlPullParserException {
        switch (node.getNodeType()) {
            case 2: {
                throw new IllegalArgumentException("ATTRIBUTE_NODE");
            }
            case 4: {
                return this.navigateToNextNode(node);
            }
            case 8: {
                return this.navigateToNextNode(node);
            }
            case 11: {
                throw new IllegalArgumentException("DOCUMENT_FRAGMENT_NODE");
            }
            case 9: {
                throw new IllegalArgumentException("DOCUMENT_NODE");
            }
            case 10: {
                throw new IllegalArgumentException("DOCUMENT_TYPE_NODE");
            }
            case 1: {
                this.currentNode = node;
                return 2;
            }
            case 6: {
                throw new IllegalArgumentException("ENTITY_NODE");
            }
            case 5: {
                throw new IllegalArgumentException("ENTITY_REFERENCE_NODE");
            }
            case 12: {
                throw new IllegalArgumentException("DOCUMENT_TYPE_NODE");
            }
            case 7: {
                throw new IllegalArgumentException("DOCUMENT_TYPE_NODE");
            }
            case 3: {
                if (this.isWhitespace(node.getNodeValue())) {
                    return this.navigateToNextNode(node);
                }
                this.currentNode = node;
                return 4;
            }
        }
        throw new RuntimeException("Robolectric -> Unknown node type: " + node.getNodeType() + ".");
    }

    int navigateToNextNode(Node node) throws XmlPullParserException {
        Node nextNode = node.getNextSibling();
        if (nextNode != null) {
            return this.processNextNodeType(nextNode);
        }
        if (this.document.getDocumentElement().equals(node)) {
            this.currentNode = null;
            return 1;
        }
        this.currentNode = node.getParentNode();
        return 3;
    }

    public void require(int type, String namespace, String name) throws XmlPullParserException, IOException {
        if (type != this.getEventType() || namespace != null && !namespace.equals(this.getNamespace()) || name != null && !name.equals(this.getName())) {
            throw new XmlPullParserException("expected " + TYPES[type] + this.getPositionDescription());
        }
    }

    public String nextText() throws XmlPullParserException, IOException {
        if (this.getEventType() != 2) {
            throw new XmlPullParserException(this.getPositionDescription() + ": parser must be on START_TAG to read next text", (XmlPullParser)this, null);
        }
        int eventType = this.next();
        if (eventType == 4) {
            String result = this.getText();
            eventType = this.next();
            if (eventType != 3) {
                throw new XmlPullParserException(this.getPositionDescription() + ": event TEXT it must be immediately followed by END_TAG", (XmlPullParser)this, null);
            }
            return result;
        }
        if (eventType == 3) {
            return "";
        }
        throw new XmlPullParserException(this.getPositionDescription() + ": parser must be on START_TAG or TEXT to read text", (XmlPullParser)this, null);
    }

    public int nextTag() throws XmlPullParserException, IOException {
        int eventType = this.next();
        if (eventType == 4 && this.isWhitespace()) {
            eventType = this.next();
        }
        if (eventType != 2 && eventType != 3) {
            throw new XmlPullParserException("Expected start or end tag. Found: " + eventType, (XmlPullParser)this, null);
        }
        return eventType;
    }

    public int getAttributeNameResource(int index) {
        return this.getResourceId(this.getAttributeName(index), this.packageName, "attr");
    }

    public int getAttributeListValue(String namespace, String attribute, String[] options, int defaultValue) {
        String attr = this.getAttribute(namespace, attribute);
        if (attr == null) {
            return 0;
        }
        List<String> optList = Arrays.asList(options);
        int index = optList.indexOf(attr);
        if (index == -1) {
            return defaultValue;
        }
        return index;
    }

    public boolean getAttributeBooleanValue(String namespace, String attribute, boolean defaultValue) {
        String attr = this.getAttribute(namespace, attribute);
        if (attr == null) {
            return defaultValue;
        }
        return Boolean.parseBoolean(attr);
    }

    public int getAttributeResourceValue(String namespace, String attribute, int defaultValue) {
        String attr = this.getAttribute(namespace, attribute);
        if (attr != null && attr.startsWith("@") && !AttributeResource.isNull((String)attr)) {
            return this.getResourceId(attr, this.packageName, null);
        }
        return defaultValue;
    }

    public int getAttributeIntValue(String namespace, String attribute, int defaultValue) {
        return XmlUtils.convertValueToInt((CharSequence)this.getAttributeValue(namespace, attribute), (int)defaultValue);
    }

    public int getAttributeUnsignedIntValue(String namespace, String attribute, int defaultValue) {
        int value = this.getAttributeIntValue(namespace, attribute, defaultValue);
        if (value < 0) {
            return defaultValue;
        }
        return value;
    }

    public float getAttributeFloatValue(String namespace, String attribute, float defaultValue) {
        String attr = this.getAttribute(namespace, attribute);
        if (attr == null) {
            return defaultValue;
        }
        try {
            return Float.parseFloat(attr);
        }
        catch (NumberFormatException ex) {
            return defaultValue;
        }
    }

    public int getAttributeListValue(int idx, String[] options, int defaultValue) {
        try {
            String value = this.getAttributeValue(idx);
            List<String> optList = Arrays.asList(options);
            int index = optList.indexOf(value);
            if (index == -1) {
                return defaultValue;
            }
            return index;
        }
        catch (IndexOutOfBoundsException ex) {
            return defaultValue;
        }
    }

    public boolean getAttributeBooleanValue(int idx, boolean defaultValue) {
        try {
            return Boolean.parseBoolean(this.getAttributeValue(idx));
        }
        catch (IndexOutOfBoundsException ex) {
            return defaultValue;
        }
    }

    public int getAttributeResourceValue(int idx, int defaultValue) {
        int resourceId;
        String attributeValue = this.getAttributeValue(idx);
        if (attributeValue != null && attributeValue.startsWith("@") && (resourceId = this.getResourceId(attributeValue.substring(1), this.packageName, null)) != 0) {
            return resourceId;
        }
        return defaultValue;
    }

    public int getAttributeIntValue(int idx, int defaultValue) {
        try {
            return Integer.parseInt(this.getAttributeValue(idx));
        }
        catch (NumberFormatException ex) {
            return defaultValue;
        }
        catch (IndexOutOfBoundsException ex) {
            return defaultValue;
        }
    }

    public int getAttributeUnsignedIntValue(int idx, int defaultValue) {
        int value = this.getAttributeIntValue(idx, defaultValue);
        if (value < 0) {
            return defaultValue;
        }
        return value;
    }

    public float getAttributeFloatValue(int idx, float defaultValue) {
        try {
            return Float.parseFloat(this.getAttributeValue(idx));
        }
        catch (NumberFormatException ex) {
            return defaultValue;
        }
        catch (IndexOutOfBoundsException ex) {
            return defaultValue;
        }
    }

    public String getIdAttribute() {
        return this.getAttribute(null, "id");
    }

    public String getClassAttribute() {
        return this.getAttribute(null, "class");
    }

    public int getIdAttributeResourceValue(int defaultValue) {
        return this.getAttributeResourceValue(null, "id", defaultValue);
    }

    public int getStyleAttribute() {
        String attr = this.getAttribute(null, "style");
        if (attr == null || !AttributeResource.isResourceReference((String)attr) && !AttributeResource.isStyleReference((String)attr)) {
            return 0;
        }
        return this.getResourceId(attr, this.packageName, "style");
    }

    public void close() {
    }

    protected void finalize() throws Throwable {
        this.close();
    }

    private int getResourceId(String possiblyQualifiedResourceName, String defaultPackageName, String defaultType) {
        if (AttributeResource.isNull((String)possiblyQualifiedResourceName)) {
            return 0;
        }
        if (AttributeResource.isStyleReference((String)possiblyQualifiedResourceName)) {
            ResName styleReference = AttributeResource.getStyleReference((String)possiblyQualifiedResourceName, (String)defaultPackageName, (String)"attr");
            Integer resourceId = this.resourceTable.getResourceId(styleReference);
            if (resourceId == null) {
                throw new Resources.NotFoundException(styleReference.getFullyQualifiedName());
            }
            return resourceId;
        }
        if (AttributeResource.isResourceReference((String)possiblyQualifiedResourceName)) {
            ResName resourceReference = AttributeResource.getResourceReference((String)possiblyQualifiedResourceName, (String)defaultPackageName, (String)defaultType);
            Integer resourceId = this.resourceTable.getResourceId(resourceReference);
            if (resourceId == null) {
                throw new Resources.NotFoundException(resourceReference.getFullyQualifiedName());
            }
            return resourceId;
        }
        ResName resName = ResName.qualifyResName((String)(possiblyQualifiedResourceName = XmlResourceParserImpl.removeLeadingSpecialCharsIfAny(possiblyQualifiedResourceName)), (String)defaultPackageName, (String)defaultType);
        Integer resourceId = this.resourceTable.getResourceId(resName);
        return resourceId == null ? 0 : resourceId;
    }

    private static String removeLeadingSpecialCharsIfAny(String name) {
        if (name.startsWith("@+")) {
            return name.substring(2);
        }
        if (name.startsWith("@")) {
            return name.substring(1);
        }
        return name;
    }

    private static boolean isAndroidSupportedFeature(String name) {
        if (name == null) {
            return false;
        }
        for (String feature : AVAILABLE_FEATURES) {
            if (!feature.equals(name)) continue;
            return true;
        }
        return false;
    }
}

