/*
 * Decompiled with CFR 0.152.
 */
package org.robolectric.shadows;

import android.content.ComponentName;
import android.content.Intent;
import android.content.IntentFilter;
import android.content.IntentSender;
import android.content.pm.ActivityInfo;
import android.content.pm.ApplicationInfo;
import android.content.pm.FeatureInfo;
import android.content.pm.IPackageDataObserver;
import android.content.pm.IPackageDeleteObserver;
import android.content.pm.PackageInfo;
import android.content.pm.PackageManager;
import android.content.pm.PackageStats;
import android.content.pm.PathPermission;
import android.content.pm.PermissionInfo;
import android.content.pm.ProviderInfo;
import android.content.pm.ResolveInfo;
import android.content.pm.ServiceInfo;
import android.content.pm.Signature;
import android.content.res.AssetManager;
import android.content.res.Resources;
import android.graphics.drawable.Drawable;
import android.net.Uri;
import android.os.Binder;
import android.os.Bundle;
import android.os.RemoteException;
import android.os.UserHandle;
import android.util.Pair;
import com.google.common.base.Preconditions;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import org.robolectric.RuntimeEnvironment;
import org.robolectric.annotation.Implementation;
import org.robolectric.annotation.Implements;
import org.robolectric.manifest.ActivityData;
import org.robolectric.manifest.AndroidManifest;
import org.robolectric.manifest.BroadcastReceiverData;
import org.robolectric.manifest.ContentProviderData;
import org.robolectric.manifest.IntentFilterData;
import org.robolectric.manifest.PathPermissionData;
import org.robolectric.manifest.PermissionItemData;
import org.robolectric.manifest.ServiceData;
import org.robolectric.res.AttributeResource;
import org.robolectric.res.ResName;
import org.robolectric.util.TempDirectory;

@Implements(value=PackageManager.class)
public class ShadowPackageManager {
    private static final List<Pair<String, Integer>> APPLICATION_FLAGS = Arrays.asList(Pair.create((Object)"android:allowBackup", (Object)32768), Pair.create((Object)"android:allowClearUserData", (Object)64), Pair.create((Object)"android:allowTaskReparenting", (Object)32), Pair.create((Object)"android:debuggable", (Object)2), Pair.create((Object)"android:hasCode", (Object)4), Pair.create((Object)"android:killAfterRestore", (Object)65536), Pair.create((Object)"android:persistent", (Object)8), Pair.create((Object)"android:resizeable", (Object)4096), Pair.create((Object)"android:restoreAnyVersion", (Object)131072), Pair.create((Object)"android:largeScreens", (Object)2048), Pair.create((Object)"android:normalScreens", (Object)1024), Pair.create((Object)"android:anyDensity", (Object)8192), Pair.create((Object)"android:smallScreens", (Object)512), Pair.create((Object)"android:testOnly", (Object)256), Pair.create((Object)"android:vmSafeMode", (Object)16384));
    private static final List<Pair<String, Integer>> CONFIG_OPTIONS = Arrays.asList(Pair.create((Object)"mcc", (Object)1), Pair.create((Object)"mnc", (Object)2), Pair.create((Object)"locale", (Object)4), Pair.create((Object)"touchscreen", (Object)8), Pair.create((Object)"keyboard", (Object)16), Pair.create((Object)"keyboardHidden", (Object)32), Pair.create((Object)"navigation", (Object)64), Pair.create((Object)"screenLayout", (Object)256), Pair.create((Object)"fontScale", (Object)0x40000000), Pair.create((Object)"uiMode", (Object)512), Pair.create((Object)"orientation", (Object)128), Pair.create((Object)"screenSize", (Object)1024), Pair.create((Object)"smallestScreenSize", (Object)2048));
    Map<String, Boolean> permissionRationaleMap = new HashMap<String, Boolean>();
    List<FeatureInfo> systemAvailableFeatures = new LinkedList<FeatureInfo>();
    final Map<String, PackageInfo> packageInfos = new LinkedHashMap<String, PackageInfo>();
    private Map<String, PackageInfo> packageArchiveInfo = new HashMap<String, PackageInfo>();
    final Map<String, PackageStats> packageStatsMap = new HashMap<String, PackageStats>();
    final Map<String, String> packageInstallerMap = new HashMap<String, String>();
    final Map<Integer, String[]> packagesForUid = new HashMap<Integer, String[]>();
    final Map<Integer, String> namesForUid = new HashMap<Integer, String>();
    final Map<Integer, Integer> verificationResults = new HashMap<Integer, Integer>();
    final Map<Integer, Long> verificationTimeoutExtension = new HashMap<Integer, Long>();
    final Map<String, String> currentToCanonicalNames = new HashMap<String, String>();
    final Map<String, AndroidManifest> androidManifests = new LinkedHashMap<String, AndroidManifest>();
    final Map<ComponentName, ComponentState> componentList = new LinkedHashMap<ComponentName, ComponentState>();
    final Map<ComponentName, Drawable> drawableList = new LinkedHashMap<ComponentName, Drawable>();
    final Map<String, Drawable> applicationIcons = new HashMap<String, Drawable>();
    final Map<String, Boolean> systemFeatureList = new LinkedHashMap<String, Boolean>();
    final Map<IntentFilter, ComponentName> preferredActivities = new LinkedHashMap<IntentFilter, ComponentName>();
    final Map<Pair<String, Integer>, Drawable> drawables = new LinkedHashMap<Pair<String, Integer>, Drawable>();
    final Map<String, Integer> applicationEnabledSettingMap = new HashMap<String, Integer>();
    boolean queryIntentImplicitly = false;
    Map<String, PermissionInfo> extraPermissions = new HashMap<String, PermissionInfo>();
    public Map<String, Resources> resources = new HashMap<String, Resources>();
    private final Map<Intent, List<ResolveInfo>> resolveInfoForIntent = new TreeMap<Intent, List<ResolveInfo>>(new IntentComparator());
    private Set<String> deletedPackages = new HashSet<String>();
    Map<String, IPackageDeleteObserver> pendingDeleteCallbacks = new HashMap<String, IPackageDeleteObserver>();

    public ShadowPackageManager() {
        this.addManifest(RuntimeEnvironment.getAppManifest());
    }

    static Bundle metaDataToBundle(Map<String, Object> meta) {
        if (meta.size() == 0) {
            return null;
        }
        Bundle bundle = new Bundle();
        for (Map.Entry<String, Object> entry : meta.entrySet()) {
            if (Boolean.class.isInstance(entry.getValue())) {
                bundle.putBoolean(entry.getKey(), ((Boolean)entry.getValue()).booleanValue());
                continue;
            }
            if (Float.class.isInstance(entry.getValue())) {
                bundle.putFloat(entry.getKey(), ((Float)entry.getValue()).floatValue());
                continue;
            }
            if (Integer.class.isInstance(entry.getValue())) {
                bundle.putInt(entry.getKey(), ((Integer)entry.getValue()).intValue());
                continue;
            }
            bundle.putString(entry.getKey(), entry.getValue().toString());
        }
        return bundle;
    }

    static int compareSignature(Signature[] signatures1, Signature[] signatures2) {
        HashSet<Signature> signatures2set;
        if (signatures1 == null) {
            return signatures2 == null ? 1 : -1;
        }
        if (signatures2 == null) {
            return -2;
        }
        if (signatures1.length != signatures2.length) {
            return -3;
        }
        HashSet<Signature> signatures1set = new HashSet<Signature>(Arrays.asList(signatures1));
        return signatures1set.equals(signatures2set = new HashSet<Signature>(Arrays.asList(signatures2))) ? 0 : -3;
    }

    static String resolvePackageName(String packageName, ComponentName componentName) {
        String classString = componentName.getClassName();
        int index = classString.indexOf(46);
        if (index == -1) {
            classString = packageName + "." + classString;
        } else if (index == 0) {
            classString = packageName + classString;
        }
        return classString;
    }

    static PathPermission[] createPathPermissions(List<PathPermissionData> pathPermissionDatas) {
        PathPermission[] pathPermissions = new PathPermission[pathPermissionDatas.size()];
        for (int i = 0; i < pathPermissions.length; ++i) {
            int type;
            String path;
            PathPermissionData data = pathPermissionDatas.get(i);
            if (data.pathPrefix != null) {
                path = data.pathPrefix;
                type = 1;
            } else if (data.pathPattern != null) {
                path = data.pathPattern;
                type = 2;
            } else {
                path = data.path;
                type = 0;
            }
            pathPermissions[i] = new PathPermission(path, type, data.readPermission, data.writePermission);
        }
        return pathPermissions;
    }

    static IntentFilter matchIntentFilter(Intent intent, List<IntentFilterData> intentFilters) {
        for (IntentFilterData intentFilterData : intentFilters) {
            List actionList = intentFilterData.getActions();
            List categoryList = intentFilterData.getCategories();
            IntentFilter intentFilter = new IntentFilter();
            for (String action : actionList) {
                intentFilter.addAction(action);
            }
            for (String category : categoryList) {
                intentFilter.addCategory(category);
            }
            for (String scheme : intentFilterData.getSchemes()) {
                intentFilter.addDataScheme(scheme);
            }
            for (String mimeType : intentFilterData.getMimeTypes()) {
                try {
                    intentFilter.addDataType(mimeType);
                }
                catch (IntentFilter.MalformedMimeTypeException ex) {
                    throw new RuntimeException(ex);
                }
            }
            for (String path : intentFilterData.getPaths()) {
                intentFilter.addDataPath(path, 0);
            }
            for (String pathPattern : intentFilterData.getPathPatterns()) {
                intentFilter.addDataPath(pathPattern, 2);
            }
            for (String pathPrefix : intentFilterData.getPathPrefixes()) {
                intentFilter.addDataPath(pathPrefix, 1);
            }
            for (IntentFilterData.DataAuthority authority : intentFilterData.getAuthorities()) {
                intentFilter.addDataAuthority(authority.getHost(), authority.getPort());
            }
            boolean matchActionResult = intentFilter.matchAction(intent.getAction());
            String matchCategoriesResult = intentFilter.matchCategories(intent.getCategories());
            int matchResult = intentFilter.matchData(intent.getType(), intent.getData() != null ? intent.getData().getScheme() : null, intent.getData());
            if (!matchActionResult || matchCategoriesResult != null || matchResult == -2 || matchResult == -1) continue;
            return intentFilter;
        }
        return null;
    }

    static ResolveInfo getResolveInfo(ServiceData service, IntentFilter intentFilter, String packageName) {
        try {
            ResolveInfo info = new ResolveInfo();
            info.isDefault = intentFilter.hasCategory("Intent.CATEGORY_DEFAULT");
            info.serviceInfo = new ServiceInfo();
            info.serviceInfo.name = service.getClassName();
            info.serviceInfo.packageName = packageName;
            info.serviceInfo.applicationInfo = new ApplicationInfo();
            info.filter = new IntentFilter();
            Iterator it = intentFilter.typesIterator();
            while (it.hasNext()) {
                info.filter.addDataType((String)it.next());
            }
            return info;
        }
        catch (IntentFilter.MalformedMimeTypeException e) {
            throw new RuntimeException(e);
        }
    }

    private static int decodeProtectionLevel(String protectionLevel) {
        if (protectionLevel == null) {
            return 0;
        }
        switch (protectionLevel) {
            case "normal": {
                return 0;
            }
            case "dangerous": {
                return 1;
            }
            case "signature": {
                return 2;
            }
            case "signatureOrSystem": {
                return 3;
            }
        }
        throw new IllegalArgumentException("unknown protection level " + protectionLevel);
    }

    static PermissionInfo createPermissionInfo(int flags, PermissionItemData permissionItemData) throws PackageManager.NameNotFoundException {
        String labelRefOrString;
        String packageName;
        PermissionInfo permissionInfo = new PermissionInfo();
        permissionInfo.packageName = packageName = RuntimeEnvironment.getAppManifest().getPackageName();
        permissionInfo.name = permissionItemData.getName();
        permissionInfo.group = permissionItemData.getPermissionGroup();
        permissionInfo.protectionLevel = ShadowPackageManager.decodeProtectionLevel(permissionItemData.getProtectionLevel());
        String descriptionRef = permissionItemData.getDescription();
        if (descriptionRef != null) {
            ResName descResName = AttributeResource.getResourceReference((String)descriptionRef, (String)packageName, (String)"string");
            permissionInfo.descriptionRes = RuntimeEnvironment.getAppResourceTable().getResourceId(descResName);
        }
        if ((labelRefOrString = permissionItemData.getLabel()) != null) {
            if (AttributeResource.isResourceReference((String)labelRefOrString)) {
                ResName labelResName = AttributeResource.getResourceReference((String)labelRefOrString, (String)packageName, (String)"string");
                permissionInfo.labelRes = RuntimeEnvironment.getAppResourceTable().getResourceId(labelResName);
            } else {
                permissionInfo.nonLocalizedLabel = labelRefOrString;
            }
        }
        if ((flags & 0x80) != 0) {
            permissionInfo.metaData = ShadowPackageManager.metaDataToBundle(permissionItemData.getMetaData().getValueMap());
        }
        return permissionInfo;
    }

    private static int decodeFlags(Map<String, String> applicationAttributes) {
        int applicationFlags = 0;
        for (Pair<String, Integer> pair : APPLICATION_FLAGS) {
            if (!"true".equals(applicationAttributes.get(pair.first))) continue;
            applicationFlags |= ((Integer)pair.second).intValue();
        }
        return applicationFlags;
    }

    private static void setUpPackageStorage(ApplicationInfo applicationInfo) {
        TempDirectory tempDirectory = RuntimeEnvironment.getTempDirectory();
        applicationInfo.sourceDir = tempDirectory.createIfNotExists(applicationInfo.packageName + "-sourceDir").toAbsolutePath().toString();
        applicationInfo.dataDir = tempDirectory.createIfNotExists(applicationInfo.packageName + "-dataDir").toAbsolutePath().toString();
        if (RuntimeEnvironment.getApiLevel() >= 24) {
            applicationInfo.credentialProtectedDataDir = tempDirectory.createIfNotExists("userDataDir").toAbsolutePath().toString();
            applicationInfo.deviceProtectedDataDir = tempDirectory.createIfNotExists("deviceDataDir").toAbsolutePath().toString();
        }
    }

    @Deprecated
    public PackageInfo getPackageInfo(String packageName, int flags) throws PackageManager.NameNotFoundException {
        throw new UnsupportedOperationException("Not implemented");
    }

    @Deprecated
    public ApplicationInfo getApplicationInfo(String packageName, int flags) throws PackageManager.NameNotFoundException {
        throw new UnsupportedOperationException("Not implemented");
    }

    @Deprecated
    public ActivityInfo getActivityInfo(ComponentName className, int flags) throws PackageManager.NameNotFoundException {
        throw new UnsupportedOperationException("Not implemented");
    }

    @Deprecated
    public ActivityInfo getReceiverInfo(ComponentName className, int flags) throws PackageManager.NameNotFoundException {
        throw new UnsupportedOperationException("Not implemented");
    }

    @Deprecated
    public ServiceInfo getServiceInfo(ComponentName className, int flags) throws PackageManager.NameNotFoundException {
        throw new UnsupportedOperationException("Not implemented");
    }

    @Deprecated
    public List<PackageInfo> getInstalledPackages(int flags) {
        throw new UnsupportedOperationException("Not implemented");
    }

    @Deprecated
    public List<ResolveInfo> queryIntentActivities(Intent intent, int flags) {
        throw new UnsupportedOperationException("Not implemented");
    }

    @Deprecated
    public List<ResolveInfo> queryIntentServices(Intent intent, int flags) {
        throw new UnsupportedOperationException("Not implemented");
    }

    @Deprecated
    public List<ResolveInfo> queryBroadcastReceivers(Intent intent, int flags) {
        throw new UnsupportedOperationException("Not implemented");
    }

    @Deprecated
    public ResolveInfo resolveActivity(Intent intent, int flags) {
        throw new UnsupportedOperationException("Not implemented");
    }

    @Deprecated
    public ResolveInfo resolveService(Intent intent, int flags) {
        throw new UnsupportedOperationException("Not implemented");
    }

    public void addResolveInfoForIntent(Intent intent, List<ResolveInfo> info) {
        this.resolveInfoForIntent.put(intent, info);
    }

    public void addResolveInfoForIntent(Intent intent, ResolveInfo info) {
        List<ResolveInfo> infoList = this.resolveInfoForIntent.get(intent);
        if (infoList == null) {
            infoList = new ArrayList<ResolveInfo>();
            this.resolveInfoForIntent.put(intent, infoList);
        }
        infoList.add(info);
    }

    public void removeResolveInfosForIntent(Intent intent, String packageName) {
        List<ResolveInfo> infoList = this.resolveInfoForIntent.get(intent);
        if (infoList == null) {
            infoList = new ArrayList<ResolveInfo>();
            this.resolveInfoForIntent.put(intent, infoList);
        }
        Iterator<ResolveInfo> iterator = infoList.iterator();
        while (iterator.hasNext()) {
            ResolveInfo resolveInfo = iterator.next();
            if (!resolveInfo.activityInfo.packageName.equals(packageName)) continue;
            iterator.remove();
        }
    }

    public Drawable getActivityIcon(Intent intent) throws PackageManager.NameNotFoundException {
        return this.drawableList.get(intent.getComponent());
    }

    public Drawable getActivityIcon(ComponentName componentName) throws PackageManager.NameNotFoundException {
        return this.drawableList.get(componentName);
    }

    public void addActivityIcon(ComponentName component, Drawable drawable2) {
        this.drawableList.put(component, drawable2);
    }

    public void addActivityIcon(Intent intent, Drawable drawable2) {
        this.drawableList.put(intent.getComponent(), drawable2);
    }

    @Deprecated
    public Drawable getApplicationIcon(String packageName) throws PackageManager.NameNotFoundException {
        throw new UnsupportedOperationException("Not implemented");
    }

    public void setApplicationIcon(String packageName, Drawable drawable2) {
        this.applicationIcons.put(packageName, drawable2);
    }

    @Deprecated
    public Intent getLaunchIntentForPackage(String packageName) {
        throw new UnsupportedOperationException("Not implemented");
    }

    @Deprecated
    public CharSequence getApplicationLabel(ApplicationInfo info) {
        throw new UnsupportedOperationException("Not implemented");
    }

    @Deprecated
    public void setComponentEnabledSetting(ComponentName componentName, int newState, int flags) {
        throw new UnsupportedOperationException("Not implemented");
    }

    public void setApplicationEnabledSetting(String packageName, int newState, int flags) {
        this.applicationEnabledSettingMap.put(packageName, newState);
    }

    public void addPreferredActivity(IntentFilter filter, int match, ComponentName[] set, ComponentName activity) {
        this.preferredActivities.put(filter, activity);
    }

    public int getPreferredActivities(List<IntentFilter> outFilters, List<ComponentName> outActivities, String packageName) {
        if (outFilters == null) {
            return 0;
        }
        Set<IntentFilter> filters = this.preferredActivities.keySet();
        for (IntentFilter filter : outFilters) {
            block1: for (IntentFilter testFilter : filters) {
                ComponentName name = this.preferredActivities.get(testFilter);
                if (packageName != null && !name.getPackageName().equals(packageName)) continue;
                Iterator iterator = filter.actionsIterator();
                while (iterator.hasNext()) {
                    if (testFilter.matchAction((String)iterator.next())) continue;
                    continue block1;
                }
                iterator = filter.categoriesIterator();
                while (iterator.hasNext()) {
                    if (filter.hasCategory((String)iterator.next())) continue;
                    continue block1;
                }
                if (outActivities == null) {
                    outActivities = new ArrayList<ComponentName>();
                }
                outActivities.add(name);
            }
        }
        return 0;
    }

    @Deprecated
    public ComponentState getComponentState(ComponentName componentName) {
        return this.componentList.get(componentName);
    }

    public int getComponentEnabledSettingFlags(ComponentName componentName) {
        ComponentState state = this.componentList.get(componentName);
        return state != null ? state.flags : 0;
    }

    public void addPackage(PackageInfo packageInfo) {
        PackageStats packageStats = new PackageStats(packageInfo.packageName);
        Preconditions.checkArgument((boolean)packageInfo.packageName.equals(packageStats.packageName));
        this.packageInfos.put(packageInfo.packageName, packageInfo);
        this.packageStatsMap.put(packageInfo.packageName, packageStats);
        this.applicationEnabledSettingMap.put(packageInfo.packageName, 0);
        Resources r = new Resources(new AssetManager(), null, null);
        this.resources.put(packageInfo.packageName, r);
        if (packageInfo.applicationInfo != null) {
            this.namesForUid.put(packageInfo.applicationInfo.uid, packageInfo.packageName);
        }
    }

    public void addPackage(PackageInfo packageInfo, PackageStats packageStats) {
        Preconditions.checkArgument((boolean)packageInfo.packageName.equals(packageStats.packageName));
        this.packageInfos.put(packageInfo.packageName, packageInfo);
        this.packageStatsMap.put(packageInfo.packageName, packageStats);
        this.applicationEnabledSettingMap.put(packageInfo.packageName, 0);
        Resources r = new Resources(new AssetManager(), null, null);
        this.resources.put(packageInfo.packageName, r);
        if (packageInfo.applicationInfo != null) {
            this.namesForUid.put(packageInfo.applicationInfo.uid, packageInfo.packageName);
        }
    }

    public void addPermissionInfo(PermissionInfo permissionInfo) {
        this.extraPermissions.put(permissionInfo.name, permissionInfo);
    }

    public void addPackage(String packageName) {
        PackageInfo packageInfo = new PackageInfo();
        packageInfo.packageName = packageName;
        ApplicationInfo applicationInfo = new ApplicationInfo();
        applicationInfo.packageName = packageName;
        ShadowPackageManager.setUpPackageStorage(applicationInfo);
        packageInfo.applicationInfo = applicationInfo;
        PackageStats packageStats = new PackageStats(packageInfo.packageName);
        Preconditions.checkArgument((boolean)packageInfo.packageName.equals(packageStats.packageName));
        this.packageInfos.put(packageInfo.packageName, packageInfo);
        this.packageStatsMap.put(packageInfo.packageName, packageStats);
        this.applicationEnabledSettingMap.put(packageInfo.packageName, 0);
        Resources r = new Resources(new AssetManager(), null, null);
        this.resources.put(packageInfo.packageName, r);
        if (packageInfo.applicationInfo != null) {
            this.namesForUid.put(packageInfo.applicationInfo.uid, packageInfo.packageName);
        }
    }

    public void addManifest(AndroidManifest androidManifest) {
        this.androidManifests.put(androidManifest.getPackageName(), androidManifest);
        PackageInfo packageInfo = new PackageInfo();
        packageInfo.packageName = androidManifest.getPackageName();
        packageInfo.versionName = androidManifest.getVersionName();
        packageInfo.versionCode = androidManifest.getVersionCode();
        Map activityDatas = androidManifest.getActivityDatas();
        for (ActivityData data : activityDatas.values()) {
            String name = data.getName();
            String activityName = name.startsWith(".") ? androidManifest.getPackageName() + name : name;
            Intent intent = new Intent(activityName);
            List<ResolveInfo> infoList1 = this.resolveInfoForIntent.get(intent);
            if (infoList1 == null) {
                infoList1 = new ArrayList<ResolveInfo>();
                this.resolveInfoForIntent.put(intent, infoList1);
            }
            Iterator infoList = infoList1;
            infoList.add((ResolveInfo)new ResolveInfo());
        }
        ContentProviderData[] cpdata = androidManifest.getContentProviders().toArray(new ContentProviderData[0]);
        if (cpdata.length == 0) {
            packageInfo.providers = null;
        } else {
            packageInfo.providers = new ProviderInfo[cpdata.length];
            for (int i = 0; i < cpdata.length; ++i) {
                ProviderInfo info = new ProviderInfo();
                info.authority = cpdata[i].getAuthorities();
                info.name = cpdata[i].getClassName();
                info.packageName = androidManifest.getPackageName();
                info.metaData = ShadowPackageManager.metaDataToBundle(cpdata[i].getMetaData().getValueMap());
                packageInfo.providers[i] = info;
            }
        }
        ArrayList<ActivityInfo> receiverActivityInfos = new ArrayList<ActivityInfo>();
        for (int i = 0; i < androidManifest.getBroadcastReceivers().size(); ++i) {
            ActivityInfo activityInfo = new ActivityInfo();
            activityInfo.name = ((BroadcastReceiverData)androidManifest.getBroadcastReceivers().get(i)).getClassName();
            activityInfo.permission = ((BroadcastReceiverData)androidManifest.getBroadcastReceivers().get(i)).getPermission();
            receiverActivityInfos.add(activityInfo);
            ResolveInfo resolveInfo = new ResolveInfo();
            resolveInfo.activityInfo = activityInfo;
            IntentFilter filter = new IntentFilter();
            for (String action : ((BroadcastReceiverData)androidManifest.getBroadcastReceivers().get(i)).getActions()) {
                filter.addAction(action);
            }
            resolveInfo.filter = filter;
            for (String action : ((BroadcastReceiverData)androidManifest.getBroadcastReceivers().get(i)).getActions()) {
                Intent intent = new Intent(action);
                intent.setPackage(androidManifest.getPackageName());
                List<ResolveInfo> infoList1 = this.resolveInfoForIntent.get(intent);
                if (infoList1 == null) {
                    infoList1 = new ArrayList<ResolveInfo>();
                    this.resolveInfoForIntent.put(intent, infoList1);
                }
                List<ResolveInfo> infoList = infoList1;
                infoList.add(resolveInfo);
            }
        }
        packageInfo.receivers = receiverActivityInfos.toArray(new ActivityInfo[0]);
        String[] usedPermissions = androidManifest.getUsedPermissions().toArray(new String[0]);
        packageInfo.requestedPermissions = usedPermissions.length == 0 ? null : usedPermissions;
        ApplicationInfo applicationInfo = new ApplicationInfo();
        applicationInfo.flags = ShadowPackageManager.decodeFlags(androidManifest.getApplicationAttributes());
        applicationInfo.targetSdkVersion = androidManifest.getTargetSdkVersion();
        applicationInfo.packageName = androidManifest.getPackageName();
        applicationInfo.processName = androidManifest.getProcessName();
        applicationInfo.name = androidManifest.getApplicationName();
        applicationInfo.metaData = ShadowPackageManager.metaDataToBundle(androidManifest.getApplicationMetaData());
        ShadowPackageManager.setUpPackageStorage(applicationInfo);
        int labelRes = 0;
        if (androidManifest.getLabelRef() != null) {
            String fullyQualifiedName = ResName.qualifyResName((String)androidManifest.getLabelRef(), (String)androidManifest.getPackageName());
            Integer id2 = fullyQualifiedName == null ? null : RuntimeEnvironment.getAppResourceTable().getResourceId(new ResName(fullyQualifiedName));
            labelRes = id2 != null ? id2 : 0;
        }
        applicationInfo.labelRes = labelRes;
        String labelRef = androidManifest.getLabelRef();
        if (labelRef != null && !labelRef.startsWith("@")) {
            applicationInfo.nonLocalizedLabel = labelRef;
        }
        packageInfo.applicationInfo = applicationInfo;
        PackageStats packageStats = new PackageStats(packageInfo.packageName);
        Preconditions.checkArgument((boolean)packageInfo.packageName.equals(packageStats.packageName));
        this.packageInfos.put(packageInfo.packageName, packageInfo);
        this.packageStatsMap.put(packageInfo.packageName, packageStats);
        this.applicationEnabledSettingMap.put(packageInfo.packageName, 0);
        Resources r = new Resources(new AssetManager(), null, null);
        this.resources.put(packageInfo.packageName, r);
        if (packageInfo.applicationInfo != null) {
            this.namesForUid.put(packageInfo.applicationInfo.uid, packageInfo.packageName);
        }
    }

    public void removePackage(String packageName) {
        this.packageInfos.remove(packageName);
    }

    @Deprecated
    public boolean hasSystemFeature(String name) {
        throw new UnsupportedOperationException("Not implemented");
    }

    public void setSystemFeature(String name, boolean supported) {
        this.systemFeatureList.put(name, supported);
    }

    public void addDrawableResolution(String packageName, int resourceId, Drawable drawable2) {
        this.drawables.put((Pair<String, Integer>)new Pair((Object)packageName, (Object)resourceId), drawable2);
    }

    public Drawable getDrawable(String packageName, int resourceId, ApplicationInfo applicationInfo) {
        return this.drawables.get(new Pair((Object)packageName, (Object)resourceId));
    }

    @Deprecated
    public int checkPermission(String permName, String pkgName) {
        return 0;
    }

    public boolean isQueryIntentImplicitly() {
        return this.queryIntentImplicitly;
    }

    public void setQueryIntentImplicitly(boolean queryIntentImplicitly) {
        this.queryIntentImplicitly = queryIntentImplicitly;
    }

    public void setNameForUid(int uid, String name) {
        this.namesForUid.put(uid, name);
    }

    public void setPackagesForCallingUid(String ... packagesForCallingUid) {
        this.packagesForUid.put(Binder.getCallingUid(), packagesForCallingUid);
    }

    public void setPackagesForUid(int uid, String ... packagesForCallingUid) {
        this.packagesForUid.put(uid, packagesForCallingUid);
    }

    public void setPackageArchiveInfo(String archiveFilePath, PackageInfo packageInfo) {
        this.packageArchiveInfo.put(archiveFilePath, packageInfo);
    }

    public int getVerificationResult(int id2) {
        Integer result = this.verificationResults.get(id2);
        if (result == null) {
            return 0;
        }
        return result;
    }

    public long getVerificationExtendedTimeout(int id2) {
        Long result = this.verificationTimeoutExtension.get(id2);
        if (result == null) {
            return 0L;
        }
        return result;
    }

    public void setShouldShowRequestPermissionRationale(String permission2, boolean show) {
        this.permissionRationaleMap.put(permission2, show);
    }

    public void addSystemAvailableFeature(FeatureInfo featureInfo) {
        this.systemAvailableFeatures.add(featureInfo);
    }

    public void clearSystemAvailableFeatures() {
        this.systemAvailableFeatures.clear();
    }

    public void addCurrentToCannonicalName(String currentName, String canonicalName) {
        this.currentToCanonicalNames.put(currentName, canonicalName);
    }

    @Implementation
    public List<ResolveInfo> queryBroadcastReceiversAsUser(Intent intent, int flags, UserHandle userHandle) {
        return null;
    }

    @Implementation
    public List<ResolveInfo> queryBroadcastReceivers(Intent intent, int flags, int userId) {
        return null;
    }

    @Implementation
    public PackageInfo getPackageArchiveInfo(String archiveFilePath, int flags) {
        ArrayList<PackageInfo> result = new ArrayList<PackageInfo>();
        for (PackageInfo packageInfo : this.packageInfos.values()) {
            if (this.applicationEnabledSettingMap.get(packageInfo.packageName) == 2 && (flags & 0x2000) != 8192) continue;
            result.add(packageInfo);
        }
        ArrayList<PackageInfo> packages = result;
        for (PackageInfo aPackage : packages) {
            ApplicationInfo appInfo = aPackage.applicationInfo;
            if (appInfo == null || !archiveFilePath.equals(appInfo.sourceDir)) continue;
            return aPackage;
        }
        return null;
    }

    @Implementation
    public void freeStorageAndNotify(long freeStorageSize, IPackageDataObserver observer) {
    }

    @Implementation
    public void freeStorage(long freeStorageSize, IntentSender pi) {
    }

    public void doPendingUninstallCallbacks() {
        boolean hasDeletePackagesPermission = false;
        String[] requestedPermissions = this.packageInfos.get((Object)RuntimeEnvironment.getAppManifest().getPackageName()).requestedPermissions;
        if (requestedPermissions != null) {
            for (String permission2 : requestedPermissions) {
                if (!"android.permission.DELETE_PACKAGES".equals(permission2)) continue;
                hasDeletePackagesPermission = true;
                break;
            }
        }
        for (String packageName : this.pendingDeleteCallbacks.keySet()) {
            int resultCode = -1;
            PackageInfo removed = this.packageInfos.get(packageName);
            if (hasDeletePackagesPermission && removed != null) {
                this.packageInfos.remove(packageName);
                this.deletedPackages.add(packageName);
                resultCode = 1;
            }
            try {
                this.pendingDeleteCallbacks.get(packageName).packageDeleted(packageName, resultCode);
            }
            catch (RemoteException e) {
                throw new RuntimeException(e);
            }
        }
        this.pendingDeleteCallbacks.clear();
    }

    public Set<String> getDeletedPackages() {
        return this.deletedPackages;
    }

    protected List<ResolveInfo> queryIntent(Intent intent, int flags) {
        List<ResolveInfo> result = this.resolveInfoForIntent.get(intent);
        if (result == null) {
            return Collections.emptyList();
        }
        return result;
    }

    protected static int getConfigChanges(ActivityData activityData) {
        String[] pieces;
        String s = activityData.getConfigChanges();
        int res = 0;
        if (s == null || "".equals(s)) {
            return res;
        }
        block0: for (String s1 : pieces = s.split("\\|")) {
            s1 = s1.trim();
            for (Pair<String, Integer> pair : CONFIG_OPTIONS) {
                if (!s1.equals(pair.first)) continue;
                res |= ((Integer)pair.second).intValue();
                continue block0;
            }
        }
        return res;
    }

    @Deprecated
    public class ComponentState {
        public int newState;
        public int flags;

        public ComponentState(int newState, int flags) {
            this.newState = newState;
            this.flags = flags;
        }
    }

    public static class IntentComparator
    implements Comparator<Intent> {
        @Override
        public int compare(Intent i1, Intent i2) {
            if (i1 == null && i2 == null) {
                return 0;
            }
            if (i1 == null && i2 != null) {
                return -1;
            }
            if (i1 != null && i2 == null) {
                return 1;
            }
            if (i1.equals(i2)) {
                return 0;
            }
            String action1 = i1.getAction();
            String action2 = i2.getAction();
            if (action1 == null && action2 != null) {
                return -1;
            }
            if (action1 != null && action2 == null) {
                return 1;
            }
            if (action1 != null && action2 != null && !action1.equals(action2)) {
                return action1.compareTo(action2);
            }
            Uri data1 = i1.getData();
            Uri data2 = i2.getData();
            if (data1 == null && data2 != null) {
                return -1;
            }
            if (data1 != null && data2 == null) {
                return 1;
            }
            if (data1 != null && data2 != null && !data1.equals((Object)data2)) {
                return data1.compareTo(data2);
            }
            ComponentName component1 = i1.getComponent();
            ComponentName component2 = i2.getComponent();
            if (component1 == null && component2 != null) {
                return -1;
            }
            if (component1 != null && component2 == null) {
                return 1;
            }
            if (component1 != null && component2 != null && !component1.equals((Object)component2)) {
                return component1.compareTo(component2);
            }
            String package1 = i1.getPackage();
            String package2 = i2.getPackage();
            if (package1 == null && package2 != null) {
                return -1;
            }
            if (package1 != null && package2 == null) {
                return 1;
            }
            if (package1 != null && package2 != null && !package1.equals(package2)) {
                return package1.compareTo(package2);
            }
            Set categories1 = i1.getCategories();
            Set categories2 = i2.getCategories();
            if (categories1 == null) {
                return categories2 == null ? 0 : -1;
            }
            if (categories2 == null) {
                return 1;
            }
            if (categories1.size() > categories2.size()) {
                return 1;
            }
            if (categories1.size() < categories2.size()) {
                return -1;
            }
            Object[] array1 = categories1.toArray(new String[0]);
            Object[] array2 = categories2.toArray(new String[0]);
            Arrays.sort(array1);
            Arrays.sort(array2);
            for (int i = 0; i < array1.length; ++i) {
                int val = ((String)array1[i]).compareTo((String)array2[i]);
                if (val == 0) continue;
                return val;
            }
            return 0;
        }
    }
}

