/*
 * Decompiled with CFR 0.152.
 */
package org.robolectric.shadows;

import android.content.Context;
import android.util.DisplayMetrics;
import android.view.ViewConfiguration;
import org.robolectric.Shadows;
import org.robolectric.annotation.Implementation;
import org.robolectric.annotation.Implements;
import org.robolectric.annotation.RealObject;
import org.robolectric.shadow.api.Shadow;

@Implements(value=ViewConfiguration.class)
public class ShadowViewConfiguration {
    private static final int SCROLL_BAR_SIZE = 10;
    private static final int SCROLL_BAR_FADE_DURATION = 250;
    private static final int SCROLL_BAR_DEFAULT_DELAY = 300;
    private static final int FADING_EDGE_LENGTH = 12;
    private static final int PRESSED_STATE_DURATION = 125;
    private static final int LONG_PRESS_TIMEOUT = 500;
    private static final int GLOBAL_ACTIONS_KEY_TIMEOUT = 500;
    private static final int TAP_TIMEOUT = 115;
    private static final int JUMP_TAP_TIMEOUT = 500;
    private static final int DOUBLE_TAP_TIMEOUT = 300;
    private static final int ZOOM_CONTROLS_TIMEOUT = 3000;
    private static final int EDGE_SLOP = 12;
    private static final int TOUCH_SLOP = 16;
    private static final int PAGING_TOUCH_SLOP = 32;
    private static final int DOUBLE_TAP_SLOP = 100;
    private static final int WINDOW_TOUCH_SLOP = 16;
    private static final int MINIMUM_FLING_VELOCITY = 50;
    private static final int MAXIMUM_FLING_VELOCITY = 4000;
    private static final int MAXIMUM_DRAWING_CACHE_SIZE = 614400;
    private static final int OVERSCROLL_DISTANCE = 0;
    private static final int OVERFLING_DISTANCE = 4;
    private static final float SCROLL_FRICTION = 0.015f;
    private int edgeSlop;
    private int fadingEdgeLength;
    private int minimumFlingVelocity;
    private int maximumFlingVelocity;
    private int scrollbarSize;
    private int touchSlop;
    private int pagingTouchSlop;
    private int doubleTapSlop;
    private int windowTouchSlop;
    private boolean hasPermanentMenuKey = false;
    @RealObject
    private ViewConfiguration realViewConfiguration;

    private void setup(Context context) {
        DisplayMetrics metrics = context.getResources().getDisplayMetrics();
        float density = metrics.density;
        this.edgeSlop = (int)(density * 12.0f + 0.5f);
        this.fadingEdgeLength = (int)(density * 12.0f + 0.5f);
        this.minimumFlingVelocity = (int)(density * 50.0f + 0.5f);
        this.maximumFlingVelocity = (int)(density * 4000.0f + 0.5f);
        this.scrollbarSize = (int)(density * 10.0f + 0.5f);
        this.touchSlop = (int)(density * 16.0f + 0.5f);
        this.pagingTouchSlop = (int)(density * 32.0f + 0.5f);
        this.doubleTapSlop = (int)(density * 100.0f + 0.5f);
        this.windowTouchSlop = (int)(density * 16.0f + 0.5f);
    }

    @Implementation
    public static ViewConfiguration get(Context context) {
        ViewConfiguration viewConfiguration = (ViewConfiguration)Shadow.newInstanceOf(ViewConfiguration.class);
        Shadows.shadowOf(viewConfiguration).setup(context);
        return viewConfiguration;
    }

    @Implementation
    public static int getScrollBarSize() {
        return 10;
    }

    @Implementation
    public int getScaledScrollBarSize() {
        return this.scrollbarSize;
    }

    @Implementation
    public static int getScrollBarFadeDuration() {
        return 250;
    }

    @Implementation
    public static int getScrollDefaultDelay() {
        return 300;
    }

    @Implementation
    public static int getFadingEdgeLength() {
        return 12;
    }

    @Implementation
    public int getScaledFadingEdgeLength() {
        return this.fadingEdgeLength;
    }

    @Implementation
    public static int getPressedStateDuration() {
        return 125;
    }

    @Implementation
    public static int getLongPressTimeout() {
        return 500;
    }

    @Implementation
    public static int getTapTimeout() {
        return 115;
    }

    @Implementation
    public static int getJumpTapTimeout() {
        return 500;
    }

    @Implementation
    public static int getDoubleTapTimeout() {
        return 300;
    }

    @Implementation
    public static int getEdgeSlop() {
        return 12;
    }

    @Implementation
    public int getScaledEdgeSlop() {
        return this.edgeSlop;
    }

    @Implementation
    public static int getTouchSlop() {
        return 16;
    }

    @Implementation
    public int getScaledTouchSlop() {
        return this.touchSlop;
    }

    @Implementation
    public int getScaledPagingTouchSlop() {
        return this.pagingTouchSlop;
    }

    @Implementation
    public int getScaledDoubleTapSlop() {
        return this.doubleTapSlop;
    }

    @Implementation
    public static int getWindowTouchSlop() {
        return 16;
    }

    @Implementation
    public int getScaledWindowTouchSlop() {
        return this.windowTouchSlop;
    }

    @Implementation
    public static int getMinimumFlingVelocity() {
        return 50;
    }

    @Implementation
    public int getScaledMinimumFlingVelocity() {
        return this.minimumFlingVelocity;
    }

    @Implementation
    public static int getMaximumFlingVelocity() {
        return 4000;
    }

    @Implementation
    public int getScaledMaximumFlingVelocity() {
        return this.maximumFlingVelocity;
    }

    @Implementation
    public static int getMaximumDrawingCacheSize() {
        return 614400;
    }

    @Implementation
    public static long getZoomControlsTimeout() {
        return 3000L;
    }

    @Implementation
    public static long getGlobalActionKeyTimeout() {
        return 500L;
    }

    @Implementation
    public static float getScrollFriction() {
        return 0.015f;
    }

    @Implementation
    public boolean hasPermanentMenuKey() {
        return this.hasPermanentMenuKey;
    }

    public void setHasPermanentMenuKey(boolean value) {
        this.hasPermanentMenuKey = value;
    }
}

