/*
 * Decompiled with CFR 0.152.
 */
package org.robolectric.res;

import com.google.common.base.Strings;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.regex.Pattern;
import org.robolectric.res.AttributeResource;
import org.robolectric.res.ResName;
import org.robolectric.res.Style;

public class StyleData
implements Style {
    private final String packageName;
    private final String name;
    private final String parent;
    private final Map<ResName, AttributeResource> items = new LinkedHashMap<ResName, AttributeResource>();

    public StyleData(String packageName, String name, String parent, List<AttributeResource> attributeResources) {
        this.packageName = packageName;
        this.name = name;
        this.parent = parent;
        for (AttributeResource attributeResource : attributeResources) {
            this.add(attributeResource.resName, attributeResource);
        }
    }

    public String getName() {
        return this.name;
    }

    public String getParent() {
        return this.parent;
    }

    private void add(ResName attrName, AttributeResource attribute) {
        attrName.mustBe("attr");
        this.items.put(attrName, attribute);
    }

    @Override
    public AttributeResource getAttrValue(ResName resName) {
        AttributeResource attributeResource = this.items.get(resName);
        if (!(attributeResource != null || "android".equals(resName.packageName) || "android".equals(this.packageName) || (attributeResource = this.items.get(resName.withPackageName(this.packageName))) == null || "android".equals(attributeResource.contextPackageName))) {
            attributeResource = new AttributeResource(resName, attributeResource.value, resName.packageName);
        }
        return attributeResource;
    }

    public boolean grep(Pattern pattern) {
        for (ResName resName : this.items.keySet()) {
            if (!pattern.matcher(resName.getFullyQualifiedName()).find()) continue;
            return true;
        }
        return false;
    }

    public void visit(Visitor visitor) {
        for (AttributeResource attributeResource : this.items.values()) {
            visitor.visit(attributeResource);
        }
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof StyleData)) {
            return false;
        }
        StyleData other = (StyleData)obj;
        return Objects.equals(this.packageName, other.packageName) && Objects.equals(this.name, other.name) && Objects.equals(this.parent, other.parent) && this.items.size() == other.items.size();
    }

    public int hashCode() {
        int hashCode = 0;
        hashCode = 31 * hashCode + Strings.nullToEmpty((String)this.packageName).hashCode();
        hashCode = 31 * hashCode + Strings.nullToEmpty((String)this.name).hashCode();
        hashCode = 31 * hashCode + Strings.nullToEmpty((String)this.parent).hashCode();
        hashCode = 31 * hashCode + this.items.size();
        return hashCode;
    }

    public String toString() {
        String string = this.packageName;
        String string2 = this.name;
        return new StringBuilder(7 + String.valueOf(string).length() + String.valueOf(string2).length()).append("Style ").append(string).append(":").append(string2).toString();
    }

    public String getPackageName() {
        return this.packageName;
    }

    public static interface Visitor {
        public void visit(AttributeResource var1);
    }
}

