/*
 * Decompiled with CFR 0.152.
 */
package org.robolectric.res.android;

import java.util.HashMap;
import java.util.Map;
import org.robolectric.res.android.Ref;
import org.robolectric.res.android.ResourceTypes;
import org.robolectric.res.android.StringPiece;
import org.robolectric.res.android.Util;

class Idmap {
    Idmap() {
    }

    static boolean is_valid_package_id(short id) {
        return id != 0 && id <= 255;
    }

    static boolean is_valid_type_id(short id) {
        return Idmap.is_valid_package_id(id);
    }

    static class LoadedIdmap {
        ResourceTypes.Idmap_header header_ = null;
        String overlay_apk_path_;
        final Map<Byte, ResourceTypes.IdmapEntry_header> type_map_ = new HashMap<Byte, ResourceTypes.IdmapEntry_header>();

        public LoadedIdmap(ResourceTypes.Idmap_header header_) {
            this.header_ = header_;
        }

        static boolean Lookup(ResourceTypes.IdmapEntry_header header, int input_entry_id, Ref<Integer> output_entry_id) {
            if (input_entry_id < Util.dtohs(header.entry_id_offset)) {
                return false;
            }
            if ((input_entry_id -= Util.dtohs(header.entry_id_offset)) >= Util.dtohs(header.entry_count)) {
                return false;
            }
            int result = Util.dtohl(header.entries[input_entry_id]);
            if (result == -1) {
                return false;
            }
            output_entry_id.set(result);
            return true;
        }

        static boolean is_word_aligned(int offset) {
            return (offset & 3) == 0;
        }

        static boolean IsValidIdmapHeader(StringPiece data) {
            throw new UnsupportedOperationException();
        }

        LoadedIdmap Load(StringPiece idmap_data) {
            Util.ATRACE_CALL();
            if (!LoadedIdmap.IsValidIdmapHeader(idmap_data)) {
                return this.emptyBraces();
            }
            ResourceTypes.Idmap_header header = idmap_data.asIdmap_header();
            LoadedIdmap loaded_idmap = new LoadedIdmap(header);
            StringPiece data_ptr = new StringPiece(idmap_data.myBuf(), idmap_data.myOffset() + 4);
            int data_size = idmap_data.size() - 4;
            int type_maps_encountered = 0;
            while (data_size >= 8) {
                if (!LoadedIdmap.is_word_aligned(data_ptr.myOffset())) {
                    Util.logError("Type mapping in Idmap is not word aligned");
                    return this.emptyBraces();
                }
                ResourceTypes.IdmapEntry_header entry_header = new ResourceTypes.IdmapEntry_header(data_ptr.myBuf(), data_ptr.myOffset());
                if (!Idmap.is_valid_type_id(Util.dtohs(entry_header.target_type_id)) || !Idmap.is_valid_type_id(Util.dtohs(entry_header.overlay_type_id))) {
                    Util.logError(String.format("Invalid type map (0x%02x -> 0x%02x)", Util.dtohs(entry_header.target_type_id), Util.dtohs(entry_header.overlay_type_id)));
                    return this.emptyBraces();
                }
                if ((data_size - 4) / 4 < Util.dtohs(entry_header.entry_count)) {
                    Util.logError(String.format("Idmap too small for the number of entries (%d)", Util.dtohs(entry_header.entry_count)));
                    return this.emptyBraces();
                }
                if (Util.dtohs(entry_header.entry_count) != 0) {
                    loaded_idmap.type_map_.put((byte)Util.dtohs(entry_header.overlay_type_id), entry_header);
                }
                int entry_size_bytes = 4 + Util.dtohs(entry_header.entry_count) * 4;
                data_ptr = new StringPiece(data_ptr.myBuf(), data_ptr.myOffset() + entry_size_bytes);
                data_size -= entry_size_bytes;
                ++type_maps_encountered;
            }
            if (type_maps_encountered != Util.dtohs(header.type_count)) {
                int n = type_maps_encountered;
                short s = Util.dtohs(header.type_count);
                Util.logError(new StringBuilder(53).append("Parsed ").append(n).append(" type maps but expected ").append(s).toString());
                return this.emptyBraces();
            }
            return loaded_idmap;
        }

        private LoadedIdmap emptyBraces() {
            return new LoadedIdmap(null);
        }

        int TargetPackageId() {
            return Util.dtohs(this.header_.target_package_id);
        }

        String OverlayApkPath() {
            return this.overlay_apk_path_;
        }

        ResourceTypes.IdmapEntry_header GetEntryMapForType(byte type_id) {
            return this.type_map_.get(type_id);
        }
    }
}

