/*
 * Decompiled with CFR 0.152.
 */
package org.robolectric.res;

import org.robolectric.res.DrawableNode;
import org.robolectric.res.FsFile;
import org.robolectric.res.ResBundle;
import org.robolectric.res.ResName;
import org.robolectric.res.ResourcePath;
import org.robolectric.res.XmlLoader;
import org.robolectric.res.XpathResourceXmlLoader;

public class DrawableResourceLoader
extends XmlLoader {
    private final ResBundle<DrawableNode> drawableNodes;

    public static boolean isStillHandledHere(ResName resName) {
        return "drawable".equals(resName.type) || "anim".equals(resName.type) || "mipmap".equals(resName.type);
    }

    public DrawableResourceLoader(ResBundle<DrawableNode> drawableNodes) {
        this.drawableNodes = drawableNodes;
    }

    @Override
    protected void processResourceXml(FsFile xmlFile, XpathResourceXmlLoader.XmlNode xmlNode, XmlLoader.XmlContext xmlContext) throws Exception {
        String name = this.toResourceName(xmlFile);
        this.drawableNodes.put(xmlContext.getDirPrefix(), name, new DrawableNode.Xml(this.parse(xmlFile), xmlContext), xmlContext);
    }

    private String toResourceName(FsFile xmlFile) {
        return xmlFile.getName().replaceAll("\\..+$", "");
    }

    public void findDrawableResources(ResourcePath resourcePath) {
        FsFile[] files = resourcePath.resourceBase.listFiles();
        if (files != null) {
            for (FsFile f : files) {
                if (f.isDirectory() && f.getName().startsWith("drawable")) {
                    this.listDrawableResources(resourcePath, f, "drawable");
                    continue;
                }
                if (!f.isDirectory() || !f.getName().startsWith("mipmap")) continue;
                this.listDrawableResources(resourcePath, f, "mipmap");
            }
        }
    }

    private void listDrawableResources(ResourcePath resourcePath, FsFile dir, String type) {
        FsFile[] files = dir.listFiles();
        if (files != null) {
            for (FsFile f : files) {
                String shortName;
                String name = f.getName();
                if (name.startsWith(".") || name.endsWith(".xml")) continue;
                if (name.endsWith(".9.png")) {
                    String[] tokens = name.split("\\.9\\.png$");
                    shortName = tokens[0];
                } else {
                    shortName = f.getBaseName();
                }
                XmlLoader.XmlContext fakeXmlContext = new XmlLoader.XmlContext(resourcePath.getPackageName(), f);
                this.drawableNodes.put(type, shortName, new DrawableNode.ImageFile(f, true), fakeXmlContext);
            }
        }
    }
}

