/*
 * Decompiled with CFR 0.152.
 */
package org.robolectric.res;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.robolectric.res.PackageResourceLoader;
import org.robolectric.res.ResName;
import org.robolectric.res.ResourceIndex;

class OverlayResourceIndex
extends ResourceIndex {
    private final String packageName;
    private final Set<String> actualPackageNames = new HashSet<String>();

    public OverlayResourceIndex(String packageName, List<PackageResourceLoader> subResourceLoaders) {
        this(packageName, OverlayResourceIndex.map(subResourceLoaders));
    }

    private static ResourceIndex[] map(List<PackageResourceLoader> subResourceLoaders) {
        ResourceIndex[] resourceIndexes = new ResourceIndex[subResourceLoaders.size()];
        for (int i = 0; i < subResourceLoaders.size(); ++i) {
            resourceIndexes[i] = subResourceLoaders.get(i).getResourceIndex();
        }
        return resourceIndexes;
    }

    public OverlayResourceIndex(String packageName, ResourceIndex ... subResourceIndexes) {
        this.packageName = packageName;
        this.actualPackageNames.add(packageName);
        for (ResourceIndex subResourceIndex : subResourceIndexes) {
            this.actualPackageNames.addAll(subResourceIndex.getPackages());
            for (Map.Entry<ResName, Integer> entry : subResourceIndex.resourceNameToId.entrySet()) {
                ResName resName = entry.getKey();
                int value = entry.getValue();
                ResName localResName = resName.withPackageName(packageName);
                if (this.resourceNameToId.containsKey(localResName)) continue;
                this.resourceNameToId.put(localResName, value);
                this.resourceIdToResName.put(value, localResName);
            }
        }
    }

    @Override
    public Integer getResourceId(ResName resName) {
        if (!this.actualPackageNames.contains(resName.packageName)) {
            return null;
        }
        return (Integer)this.resourceNameToId.get(resName.withPackageName(this.packageName));
    }

    @Override
    public ResName getResName(int resourceId) {
        ResName resName = (ResName)this.resourceIdToResName.get(resourceId);
        return resName == null ? null : resName.withPackageName(this.packageName);
    }

    @Override
    public Collection<String> getPackages() {
        return this.actualPackageNames;
    }

    public String toString() {
        return "OverlayResourceIndex{package='" + this.packageName + '\'' + '}';
    }

    class ResEntry {
        private final ResName resName;
        private final int value;

        public ResEntry(ResName resName, int value) {
            this.resName = resName;
            this.value = value;
        }
    }

    class ResEntries {
        private final Map<ResName, List<ResEntry>> resEntries = new HashMap<ResName, List<ResEntry>>();

        ResEntries() {
        }

        public void add(ResName localResName, ResName resName, int value) {
            List<ResEntry> resEntryList = this.resEntries.get(localResName);
            if (resEntryList == null) {
                resEntryList = new ArrayList<ResEntry>();
                this.resEntries.put(localResName, resEntryList);
            }
            resEntryList.add(new ResEntry(resName, value));
        }
    }
}

