/*
 * Decompiled with CFR 0.152.
 */
package org.robolectric.res;

import java.util.ArrayList;
import org.robolectric.res.Attribute;
import org.robolectric.res.FsFile;
import org.robolectric.res.PreferenceNode;
import org.robolectric.res.ResBundle;
import org.robolectric.res.XmlLoader;
import org.robolectric.res.XpathResourceXmlLoader;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class PreferenceLoader
extends XmlLoader {
    private final ResBundle<PreferenceNode> resBundle;

    public PreferenceLoader(ResBundle<PreferenceNode> resBundle) {
        this.resBundle = resBundle;
    }

    @Override
    protected void processResourceXml(FsFile xmlFile, XpathResourceXmlLoader.XmlNode xmlNode, XmlLoader.XmlContext xmlContext) throws Exception {
        PreferenceNode topLevelNode = new PreferenceNode("top-level", new ArrayList<Attribute>());
        this.processChildren(this.parse(xmlFile).getChildNodes(), topLevelNode, xmlContext);
        this.resBundle.put("xml", xmlFile.getName().replace(".xml", ""), topLevelNode.getChildren().get(0), xmlContext);
    }

    private void processChildren(NodeList childNodes, PreferenceNode parent, XmlLoader.XmlContext xmlContext) {
        for (int i = 0; i < childNodes.getLength(); ++i) {
            Node node = childNodes.item(i);
            this.processNode(node, parent, xmlContext);
        }
    }

    private void processNode(Node node, PreferenceNode parent, XmlLoader.XmlContext xmlContext) {
        String name = node.getNodeName();
        NamedNodeMap attributes = node.getAttributes();
        ArrayList<Attribute> attrList = new ArrayList<Attribute>();
        if (attributes != null) {
            int length = attributes.getLength();
            for (int i = 0; i < length; ++i) {
                Node attr = attributes.item(i);
                String attrName = Attribute.qualifyName(attr.getNodeName(), xmlContext.packageName);
                if (attrName.startsWith("xmlns:")) continue;
                attrList.add(new Attribute(Attribute.addType(attrName, "attr"), attr.getNodeValue(), xmlContext.packageName));
            }
        }
        if (!name.startsWith("#")) {
            PreferenceNode prefNode = new PreferenceNode(name, attrList);
            if (parent != null) {
                parent.addChild(prefNode);
            }
            this.processChildren(node.getChildNodes(), prefNode, xmlContext);
        }
    }
}

