/*
 * Decompiled with CFR 0.152.
 */
package org.robolectric.internal.bytecode;

import java.lang.reflect.Modifier;
import org.objectweb.asm.MethodVisitor;
import org.objectweb.asm.Type;
import org.objectweb.asm.commons.GeneratorAdapter;
import org.objectweb.asm.tree.MethodNode;
import org.robolectric.internal.bytecode.ClassInstrumentor;

class RobolectricGeneratorAdapter
extends GeneratorAdapter {
    final boolean isStatic;
    private final String desc;

    public RobolectricGeneratorAdapter(MethodNode methodNode) {
        super(262144, (MethodVisitor)methodNode, methodNode.access, methodNode.name, methodNode.desc);
        this.isStatic = Modifier.isStatic(methodNode.access);
        this.desc = methodNode.desc;
    }

    public void loadThisOrNull() {
        if (this.isStatic) {
            this.loadNull();
        } else {
            this.loadThis();
        }
    }

    public boolean isStatic() {
        return this.isStatic;
    }

    public void loadNull() {
        this.visitInsn(1);
    }

    public Type getReturnType() {
        return Type.getReturnType((String)this.desc);
    }

    public void pushDefaultReturnValueToStack(Type type) {
        if (type.equals((Object)Type.BOOLEAN_TYPE)) {
            this.push(false);
        } else if (type.equals((Object)Type.INT_TYPE) || type.equals((Object)Type.SHORT_TYPE) || type.equals((Object)Type.BYTE_TYPE) || type.equals((Object)Type.CHAR_TYPE)) {
            this.push(0);
        } else if (type.equals((Object)Type.LONG_TYPE)) {
            this.push(0L);
        } else if (type.equals((Object)Type.FLOAT_TYPE)) {
            this.push(0.0f);
        } else if (type.equals((Object)Type.DOUBLE_TYPE)) {
            this.push(0.0);
        } else if (type.getSort() == 9 || type.getSort() == 10) {
            this.loadNull();
        }
    }

    void invokeMethod(String internalClassName, MethodNode method) {
        this.invokeMethod(internalClassName, method.name, method.desc);
    }

    void invokeMethod(String internalClassName, String methodName, String methodDesc) {
        if (this.isStatic()) {
            this.loadArgs();
            this.visitMethodInsn(184, internalClassName, methodName, methodDesc, false);
        } else {
            this.loadThisOrNull();
            this.loadArgs();
            this.visitMethodInsn(183, internalClassName, methodName, methodDesc, false);
        }
    }

    public ClassInstrumentor.TryCatch tryStart(Type exceptionType) {
        return new ClassInstrumentor.TryCatch(this, exceptionType);
    }
}

