/*
 * Decompiled with CFR 0.152.
 */
package org.robolectric.internal.bytecode;

import org.robolectric.annotation.Implements;

public class ShadowInfo {
    public final String shadowedClassName;
    public final String shadowClassName;
    public final boolean callThroughByDefault;
    @Deprecated
    public final boolean inheritImplementationMethods;
    public final boolean looseSignatures;
    private final int minSdk;
    private final int maxSdk;

    ShadowInfo(String shadowedClassName, String shadowClassName, boolean callThroughByDefault, boolean inheritImplementationMethods, boolean looseSignatures, int minSdk, int maxSdk) {
        this.shadowedClassName = shadowedClassName;
        this.shadowClassName = shadowClassName;
        this.callThroughByDefault = callThroughByDefault;
        this.inheritImplementationMethods = inheritImplementationMethods;
        this.looseSignatures = looseSignatures;
        this.minSdk = minSdk;
        this.maxSdk = maxSdk;
    }

    ShadowInfo(String shadowedClassName, String shadowClassName, Implements annotation) {
        this(shadowedClassName, shadowClassName, annotation.callThroughByDefault(), annotation.inheritImplementationMethods(), annotation.looseSignatures(), annotation.minSdk(), annotation.maxSdk());
    }

    public boolean supportsSdk(int sdkInt) {
        return this.minSdk <= sdkInt && (this.maxSdk == -1 || this.maxSdk >= sdkInt);
    }

    public boolean isShadowOf(Class<?> clazz) {
        return this.shadowedClassName.equals(clazz.getName());
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ShadowInfo that = (ShadowInfo)o;
        if (this.callThroughByDefault != that.callThroughByDefault) {
            return false;
        }
        if (this.inheritImplementationMethods != that.inheritImplementationMethods) {
            return false;
        }
        if (this.looseSignatures != that.looseSignatures) {
            return false;
        }
        if (this.minSdk != that.minSdk) {
            return false;
        }
        if (this.maxSdk != that.maxSdk) {
            return false;
        }
        return this.shadowClassName != null ? this.shadowClassName.equals(that.shadowClassName) : that.shadowClassName == null;
    }

    public int hashCode() {
        int result = this.shadowClassName != null ? this.shadowClassName.hashCode() : 0;
        result = 31 * result + (this.callThroughByDefault ? 1 : 0);
        result = 31 * result + (this.inheritImplementationMethods ? 1 : 0);
        result = 31 * result + (this.looseSignatures ? 1 : 0);
        result = 31 * result + this.minSdk;
        result = 31 * result + this.maxSdk;
        return result;
    }
}

