/*
 * Decompiled with CFR 0.152.
 */
package org.robolectric.shadows;

import android.accessibilityservice.AccessibilityServiceInfo;
import android.content.Context;
import android.content.pm.ServiceInfo;
import android.os.Handler;
import android.os.Looper;
import android.os.Message;
import android.util.Log;
import android.view.accessibility.AccessibilityManager;
import java.util.List;
import org.robolectric.annotation.HiddenApi;
import org.robolectric.annotation.Implementation;
import org.robolectric.annotation.Implements;
import org.robolectric.internal.Shadow;
import org.robolectric.util.ReflectionHelpers;

@Implements(value=AccessibilityManager.class)
public class ShadowAccessibilityManager {
    private boolean enabled;
    private List<AccessibilityServiceInfo> installedAccessibilityServiceList;
    private List<AccessibilityServiceInfo> enabledAccessibilityServiceList;
    private List<ServiceInfo> accessibilityServiceList;
    private boolean touchExplorationEnabled;

    @HiddenApi
    @Implementation
    public static AccessibilityManager getInstance(Context context) throws Exception {
        AccessibilityManager accessibilityManager = (AccessibilityManager)Shadow.newInstance(AccessibilityManager.class, (Class[])new Class[0], (Object[])new Object[0]);
        ReflectionHelpers.setField((Object)accessibilityManager, (String)"mHandler", (Object)((Object)new MyHandler(context.getMainLooper(), accessibilityManager)));
        return accessibilityManager;
    }

    @Implementation
    public boolean addAccessibilityStateChangeListener(AccessibilityManager.AccessibilityStateChangeListener listener) {
        return true;
    }

    @Implementation
    public boolean removeAccessibilityStateChangeListener(AccessibilityManager.AccessibilityStateChangeListener listener) {
        return true;
    }

    @Implementation
    public List<ServiceInfo> getAccessibilityServiceList() {
        return this.accessibilityServiceList;
    }

    public void setAccessibilityServiceList(List<ServiceInfo> accessibilityServiceList) {
        this.accessibilityServiceList = accessibilityServiceList;
    }

    @Implementation
    public List<AccessibilityServiceInfo> getEnabledAccessibilityServiceList(int feedbackTypeFlags) {
        return this.enabledAccessibilityServiceList;
    }

    public void setEnabledAccessibilityServiceList(List<AccessibilityServiceInfo> enabledAccessibilityServiceList) {
        this.enabledAccessibilityServiceList = enabledAccessibilityServiceList;
    }

    @Implementation
    public List<AccessibilityServiceInfo> getInstalledAccessibilityServiceList() {
        return this.installedAccessibilityServiceList;
    }

    public void setInstalledAccessibilityServiceList(List<AccessibilityServiceInfo> installedAccessibilityServiceList) {
        this.installedAccessibilityServiceList = installedAccessibilityServiceList;
    }

    @Implementation
    public boolean isEnabled() {
        return this.enabled;
    }

    public void setEnabled(boolean enabled) {
        this.enabled = enabled;
    }

    @Implementation
    public boolean isTouchExplorationEnabled() {
        return this.touchExplorationEnabled;
    }

    public void setTouchExplorationEnabled(boolean touchExplorationEnabled) {
        this.touchExplorationEnabled = touchExplorationEnabled;
    }

    static class MyHandler
    extends Handler {
        private static final int DO_SET_STATE = 10;
        private final AccessibilityManager accessibilityManager;

        MyHandler(Looper mainLooper, AccessibilityManager accessibilityManager) {
            super(mainLooper);
            this.accessibilityManager = accessibilityManager;
        }

        public void handleMessage(Message message) {
            switch (message.what) {
                case 10: {
                    ReflectionHelpers.callInstanceMethod((Object)this.accessibilityManager, (String)"setState", (ReflectionHelpers.ClassParameter[])new ReflectionHelpers.ClassParameter[]{ReflectionHelpers.ClassParameter.from(Integer.TYPE, (Object)message.arg1)});
                    return;
                }
            }
            Log.w((String)"AccessibilityManager", (String)("Unknown message type: " + message.what));
        }
    }
}

