/*
 * Decompiled with CFR 0.152.
 */
package org.robolectric.shadows;

import android.accounts.Account;
import android.content.ContentProvider;
import android.content.ContentProviderClient;
import android.content.ContentProviderOperation;
import android.content.ContentProviderResult;
import android.content.ContentResolver;
import android.content.ContentValues;
import android.content.IContentProvider;
import android.content.OperationApplicationException;
import android.content.PeriodicSync;
import android.database.ContentObserver;
import android.database.Cursor;
import android.net.Uri;
import android.os.Bundle;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.CopyOnWriteArraySet;
import org.robolectric.RuntimeEnvironment;
import org.robolectric.Shadows;
import org.robolectric.annotation.Implementation;
import org.robolectric.annotation.Implements;
import org.robolectric.annotation.RealObject;
import org.robolectric.annotation.Resetter;
import org.robolectric.fakes.BaseCursor;
import org.robolectric.internal.Shadow;
import org.robolectric.manifest.AndroidManifest;
import org.robolectric.manifest.ContentProviderData;
import org.robolectric.util.NamedStream;

@Implements(value=ContentResolver.class)
public class ShadowContentResolver {
    private int nextDatabaseIdForInserts;
    private int nextDatabaseIdForUpdates;
    @RealObject
    ContentResolver realContentResolver;
    private BaseCursor cursor;
    private final List<InsertStatement> insertStatements = new ArrayList<InsertStatement>();
    private final List<UpdateStatement> updateStatements = new ArrayList<UpdateStatement>();
    private final List<DeleteStatement> deleteStatements = new ArrayList<DeleteStatement>();
    private List<NotifiedUri> notifiedUris = new ArrayList<NotifiedUri>();
    private Map<Uri, BaseCursor> uriCursorMap = new HashMap<Uri, BaseCursor>();
    private Map<Uri, InputStream> inputStreamMap = new HashMap<Uri, InputStream>();
    private final Map<String, ArrayList<ContentProviderOperation>> contentProviderOperations = new HashMap<String, ArrayList<ContentProviderOperation>>();
    private ContentProviderResult[] contentProviderResults;
    private final Map<Uri, CopyOnWriteArraySet<ContentObserver>> contentObservers = new HashMap<Uri, CopyOnWriteArraySet<ContentObserver>>();
    private static final Map<String, Map<Account, Status>> syncableAccounts = new HashMap<String, Map<Account, Status>>();
    private static final Map<String, ContentProvider> providers = new HashMap<String, ContentProvider>();
    private static boolean masterSyncAutomatically;

    @Resetter
    public static void reset() {
        syncableAccounts.clear();
        providers.clear();
        masterSyncAutomatically = false;
    }

    public void registerInputStream(Uri uri, InputStream inputStream) {
        this.inputStreamMap.put(uri, inputStream);
    }

    @Implementation
    public final InputStream openInputStream(Uri uri) {
        InputStream inputStream = this.inputStreamMap.get(uri);
        if (inputStream != null) {
            return inputStream;
        }
        return new UnregisteredInputStream(uri);
    }

    @Implementation
    public final OutputStream openOutputStream(final Uri uri) {
        return new OutputStream(){

            @Override
            public void write(int arg0) throws IOException {
            }

            public String toString() {
                return "outputstream for " + uri;
            }
        };
    }

    @Implementation
    public final Uri insert(Uri url, ContentValues values) {
        ContentProvider provider = ShadowContentResolver.getProvider(url);
        if (provider != null) {
            return provider.insert(url, values);
        }
        InsertStatement insertStatement = new InsertStatement(url, new ContentValues(values));
        this.insertStatements.add(insertStatement);
        return Uri.parse((String)(url.toString() + "/" + ++this.nextDatabaseIdForInserts));
    }

    @Implementation
    public int update(Uri uri, ContentValues values, String where, String[] selectionArgs) {
        ContentProvider provider = ShadowContentResolver.getProvider(uri);
        if (provider != null) {
            return provider.update(uri, values, where, selectionArgs);
        }
        UpdateStatement updateStatement = new UpdateStatement(uri, new ContentValues(values), where, selectionArgs);
        this.updateStatements.add(updateStatement);
        return ++this.nextDatabaseIdForUpdates;
    }

    @Implementation
    public final Cursor query(Uri uri, String[] projection, String selection, String[] selectionArgs, String sortOrder) {
        ContentProvider provider = ShadowContentResolver.getProvider(uri);
        if (provider != null) {
            return provider.query(uri, projection, selection, selectionArgs, sortOrder);
        }
        BaseCursor returnCursor = this.getCursor(uri);
        if (returnCursor == null) {
            return null;
        }
        returnCursor.setQuery(uri, projection, selection, selectionArgs, sortOrder);
        return returnCursor;
    }

    @Implementation
    public String getType(Uri uri) {
        ContentProvider provider = ShadowContentResolver.getProvider(uri);
        if (provider != null) {
            return provider.getType(uri);
        }
        return null;
    }

    @Implementation
    public Bundle call(Uri uri, String method, String arg, Bundle extras) {
        ContentProvider cp = ShadowContentResolver.getProvider(uri);
        if (cp != null) {
            return cp.call(method, arg, extras);
        }
        return null;
    }

    @Implementation
    public final ContentProviderClient acquireContentProviderClient(String name) {
        ContentProvider provider = ShadowContentResolver.getProvider(name);
        if (provider == null) {
            return null;
        }
        return this.getContentProviderClient(provider, true);
    }

    @Implementation
    public final ContentProviderClient acquireContentProviderClient(Uri uri) {
        ContentProvider provider = ShadowContentResolver.getProvider(uri);
        if (provider == null) {
            return null;
        }
        return this.getContentProviderClient(provider, true);
    }

    @Implementation
    public final ContentProviderClient acquireUnstableContentProviderClient(String name) {
        ContentProvider provider = ShadowContentResolver.getProvider(name);
        if (provider == null) {
            return null;
        }
        return this.getContentProviderClient(provider, false);
    }

    @Implementation
    public final ContentProviderClient acquireUnstableContentProviderClient(Uri uri) {
        ContentProvider provider = ShadowContentResolver.getProvider(uri);
        if (provider == null) {
            return null;
        }
        return this.getContentProviderClient(provider, false);
    }

    private ContentProviderClient getContentProviderClient(ContentProvider provider, boolean stable) {
        ContentProviderClient client = (ContentProviderClient)Shadow.newInstance(ContentProviderClient.class, (Class[])new Class[]{ContentResolver.class, IContentProvider.class, Boolean.TYPE}, (Object[])new Object[]{this.realContentResolver, provider.getIContentProvider(), stable});
        Shadows.shadowOf(client).setContentProvider(provider);
        return client;
    }

    @Implementation
    public final IContentProvider acquireProvider(String name) {
        return this.acquireUnstableProvider(name);
    }

    @Implementation
    public final IContentProvider acquireProvider(Uri uri) {
        return this.acquireUnstableProvider(uri);
    }

    @Implementation
    public final IContentProvider acquireUnstableProvider(String name) {
        ContentProvider cp = ShadowContentResolver.getProvider(name);
        if (cp != null) {
            return cp.getIContentProvider();
        }
        return null;
    }

    @Implementation
    public final IContentProvider acquireUnstableProvider(Uri uri) {
        ContentProvider cp = ShadowContentResolver.getProvider(uri);
        if (cp != null) {
            return cp.getIContentProvider();
        }
        return null;
    }

    @Implementation
    public final int delete(Uri url, String where, String[] selectionArgs) {
        ContentProvider provider = ShadowContentResolver.getProvider(url);
        if (provider != null) {
            return provider.delete(url, where, selectionArgs);
        }
        DeleteStatement deleteStatement = new DeleteStatement(url, where, selectionArgs);
        this.deleteStatements.add(deleteStatement);
        return 1;
    }

    @Implementation
    public final int bulkInsert(Uri url, ContentValues[] values) {
        ContentProvider provider = ShadowContentResolver.getProvider(url);
        if (provider != null) {
            return provider.bulkInsert(url, values);
        }
        return 0;
    }

    @Implementation
    public void notifyChange(Uri uri, ContentObserver observer, boolean syncToNetwork) {
        this.notifiedUris.add(new NotifiedUri(uri, observer, syncToNetwork));
        CopyOnWriteArraySet<ContentObserver> observers = this.contentObservers.get(uri);
        if (observers != null) {
            for (ContentObserver obs : observers) {
                if (obs == null || obs == observer) continue;
                obs.dispatchChange(false, uri);
            }
        }
        if (observer != null && observer.deliverSelfNotifications()) {
            observer.dispatchChange(true, uri);
        }
    }

    @Implementation
    public void notifyChange(Uri uri, ContentObserver observer) {
        this.notifyChange(uri, observer, false);
    }

    @Implementation
    public ContentProviderResult[] applyBatch(String authority, ArrayList<ContentProviderOperation> operations) throws OperationApplicationException {
        ContentProvider provider = ShadowContentResolver.getProvider(authority);
        if (provider != null) {
            return provider.applyBatch(operations);
        }
        this.contentProviderOperations.put(authority, operations);
        return this.contentProviderResults;
    }

    @Implementation
    public static void requestSync(Account account, String authority, Bundle extras) {
        ShadowContentResolver.validateSyncExtrasBundle(extras);
        Status status = ShadowContentResolver.getStatus(account, authority, true);
        ++status.syncRequests;
        status.syncExtras = extras;
    }

    @Implementation
    public static void cancelSync(Account account, String authority) {
        Status status = ShadowContentResolver.getStatus(account, authority);
        if (status != null) {
            status.syncRequests = 0;
            if (status.syncExtras != null) {
                status.syncExtras.clear();
            }
            if (status.syncs != null) {
                status.syncs.clear();
            }
        }
    }

    @Implementation
    public static boolean isSyncActive(Account account, String authority) {
        Status status = ShadowContentResolver.getStatus(account, authority);
        return status != null && status.syncRequests > 0;
    }

    @Implementation
    public static void setIsSyncable(Account account, String authority, int syncable) {
        ShadowContentResolver.getStatus((Account)account, (String)authority, (boolean)true).state = syncable;
    }

    @Implementation
    public static int getIsSyncable(Account account, String authority) {
        return ShadowContentResolver.getStatus((Account)account, (String)authority, (boolean)true).state;
    }

    @Implementation
    public static boolean getSyncAutomatically(Account account, String authority) {
        return ShadowContentResolver.getStatus((Account)account, (String)authority, (boolean)true).syncAutomatically;
    }

    @Implementation
    public static void setSyncAutomatically(Account account, String authority, boolean sync) {
        ShadowContentResolver.getStatus((Account)account, (String)authority, (boolean)true).syncAutomatically = sync;
    }

    @Implementation
    public static void addPeriodicSync(Account account, String authority, Bundle extras, long pollFrequency) {
        ShadowContentResolver.validateSyncExtrasBundle(extras);
        ShadowContentResolver.removePeriodicSync(account, authority, extras);
        ShadowContentResolver.getStatus((Account)account, (String)authority, (boolean)true).syncs.add(new PeriodicSync(account, authority, extras, pollFrequency));
    }

    @Implementation
    public static void removePeriodicSync(Account account, String authority, Bundle extras) {
        ShadowContentResolver.validateSyncExtrasBundle(extras);
        Status status = ShadowContentResolver.getStatus(account, authority);
        if (status != null) {
            for (int i = 0; i < status.syncs.size(); ++i) {
                if (!Objects.equals(extras, status.syncs.get((int)i).extras)) continue;
                status.syncs.remove(i);
                break;
            }
        }
    }

    @Implementation
    public static List<PeriodicSync> getPeriodicSyncs(Account account, String authority) {
        return ShadowContentResolver.getStatus((Account)account, (String)authority, (boolean)true).syncs;
    }

    @Implementation
    public static void validateSyncExtrasBundle(Bundle extras) {
        for (String key : extras.keySet()) {
            Object value = extras.get(key);
            if (value == null || value instanceof Long || value instanceof Integer || value instanceof Boolean || value instanceof Float || value instanceof Double || value instanceof String || value instanceof Account) continue;
            throw new IllegalArgumentException("unexpected value type: " + value.getClass().getName());
        }
    }

    @Implementation
    public static void setMasterSyncAutomatically(boolean sync) {
        masterSyncAutomatically = sync;
    }

    @Implementation
    public static boolean getMasterSyncAutomatically() {
        return masterSyncAutomatically;
    }

    public static ContentProvider getProvider(Uri uri) {
        if (uri == null || !"content".equals(uri.getScheme())) {
            return null;
        }
        return ShadowContentResolver.getProvider(uri.getAuthority());
    }

    private static ContentProvider getProvider(String authority) {
        AndroidManifest manifest;
        if (!providers.containsKey(authority) && (manifest = Shadows.shadowOf(RuntimeEnvironment.application).getAppManifest()) != null) {
            for (ContentProviderData providerData : manifest.getContentProviders()) {
                if (!providerData.getAuthority().equals(authority)) continue;
                providers.put(providerData.getAuthority(), ShadowContentResolver.createAndInitialize(providerData));
            }
        }
        return providers.get(authority);
    }

    public static void registerProvider(String authority, ContentProvider provider) {
        providers.put(authority, provider);
    }

    public static Status getStatus(Account account, String authority) {
        return ShadowContentResolver.getStatus(account, authority, false);
    }

    public static Status getStatus(Account account, String authority, boolean create) {
        Status status;
        Map<Account, Status> map = syncableAccounts.get(authority);
        if (map == null) {
            map = new HashMap<Account, Status>();
            syncableAccounts.put(authority, map);
        }
        if ((status = map.get(account)) == null && create) {
            status = new Status();
            map.put(account, status);
        }
        return status;
    }

    public void setCursor(BaseCursor cursor) {
        this.cursor = cursor;
    }

    public void setCursor(Uri uri, BaseCursor cursorForUri) {
        this.uriCursorMap.put(uri, cursorForUri);
    }

    public void setNextDatabaseIdForInserts(int nextId) {
        this.nextDatabaseIdForInserts = nextId;
    }

    public void setNextDatabaseIdForUpdates(int nextId) {
        this.nextDatabaseIdForUpdates = nextId;
    }

    public List<InsertStatement> getInsertStatements() {
        return this.insertStatements;
    }

    public List<UpdateStatement> getUpdateStatements() {
        return this.updateStatements;
    }

    public List<Uri> getDeletedUris() {
        ArrayList<Uri> uris = new ArrayList<Uri>();
        for (DeleteStatement deleteStatement : this.deleteStatements) {
            uris.add(deleteStatement.getUri());
        }
        return uris;
    }

    public List<DeleteStatement> getDeleteStatements() {
        return this.deleteStatements;
    }

    public List<NotifiedUri> getNotifiedUris() {
        return this.notifiedUris;
    }

    public ArrayList<ContentProviderOperation> getContentProviderOperations(String authority) {
        ArrayList<ContentProviderOperation> operations = this.contentProviderOperations.get(authority);
        if (operations == null) {
            return new ArrayList<ContentProviderOperation>();
        }
        return operations;
    }

    public void setContentProviderResult(ContentProviderResult[] contentProviderResults) {
        this.contentProviderResults = contentProviderResults;
    }

    @Implementation
    public void registerContentObserver(Uri uri, boolean notifyForDescendents, ContentObserver observer) {
        CopyOnWriteArraySet<Object> observers = this.contentObservers.get(uri);
        if (observers == null) {
            observers = new CopyOnWriteArraySet();
            this.contentObservers.put(uri, observers);
        }
        observers.add(observer);
    }

    @Implementation
    public void registerContentObserver(Uri uri, boolean notifyForDescendents, ContentObserver observer, int userHandle) {
        this.registerContentObserver(uri, notifyForDescendents, observer);
    }

    @Implementation
    public void unregisterContentObserver(ContentObserver observer) {
        if (observer != null) {
            for (CopyOnWriteArraySet<ContentObserver> observers : this.contentObservers.values()) {
                observers.remove(observer);
            }
        }
    }

    public void clearContentObservers() {
        this.contentObservers.clear();
    }

    @Deprecated
    public ContentObserver getContentObserver(Uri uri) {
        Collection<ContentObserver> observers = this.getContentObservers(uri);
        return observers.isEmpty() ? null : observers.iterator().next();
    }

    public Collection<ContentObserver> getContentObservers(Uri uri) {
        CopyOnWriteArraySet<ContentObserver> observers = this.contentObservers.get(uri);
        return observers == null ? Collections.emptyList() : observers;
    }

    private static ContentProvider createAndInitialize(ContentProviderData providerData) {
        try {
            ContentProvider provider = (ContentProvider)Class.forName(providerData.getClassName()).newInstance();
            provider.onCreate();
            return provider;
        }
        catch (ClassNotFoundException | IllegalAccessException | InstantiationException e) {
            throw new RuntimeException("Error instantiating class " + providerData.getClassName());
        }
    }

    private BaseCursor getCursor(Uri uri) {
        if (this.uriCursorMap.get(uri) != null) {
            return this.uriCursorMap.get(uri);
        }
        if (this.cursor != null) {
            return this.cursor;
        }
        return null;
    }

    private static class UnregisteredInputStream
    extends InputStream
    implements NamedStream {
        private final Uri uri;

        public UnregisteredInputStream(Uri uri) {
            this.uri = uri;
        }

        @Override
        public int read() throws IOException {
            throw new UnsupportedOperationException("You must use ShadowContentResolver.registerInputStream() in order to call read()");
        }

        public String toString() {
            return "stream for " + this.uri;
        }
    }

    public static class DeleteStatement {
        private final Uri uri;
        private final String where;
        private final String[] selectionArgs;

        public DeleteStatement(Uri uri, String where, String[] selectionArgs) {
            this.uri = uri;
            this.where = where;
            this.selectionArgs = selectionArgs;
        }

        public Uri getUri() {
            return this.uri;
        }

        public String getWhere() {
            return this.where;
        }

        public String[] getSelectionArgs() {
            return this.selectionArgs;
        }
    }

    public static class UpdateStatement {
        private final Uri uri;
        private final ContentValues values;
        private final String where;
        private final String[] selectionArgs;

        public UpdateStatement(Uri uri, ContentValues values, String where, String[] selectionArgs) {
            this.uri = uri;
            this.values = values;
            this.where = where;
            this.selectionArgs = selectionArgs;
        }

        public Uri getUri() {
            return this.uri;
        }

        public ContentValues getContentValues() {
            return this.values;
        }

        public String getWhere() {
            return this.where;
        }

        public String[] getSelectionArgs() {
            return this.selectionArgs;
        }
    }

    public static class InsertStatement {
        private final Uri uri;
        private final ContentValues contentValues;

        public InsertStatement(Uri uri, ContentValues contentValues) {
            this.uri = uri;
            this.contentValues = contentValues;
        }

        public Uri getUri() {
            return this.uri;
        }

        public ContentValues getContentValues() {
            return this.contentValues;
        }
    }

    public static class Status {
        public int syncRequests;
        public int state = -1;
        public boolean syncAutomatically;
        public Bundle syncExtras;
        public List<PeriodicSync> syncs = new ArrayList<PeriodicSync>();
    }

    public static class NotifiedUri {
        public final Uri uri;
        public final boolean syncToNetwork;
        public final ContentObserver observer;

        public NotifiedUri(Uri uri, ContentObserver observer, boolean syncToNetwork) {
            this.uri = uri;
            this.syncToNetwork = syncToNetwork;
            this.observer = observer;
        }
    }
}

