/*
 * Decompiled with CFR 0.152.
 */
package org.robolectric.shadows;

import android.content.BroadcastReceiver;
import android.content.ComponentName;
import android.content.ContentResolver;
import android.content.Context;
import android.content.ContextWrapper;
import android.content.Intent;
import android.content.IntentFilter;
import android.content.ServiceConnection;
import android.content.SharedPreferences;
import android.content.pm.ApplicationInfo;
import android.content.pm.PackageManager;
import android.content.res.AssetManager;
import android.content.res.Resources;
import android.os.Bundle;
import android.os.Handler;
import android.os.Looper;
import java.io.File;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.robolectric.RuntimeEnvironment;
import org.robolectric.Shadows;
import org.robolectric.annotation.Implementation;
import org.robolectric.annotation.Implements;
import org.robolectric.annotation.RealObject;
import org.robolectric.fakes.RoboSharedPreferences;
import org.robolectric.res.ResourceLoader;
import org.robolectric.shadows.ShadowApplication;
import org.robolectric.shadows.ShadowContext;

@Implements(value=ContextWrapper.class)
public class ShadowContextWrapper
extends ShadowContext {
    private final Map<String, RoboSharedPreferences> sharedPreferencesMap = new HashMap<String, RoboSharedPreferences>();
    @RealObject
    private ContextWrapper realContextWrapper;
    private String packageName;

    @Implementation
    public int checkCallingPermission(String permission) {
        return this.checkPermission(permission, -1, -1);
    }

    @Implementation
    public int checkCallingOrSelfPermission(String permission) {
        return this.checkPermission(permission, -1, -1);
    }

    @Implementation
    public Context getApplicationContext() {
        Context applicationContext = this.realContextWrapper.getBaseContext().getApplicationContext();
        return applicationContext == null ? RuntimeEnvironment.application : applicationContext;
    }

    @Implementation
    public ApplicationInfo getApplicationInfo() {
        try {
            PackageManager packageManager = RuntimeEnvironment.getPackageManager();
            return packageManager != null ? packageManager.getApplicationInfo(this.getPackageName(), 0) : null;
        }
        catch (PackageManager.NameNotFoundException e) {
            throw new RuntimeException("Could not find applicationInfo for current package.");
        }
    }

    @Implementation
    public int getUserId() {
        return 0;
    }

    @Override
    public ResourceLoader getResourceLoader() {
        return super.getResourceLoader();
    }

    @Override
    @Implementation
    public String getString(int resId) {
        return super.getString(resId);
    }

    @Override
    @Implementation
    public String getString(int resId, Object ... formatArgs) {
        return super.getString(resId, formatArgs);
    }

    @Override
    @Implementation
    public CharSequence getText(int resId) {
        return super.getText(resId);
    }

    @Override
    @Implementation
    public File getExternalCacheDir() {
        return super.getExternalCacheDir();
    }

    @Override
    @Implementation
    public File getExternalFilesDir(String type) {
        return super.getExternalFilesDir(type);
    }

    @Override
    @Implementation
    public Resources getResources() {
        return this.getApplicationContext().getResources();
    }

    @Implementation
    public ContentResolver getContentResolver() {
        return this.getApplicationContext().getContentResolver();
    }

    @Implementation
    public void sendBroadcast(Intent intent) {
        this.getApplicationContext().sendBroadcast(intent);
    }

    @Implementation
    public void sendBroadcast(Intent intent, String receiverPermission) {
        this.getApplicationContext().sendBroadcast(intent, receiverPermission);
    }

    @Implementation
    public void sendOrderedBroadcast(Intent intent, String receiverPermission) {
        this.getApplicationContext().sendOrderedBroadcast(intent, receiverPermission);
    }

    @Implementation
    public void sendStickyBroadcast(Intent intent) {
        this.getApplicationContext().sendStickyBroadcast(intent);
    }

    public List<Intent> getBroadcastIntents() {
        return ((ShadowApplication)Shadows.shadowOf(this.getApplicationContext())).getBroadcastIntents();
    }

    @Implementation
    public int checkPermission(String permission, int pid, int uid) {
        return this.getShadowApplication().checkPermission(permission, pid, uid);
    }

    @Implementation
    public Intent registerReceiver(BroadcastReceiver receiver, IntentFilter filter) {
        return ((ShadowApplication)Shadows.shadowOf(this.getApplicationContext())).registerReceiverWithContext(receiver, filter, null, null, (Context)this.realContextWrapper);
    }

    @Implementation
    public Intent registerReceiver(BroadcastReceiver receiver, IntentFilter filter, String broadcastPermission, Handler scheduler) {
        return ((ShadowApplication)Shadows.shadowOf(this.getApplicationContext())).registerReceiverWithContext(receiver, filter, broadcastPermission, scheduler, (Context)this.realContextWrapper);
    }

    @Implementation
    public void unregisterReceiver(BroadcastReceiver broadcastReceiver) {
        this.getApplicationContext().unregisterReceiver(broadcastReceiver);
    }

    @Implementation
    public ClassLoader getClassLoader() {
        return this.getClass().getClassLoader();
    }

    @Implementation
    public String getPackageName() {
        return this.realContextWrapper == this.getApplicationContext() ? this.packageName : this.getApplicationContext().getPackageName();
    }

    @Implementation
    public PackageManager getPackageManager() {
        return RuntimeEnvironment.getPackageManager();
    }

    @Implementation
    public ComponentName startService(Intent service) {
        return this.getApplicationContext().startService(service);
    }

    @Implementation
    public boolean stopService(Intent name) {
        return this.getApplicationContext().stopService(name);
    }

    @Implementation
    public void startActivity(Intent intent) {
        this.getApplicationContext().startActivity(intent);
    }

    @Implementation
    public void startActivity(Intent intent, Bundle options) {
        this.getApplicationContext().startActivity(intent, options);
    }

    @Implementation
    public void startActivities(Intent[] intents) {
        for (int i = intents.length - 1; i >= 0; --i) {
            this.startActivity(intents[i]);
        }
    }

    @Implementation
    public void startActivities(Intent[] intents, Bundle options) {
        for (int i = intents.length - 1; i >= 0; --i) {
            this.startActivity(intents[i], options);
        }
    }

    @Implementation
    public SharedPreferences getSharedPreferences(String name, int mode) {
        if (!this.sharedPreferencesMap.containsKey(name)) {
            this.sharedPreferencesMap.put(name, new RoboSharedPreferences(this.getShadowApplication().getSharedPreferenceMap(), name, mode));
        }
        return this.sharedPreferencesMap.get(name);
    }

    @Implementation
    public AssetManager getAssets() {
        return this.getResources().getAssets();
    }

    public void setPackageName(String packageName) {
        this.packageName = packageName;
    }

    public Intent getNextStartedActivity() {
        return this.getShadowApplication().getNextStartedActivity();
    }

    public Intent peekNextStartedActivity() {
        return this.getShadowApplication().peekNextStartedActivity();
    }

    public Intent getNextStartedService() {
        return this.getShadowApplication().getNextStartedService();
    }

    public void clearStartedServices() {
        this.getShadowApplication().clearStartedServices();
    }

    public Intent peekNextStartedService() {
        return this.getShadowApplication().peekNextStartedService();
    }

    public Intent getNextStoppedService() {
        return this.getShadowApplication().getNextStoppedService();
    }

    @Implementation
    public Looper getMainLooper() {
        return this.getShadowApplication().getMainLooper();
    }

    @Override
    public ShadowApplication getShadowApplication() {
        return (ShadowApplication)Shadows.shadowOf(this.getApplicationContext());
    }

    @Implementation
    public boolean bindService(Intent intent, ServiceConnection serviceConnection, int i) {
        return this.getShadowApplication().bindService(intent, serviceConnection, i);
    }

    @Implementation
    public void unbindService(ServiceConnection serviceConnection) {
        this.getShadowApplication().unbindService(serviceConnection);
    }

    @Implementation
    public boolean isRestricted() {
        return false;
    }

    public void grantPermissions(String ... permissionNames) {
        this.getShadowApplication().grantPermissions(permissionNames);
    }

    public void denyPermissions(String ... permissionNames) {
        this.getShadowApplication().denyPermissions(permissionNames);
    }
}

