/*
 * Decompiled with CFR 0.152.
 */
package org.robolectric.shadows;

import android.os.Handler;
import android.os.Message;
import org.robolectric.Shadows;
import org.robolectric.annotation.Implementation;
import org.robolectric.annotation.Implements;
import org.robolectric.annotation.RealObject;
import org.robolectric.annotation.Resetter;
import org.robolectric.internal.Shadow;
import org.robolectric.util.ReflectionHelpers;

@Implements(value=Message.class)
public class ShadowMessage {
    @RealObject
    private Message realMessage;
    private Runnable scheduledRunnable;

    private void unschedule() {
        Handler target = this.realMessage.getTarget();
        if (target != null && this.scheduledRunnable != null) {
            Shadows.shadowOf(target.getLooper()).getScheduler().remove(this.scheduledRunnable);
            this.scheduledRunnable = null;
        }
    }

    @Implementation
    public void recycle() {
        this.unschedule();
        Shadow.directlyOn((Object)this.realMessage, Message.class, (String)"recycle", (ReflectionHelpers.ClassParameter[])new ReflectionHelpers.ClassParameter[0]);
    }

    public void recycleUnchecked() {
        this.recycle();
    }

    public void setScheduledRunnable(Runnable r) {
        this.scheduledRunnable = r;
    }

    @Implementation
    public boolean isInUse() {
        return (Boolean)Shadow.directlyOn((Object)this.realMessage, Message.class, (String)"isInUse", (ReflectionHelpers.ClassParameter[])new ReflectionHelpers.ClassParameter[0]);
    }

    public Message getNext() {
        return (Message)ReflectionHelpers.getField((Object)this.realMessage, (String)"next");
    }

    public void setNext(Message next) {
        ReflectionHelpers.setField((Object)this.realMessage, (String)"next", (Object)next);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Resetter
    public static void reset() {
        Object lock;
        Object object = lock = ReflectionHelpers.getStaticField(Message.class, (String)"sPoolSync");
        synchronized (object) {
            ReflectionHelpers.setStaticField(Message.class, (String)"sPoolSize", (Object)0);
            ReflectionHelpers.setStaticField(Message.class, (String)"sPool", null);
        }
    }
}

