/*
 * Decompiled with CFR 0.152.
 */
package org.robolectric.shadows;

import android.app.Application;
import android.appwidget.AppWidgetManager;
import android.content.ActivityNotFoundException;
import android.content.BroadcastReceiver;
import android.content.ComponentName;
import android.content.ContentResolver;
import android.content.Context;
import android.content.IContentProvider;
import android.content.Intent;
import android.content.IntentFilter;
import android.content.ServiceConnection;
import android.content.res.AssetManager;
import android.content.res.Configuration;
import android.content.res.Resources;
import android.os.Bundle;
import android.os.Handler;
import android.os.IBinder;
import android.os.Looper;
import android.os.PowerManager;
import android.view.Display;
import android.view.LayoutInflater;
import android.widget.ListPopupWindow;
import android.widget.PopupWindow;
import android.widget.Toast;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.atomic.AtomicBoolean;
import org.robolectric.RuntimeEnvironment;
import org.robolectric.Shadows;
import org.robolectric.annotation.Implementation;
import org.robolectric.annotation.Implements;
import org.robolectric.annotation.RealObject;
import org.robolectric.internal.Shadow;
import org.robolectric.manifest.AndroidManifest;
import org.robolectric.manifest.BroadcastReceiverData;
import org.robolectric.res.ResourceLoader;
import org.robolectric.shadows.Provider;
import org.robolectric.shadows.ShadowAlertDialog;
import org.robolectric.shadows.ShadowAssetManager;
import org.robolectric.shadows.ShadowBroadcastReceiver;
import org.robolectric.shadows.ShadowContextImpl;
import org.robolectric.shadows.ShadowContextWrapper;
import org.robolectric.shadows.ShadowDialog;
import org.robolectric.shadows.ShadowLooper;
import org.robolectric.shadows.ShadowPopupMenu;
import org.robolectric.util.Scheduler;

@Implements(value=Application.class)
public class ShadowApplication
extends ShadowContextWrapper {
    @RealObject
    private Application realApplication;
    private AndroidManifest appManifest;
    private ResourceLoader resourceLoader;
    private ContentResolver contentResolver;
    private List<Intent> startedActivities = new ArrayList<Intent>();
    private List<Intent> startedServices = new ArrayList<Intent>();
    private List<Intent> stoppedServies = new ArrayList<Intent>();
    private List<Intent> broadcastIntents = new ArrayList<Intent>();
    private List<ServiceConnection> boundServiceConnections = new ArrayList<ServiceConnection>();
    private List<ServiceConnection> unboundServiceConnections = new ArrayList<ServiceConnection>();
    private List<Wrapper> registeredReceivers = new ArrayList<Wrapper>();
    private Map<String, Intent> stickyIntents = new LinkedHashMap<String, Intent>();
    private Looper mainLooper = ShadowLooper.myLooper();
    private Handler mainHandler = new Handler(this.mainLooper);
    private Scheduler backgroundScheduler = new Scheduler();
    private Map<String, Map<String, Object>> sharedPreferenceMap = new HashMap<String, Map<String, Object>>();
    private ArrayList<Toast> shownToasts = new ArrayList();
    private PowerManager.WakeLock latestWakeLock;
    private ShadowAlertDialog latestAlertDialog;
    private ShadowDialog latestDialog;
    private ShadowPopupMenu latestPopupMenu;
    private Object bluetoothAdapter = Shadow.newInstanceOf((String)"android.bluetooth.BluetoothAdapter");
    private Resources resources;
    private AssetManager assetManager;
    private Set<String> grantedPermissions = new HashSet<String>();
    private Map<Intent, ServiceConnectionDataWrapper> serviceConnectionDataForIntent = new HashMap<Intent, ServiceConnectionDataWrapper>();
    private Map<ServiceConnection, ServiceConnectionDataWrapper> serviceConnectionDataForServiceConnection = new HashMap<ServiceConnection, ServiceConnectionDataWrapper>();
    private ServiceConnectionDataWrapper defaultServiceConnectionData = new ServiceConnectionDataWrapper(null, null);
    LayoutInflater layoutInflater;
    AppWidgetManager appWidgetManager;
    private List<String> unbindableActions = new ArrayList<String>();
    private boolean strictI18n = false;
    private boolean checkActivities;
    private PopupWindow latestPopupWindow;
    private ListPopupWindow latestListPopupWindow;
    private final Map<String, Object> singletons = new HashMap<String, Object>();

    public static ShadowApplication getInstance() {
        return RuntimeEnvironment.application == null ? null : Shadows.shadowOf(RuntimeEnvironment.application);
    }

    public static void runBackgroundTasks() {
        ShadowApplication.getInstance().getBackgroundThreadScheduler().advanceBy(0L);
    }

    public static void setDisplayMetricsDensity(float densityMultiplier) {
        Shadows.shadowOf(ShadowApplication.getInstance().getResources()).setDensity(densityMultiplier);
    }

    public static void setDefaultDisplay(Display display) {
        Shadows.shadowOf(ShadowApplication.getInstance().getResources()).setDisplay(display);
    }

    public void bind(AndroidManifest appManifest, ResourceLoader resourceLoader) {
        if (this.resourceLoader != null) {
            throw new RuntimeException("ResourceLoader already set!");
        }
        this.appManifest = appManifest;
        this.resourceLoader = resourceLoader;
        if (appManifest != null) {
            this.setPackageName(appManifest.getPackageName());
            this.registerBroadcastReceivers(appManifest);
        }
    }

    private void registerBroadcastReceivers(AndroidManifest androidManifest) {
        for (BroadcastReceiverData receiver : androidManifest.getBroadcastReceivers()) {
            IntentFilter filter = new IntentFilter();
            for (String action : receiver.getActions()) {
                filter.addAction(action);
            }
            String receiverClassName = ShadowApplication.replaceLastDotWith$IfInnerStaticClass(receiver.getClassName());
            this.registerReceiver((BroadcastReceiver)Shadow.newInstanceOf((String)receiverClassName), filter);
        }
    }

    private static String replaceLastDotWith$IfInnerStaticClass(String receiverClassName) {
        String staticInnerClassRegex;
        String[] splits = receiverClassName.split("\\.");
        if (splits[splits.length - 1].matches(staticInnerClassRegex = "[A-Z][a-zA-Z]*") && splits[splits.length - 2].matches(staticInnerClassRegex)) {
            int lastDotIndex = receiverClassName.lastIndexOf(".");
            StringBuilder buffer = new StringBuilder(receiverClassName);
            buffer.setCharAt(lastDotIndex, '$');
            return buffer.toString();
        }
        return receiverClassName;
    }

    public List<Toast> getShownToasts() {
        return this.shownToasts;
    }

    public Scheduler getForegroundThreadScheduler() {
        return Shadows.shadowOf(Looper.getMainLooper()).getScheduler();
    }

    public Scheduler getBackgroundThreadScheduler() {
        return this.backgroundScheduler;
    }

    @Override
    @Implementation
    public Context getApplicationContext() {
        return this.realApplication;
    }

    @Override
    @Implementation
    public AssetManager getAssets() {
        if (this.assetManager == null) {
            this.assetManager = ShadowAssetManager.bind((AssetManager)Shadow.newInstanceOf(AssetManager.class), this.appManifest, this.resourceLoader);
        }
        return this.assetManager;
    }

    @Override
    @Implementation
    public Resources getResources() {
        if (this.resources == null) {
            this.resources = new Resources(this.realApplication.getAssets(), null, new Configuration());
        }
        return this.resources;
    }

    public void resetResources() {
        this.resources = null;
    }

    @Override
    @Implementation
    public ContentResolver getContentResolver() {
        if (this.contentResolver == null) {
            this.contentResolver = new ContentResolver((Context)this.realApplication){

                protected IContentProvider acquireProvider(Context c, String name) {
                    return null;
                }

                public boolean releaseProvider(IContentProvider icp) {
                    return false;
                }

                protected IContentProvider acquireUnstableProvider(Context c, String name) {
                    return null;
                }

                public boolean releaseUnstableProvider(IContentProvider icp) {
                    return false;
                }

                public void unstableProviderDied(IContentProvider icp) {
                }
            };
        }
        return this.contentResolver;
    }

    @Override
    @Implementation
    public void startActivity(Intent intent) {
        this.verifyActivityInManifest(intent);
        this.startedActivities.add(intent);
    }

    @Override
    @Implementation
    public void startActivity(Intent intent, Bundle options) {
        this.verifyActivityInManifest(intent);
        this.startedActivities.add(intent);
    }

    @Override
    @Implementation
    public ComponentName startService(Intent intent) {
        this.startedServices.add(intent);
        if (intent.getComponent() != null) {
            return intent.getComponent();
        }
        return new ComponentName("some.service.package", "SomeServiceName-FIXME");
    }

    @Override
    @Implementation
    public boolean stopService(Intent name) {
        this.stoppedServies.add(name);
        return this.startedServices.contains(name);
    }

    public void setComponentNameAndServiceForBindService(ComponentName name, IBinder service) {
        this.defaultServiceConnectionData = new ServiceConnectionDataWrapper(name, service);
    }

    public void setComponentNameAndServiceForBindServiceForIntent(Intent intent, ComponentName name, IBinder service) {
        this.serviceConnectionDataForIntent.put(intent, new ServiceConnectionDataWrapper(name, service));
    }

    @Override
    @Implementation
    public boolean bindService(final Intent intent, final ServiceConnection serviceConnection, int i) {
        this.boundServiceConnections.add(serviceConnection);
        this.unboundServiceConnections.remove(serviceConnection);
        if (this.unbindableActions.contains(intent.getAction())) {
            return false;
        }
        this.startedServices.add(intent);
        Shadows.shadowOf(Looper.getMainLooper()).post(new Runnable(){

            @Override
            public void run() {
                ServiceConnectionDataWrapper serviceConnectionDataWrapper = ShadowApplication.this.serviceConnectionDataForIntent.containsKey(intent) ? (ServiceConnectionDataWrapper)ShadowApplication.this.serviceConnectionDataForIntent.get(intent) : ShadowApplication.this.defaultServiceConnectionData;
                ShadowApplication.this.serviceConnectionDataForServiceConnection.put(serviceConnection, serviceConnectionDataWrapper);
                serviceConnection.onServiceConnected(serviceConnectionDataWrapper.componentNameForBindService, serviceConnectionDataWrapper.binderForBindService);
            }
        }, 0L);
        return true;
    }

    public List<ServiceConnection> getBoundServiceConnections() {
        return this.boundServiceConnections;
    }

    @Override
    @Implementation
    public void unbindService(final ServiceConnection serviceConnection) {
        this.unboundServiceConnections.add(serviceConnection);
        this.boundServiceConnections.remove(serviceConnection);
        Shadows.shadowOf(Looper.getMainLooper()).post(new Runnable(){

            @Override
            public void run() {
                ServiceConnectionDataWrapper serviceConnectionDataWrapper = ShadowApplication.this.serviceConnectionDataForServiceConnection.containsKey(serviceConnection) ? (ServiceConnectionDataWrapper)ShadowApplication.this.serviceConnectionDataForServiceConnection.get(serviceConnection) : ShadowApplication.this.defaultServiceConnectionData;
                serviceConnection.onServiceDisconnected(serviceConnectionDataWrapper.componentNameForBindService);
            }
        }, 0L);
    }

    public List<ServiceConnection> getUnboundServiceConnections() {
        return this.unboundServiceConnections;
    }

    @Override
    public Intent getNextStartedActivity() {
        if (this.startedActivities.isEmpty()) {
            return null;
        }
        return this.startedActivities.remove(0);
    }

    @Override
    public Intent peekNextStartedActivity() {
        if (this.startedActivities.isEmpty()) {
            return null;
        }
        return this.startedActivities.get(0);
    }

    @Override
    public Intent getNextStartedService() {
        if (this.startedServices.isEmpty()) {
            return null;
        }
        return this.startedServices.remove(0);
    }

    @Override
    public Intent peekNextStartedService() {
        if (this.startedServices.isEmpty()) {
            return null;
        }
        return this.startedServices.get(0);
    }

    @Override
    public void clearStartedServices() {
        this.startedServices.clear();
    }

    @Override
    public Intent getNextStoppedService() {
        if (this.stoppedServies.isEmpty()) {
            return null;
        }
        return this.stoppedServies.remove(0);
    }

    @Override
    public ResourceLoader getResourceLoader() {
        return this.resourceLoader;
    }

    @Override
    @Implementation
    public void sendBroadcast(Intent intent) {
        this.sendBroadcastWithPermission(intent, null);
    }

    @Override
    @Implementation
    public void sendBroadcast(Intent intent, String receiverPermission) {
        this.sendBroadcastWithPermission(intent, receiverPermission);
    }

    @Override
    @Implementation
    public void sendOrderedBroadcast(Intent intent, String receiverPermission) {
        this.sendOrderedBroadcastWithPermission(intent, receiverPermission);
    }

    private List<Wrapper> getAppropriateWrappers(Intent intent, String receiverPermission) {
        this.broadcastIntents.add(intent);
        ArrayList<Wrapper> result = new ArrayList<Wrapper>();
        ArrayList<Wrapper> copy = new ArrayList<Wrapper>();
        copy.addAll(this.registeredReceivers);
        for (Wrapper wrapper : copy) {
            int match;
            if (!this.hasMatchingPermission(wrapper.broadcastPermission, receiverPermission) || !wrapper.intentFilter.matchAction(intent.getAction()) || (match = wrapper.intentFilter.matchData(intent.getType(), intent.getScheme(), intent.getData())) == -2 || match == -1) continue;
            result.add(wrapper);
        }
        return result;
    }

    private void postIntent(Intent intent, Wrapper wrapper, final AtomicBoolean abort) {
        Handler scheduler = wrapper.scheduler != null ? wrapper.scheduler : this.mainHandler;
        BroadcastReceiver receiver = wrapper.broadcastReceiver;
        final ShadowBroadcastReceiver shReceiver = Shadows.shadowOf(receiver);
        final Intent broadcastIntent = intent;
        scheduler.post(new Runnable(){

            @Override
            public void run() {
                shReceiver.onReceive((Context)ShadowApplication.this.realApplication, broadcastIntent, abort);
            }
        });
    }

    private void postToWrappers(List<Wrapper> wrappers, Intent intent, String receiverPermission) {
        AtomicBoolean abort = new AtomicBoolean(false);
        for (Wrapper wrapper : wrappers) {
            this.postIntent(intent, wrapper, abort);
        }
    }

    private void sendBroadcastWithPermission(Intent intent, String receiverPermission) {
        List<Wrapper> wrappers = this.getAppropriateWrappers(intent, receiverPermission);
        this.postToWrappers(wrappers, intent, receiverPermission);
    }

    private void sendOrderedBroadcastWithPermission(Intent intent, String receiverPermission) {
        List<Wrapper> wrappers = this.getAppropriateWrappers(intent, receiverPermission);
        Collections.sort(wrappers, new Comparator<Wrapper>(){

            @Override
            public int compare(Wrapper o1, Wrapper o2) {
                return Integer.compare(o2.getIntentFilter().getPriority(), o1.getIntentFilter().getPriority());
            }
        });
        this.postToWrappers(wrappers, intent, receiverPermission);
    }

    @Override
    public List<Intent> getBroadcastIntents() {
        return this.broadcastIntents;
    }

    @Override
    @Implementation
    public void sendStickyBroadcast(Intent intent) {
        this.stickyIntents.put(intent.getAction(), intent);
        this.sendBroadcast(intent);
    }

    @Override
    @Implementation
    public Intent registerReceiver(BroadcastReceiver receiver, IntentFilter filter) {
        return this.registerReceiverWithContext(receiver, filter, null, null, (Context)this.realApplication);
    }

    @Override
    @Implementation
    public Intent registerReceiver(BroadcastReceiver receiver, IntentFilter filter, String broadcastPermission, Handler scheduler) {
        return this.registerReceiverWithContext(receiver, filter, broadcastPermission, scheduler, (Context)this.realApplication);
    }

    Intent registerReceiverWithContext(BroadcastReceiver receiver, IntentFilter filter, String broadcastPermission, Handler scheduler, Context context) {
        if (receiver != null) {
            this.registeredReceivers.add(new Wrapper(receiver, filter, context, broadcastPermission, scheduler));
        }
        return this.processStickyIntents(filter, receiver, context);
    }

    private void verifyActivityInManifest(Intent intent) {
        if (this.checkActivities && this.getPackageManager().resolveActivity(intent, -1) == null) {
            throw new ActivityNotFoundException(intent.getAction());
        }
    }

    private Intent processStickyIntents(IntentFilter filter, BroadcastReceiver receiver, Context context) {
        Intent result = null;
        for (Intent stickyIntent : this.stickyIntents.values()) {
            if (!filter.matchAction(stickyIntent.getAction())) continue;
            if (result == null) {
                result = stickyIntent;
            }
            if (receiver != null) {
                receiver.onReceive(context, stickyIntent);
                continue;
            }
            if (result == null) continue;
            break;
        }
        return result;
    }

    @Override
    @Implementation
    public void unregisterReceiver(BroadcastReceiver broadcastReceiver) {
        boolean found = false;
        Iterator<Wrapper> iterator = this.registeredReceivers.iterator();
        while (iterator.hasNext()) {
            Wrapper wrapper = iterator.next();
            if (wrapper.broadcastReceiver != broadcastReceiver) continue;
            iterator.remove();
            found = true;
        }
        if (!found) {
            throw new IllegalArgumentException("Receiver not registered: " + broadcastReceiver);
        }
    }

    public void assertNoBroadcastListenersRegistered(Context context, String type) {
        for (Wrapper registeredReceiver : this.registeredReceivers) {
            if (registeredReceiver.context != context) continue;
            IllegalStateException e = new IllegalStateException(type + " " + context + " leaked has leaked IntentReceiver " + registeredReceiver.broadcastReceiver + " that was originally registered here. " + "Are you missing a call to unregisterReceiver()?");
            e.setStackTrace(registeredReceiver.exception.getStackTrace());
            throw e;
        }
    }

    public void assertNoBroadcastListenersOfActionRegistered(Context context, String action) {
        for (Wrapper registeredReceiver : this.registeredReceivers) {
            if (registeredReceiver.context != context) continue;
            Iterator actions = registeredReceiver.intentFilter.actionsIterator();
            while (actions.hasNext()) {
                if (!((String)actions.next()).equals(action)) continue;
                IllegalStateException e = new IllegalStateException("Unexpected BroadcastReceiver on " + context + " with action " + action + " " + registeredReceiver.broadcastReceiver + " that was originally registered here:");
                e.setStackTrace(registeredReceiver.exception.getStackTrace());
                throw e;
            }
        }
    }

    public boolean hasReceiverForIntent(Intent intent) {
        for (Wrapper wrapper : this.registeredReceivers) {
            if (!wrapper.intentFilter.matchAction(intent.getAction())) continue;
            return true;
        }
        return false;
    }

    public List<BroadcastReceiver> getReceiversForIntent(Intent intent) {
        ArrayList<BroadcastReceiver> broadcastReceivers = new ArrayList<BroadcastReceiver>();
        for (Wrapper wrapper : this.registeredReceivers) {
            if (!wrapper.intentFilter.matchAction(intent.getAction())) continue;
            broadcastReceivers.add(wrapper.getBroadcastReceiver());
        }
        return broadcastReceivers;
    }

    public List<Wrapper> getRegisteredReceivers() {
        return this.registeredReceivers;
    }

    public LayoutInflater getLayoutInflater() {
        return this.layoutInflater;
    }

    public AppWidgetManager getAppWidgetManager() {
        return this.appWidgetManager;
    }

    @Override
    @Implementation
    public Looper getMainLooper() {
        return this.mainLooper;
    }

    public Map<String, Map<String, Object>> getSharedPreferenceMap() {
        return this.sharedPreferenceMap;
    }

    public ShadowAlertDialog getLatestAlertDialog() {
        return this.latestAlertDialog;
    }

    public void setLatestAlertDialog(ShadowAlertDialog latestAlertDialog) {
        this.latestAlertDialog = latestAlertDialog;
    }

    public ShadowDialog getLatestDialog() {
        return this.latestDialog;
    }

    public void setLatestDialog(ShadowDialog latestDialog) {
        this.latestDialog = latestDialog;
    }

    public Object getBluetoothAdapter() {
        return this.bluetoothAdapter;
    }

    public void declareActionUnbindable(String action) {
        this.unbindableActions.add(action);
    }

    @Deprecated
    public void setSystemService(String key, Object service) {
        ((ShadowContextImpl)Shadows.shadowOf(this.realApplication.getBaseContext())).setSystemService(key, service);
    }

    public PowerManager.WakeLock getLatestWakeLock() {
        return this.latestWakeLock;
    }

    public void addWakeLock(PowerManager.WakeLock wl) {
        this.latestWakeLock = wl;
    }

    public void clearWakeLocks() {
        this.latestWakeLock = null;
    }

    @Override
    public boolean isStrictI18n() {
        return this.strictI18n;
    }

    public void setStrictI18n(boolean strictI18n) {
        this.strictI18n = strictI18n;
    }

    public AndroidManifest getAppManifest() {
        return this.appManifest;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <T> T getSingleton(Class<T> clazz, Provider<T> provider) {
        Map<String, Object> map = this.singletons;
        synchronized (map) {
            Object item = this.singletons.get(clazz.getName());
            if (item == null) {
                item = provider.get();
                this.singletons.put(clazz.getName(), item);
            }
            return (T)item;
        }
    }

    public void checkActivities(boolean checkActivities) {
        this.checkActivities = checkActivities;
    }

    public ShadowPopupMenu getLatestPopupMenu() {
        return this.latestPopupMenu;
    }

    public void setLatestPopupMenu(ShadowPopupMenu latestPopupMenu) {
        this.latestPopupMenu = latestPopupMenu;
    }

    public PopupWindow getLatestPopupWindow() {
        return this.latestPopupWindow;
    }

    public void setLatestPopupWindow(PopupWindow latestPopupWindow) {
        this.latestPopupWindow = latestPopupWindow;
    }

    public ListPopupWindow getLatestListPopupWindow() {
        return this.latestListPopupWindow;
    }

    public void setLatestListPopupWindow(ListPopupWindow latestListPopupWindow) {
        this.latestListPopupWindow = latestListPopupWindow;
    }

    @Override
    @Implementation
    public int checkPermission(String permission, int pid, int uid) {
        return this.grantedPermissions.contains(permission) ? 0 : -1;
    }

    @Override
    public void grantPermissions(String ... permissionNames) {
        for (String permissionName : permissionNames) {
            this.grantedPermissions.add(permissionName);
        }
    }

    @Override
    public void denyPermissions(String ... permissionNames) {
        for (String permissionName : permissionNames) {
            this.grantedPermissions.remove(permissionName);
        }
    }

    private boolean hasMatchingPermission(String permission1, String permission2) {
        return permission1 == null ? permission2 == null : permission1.equals(permission2);
    }

    private static class ServiceConnectionDataWrapper {
        public final ComponentName componentNameForBindService;
        public final IBinder binderForBindService;

        private ServiceConnectionDataWrapper(ComponentName componentNameForBindService, IBinder binderForBindService) {
            this.componentNameForBindService = componentNameForBindService;
            this.binderForBindService = binderForBindService;
        }
    }

    public class Wrapper {
        public BroadcastReceiver broadcastReceiver;
        public IntentFilter intentFilter;
        public Context context;
        public Throwable exception;
        public String broadcastPermission;
        public Handler scheduler;

        public Wrapper(BroadcastReceiver broadcastReceiver, IntentFilter intentFilter, Context context, String broadcastPermission, Handler scheduler) {
            this.broadcastReceiver = broadcastReceiver;
            this.intentFilter = intentFilter;
            this.context = context;
            this.broadcastPermission = broadcastPermission;
            this.scheduler = scheduler;
            this.exception = new Throwable();
        }

        public BroadcastReceiver getBroadcastReceiver() {
            return this.broadcastReceiver;
        }

        public IntentFilter getIntentFilter() {
            return this.intentFilter;
        }

        public Context getContext() {
            return this.context;
        }
    }
}

