/*
 * Decompiled with CFR 0.152.
 */
package org.robolectric.shadows;

import android.graphics.Bitmap;
import android.graphics.Canvas;
import android.graphics.ColorFilter;
import android.graphics.Paint;
import android.graphics.drawable.BitmapDrawable;
import android.graphics.drawable.Drawable;
import org.robolectric.Shadows;
import org.robolectric.annotation.Implementation;
import org.robolectric.annotation.Implements;
import org.robolectric.annotation.RealObject;
import org.robolectric.internal.Shadow;
import org.robolectric.shadows.ShadowDrawable;
import org.robolectric.util.ReflectionHelpers;

@Implements(value=BitmapDrawable.class)
public class ShadowBitmapDrawable
extends ShadowDrawable {
    private ColorFilter colorFilter;
    String drawableCreateFromStreamSource;
    String drawableCreateFromPath;
    @RealObject
    private BitmapDrawable realBitmapDrawable;

    @Implementation
    public void draw(Canvas canvas) {
        Paint paint = new Paint();
        paint.setColorFilter(this.colorFilter);
        canvas.drawBitmap(this.realBitmapDrawable.getBitmap(), 0.0f, 0.0f, paint);
    }

    @Implementation
    public Drawable mutate() {
        Bitmap bitmap = this.realBitmapDrawable.getBitmap();
        BitmapDrawable real = (BitmapDrawable)ReflectionHelpers.callConstructor(BitmapDrawable.class, (ReflectionHelpers.ClassParameter[])new ReflectionHelpers.ClassParameter[]{ReflectionHelpers.ClassParameter.from(Bitmap.class, (Object)bitmap)});
        ShadowBitmapDrawable shadow = Shadows.shadowOf(real);
        shadow.colorFilter = this.colorFilter;
        shadow.drawableCreateFromStreamSource = this.drawableCreateFromStreamSource;
        return real;
    }

    @Implementation
    public void setColorFilter(ColorFilter colorFilter) {
        this.colorFilter = colorFilter;
        ((BitmapDrawable)Shadow.directlyOn((Object)this.realBitmapDrawable, BitmapDrawable.class)).setColorFilter(colorFilter);
    }

    @Override
    public int getCreatedFromResId() {
        return Shadows.shadowOf(this.realBitmapDrawable.getBitmap()).getCreatedFromResId();
    }

    public String getSource() {
        return this.drawableCreateFromStreamSource;
    }

    public String getPath() {
        return this.drawableCreateFromPath;
    }
}

