/*
 * Decompiled with CFR 0.152.
 */
package org.robolectric.shadows;

import android.content.Context;
import android.graphics.drawable.Drawable;
import android.view.MotionEvent;
import android.view.View;
import android.view.ViewGroup;
import android.view.WindowManager;
import android.widget.LinearLayout;
import android.widget.PopupWindow;
import org.robolectric.RuntimeEnvironment;
import org.robolectric.Shadows;
import org.robolectric.annotation.Implementation;
import org.robolectric.annotation.Implements;
import org.robolectric.annotation.RealObject;

@Implements(value=PopupWindow.class)
public class ShadowPopupWindow {
    @RealObject
    protected PopupWindow realPopupWindow;
    private View contentView;
    private int width;
    private int height;
    private boolean focusable;
    private boolean touchable;
    private boolean outSideTouchable;
    private boolean showing;
    private Drawable background;
    private View.OnTouchListener onTouchInterceptor;
    private Context context;
    private LinearLayout containerView;
    private int xOffset;
    private int yOffset;

    public void __constructor__(View contentView) {
        this.setContentView(contentView);
    }

    public void __constructor__(View contentView, int width, int height, boolean focusable) {
        this.__constructor__(contentView);
        this.width = width;
        this.height = height;
        this.focusable = focusable;
    }

    @Implementation
    public void setContentView(View contentView) {
        this.contentView = contentView;
        if (contentView != null) {
            this.context = contentView.getContext();
        }
    }

    @Implementation
    public View getContentView() {
        return this.contentView;
    }

    @Implementation
    public void setWidth(int width) {
        this.width = width;
    }

    @Implementation
    public int getWidth() {
        return this.width;
    }

    @Implementation
    public void setHeight(int height) {
        this.height = height;
    }

    @Implementation
    public int getHeight() {
        return this.height;
    }

    @Implementation
    public void setFocusable(boolean focusable) {
        this.focusable = focusable;
    }

    @Implementation
    public boolean isFocusable() {
        return this.focusable;
    }

    @Implementation
    public void setTouchable(boolean touchable) {
        this.touchable = touchable;
    }

    @Implementation
    public boolean isTouchable() {
        return this.touchable;
    }

    @Implementation
    public void setOutsideTouchable(boolean touchable) {
        this.outSideTouchable = touchable;
    }

    @Implementation
    public boolean isOutsideTouchable() {
        return this.outSideTouchable;
    }

    @Implementation
    public boolean isShowing() {
        return this.showing;
    }

    @Implementation
    public void dismiss() {
        if (this.context != null) {
            this.getWindowManager().removeView((View)this.containerView);
        }
        this.showing = false;
    }

    @Implementation
    public void setBackgroundDrawable(Drawable background) {
        this.background = background;
    }

    @Implementation
    public Drawable getBackground() {
        return this.background;
    }

    @Implementation
    public void setTouchInterceptor(View.OnTouchListener l) {
        this.onTouchInterceptor = l;
    }

    @Implementation
    public void showAsDropDown(View anchor) {
        this.containerView = new LinearLayout(this.context);
        this.containerView.addView(this.contentView);
        this.containerView.setBackgroundDrawable(this.background);
        this.getWindowManager().addView((View)this.containerView, (ViewGroup.LayoutParams)new WindowManager.LayoutParams());
        this.showing = true;
        Shadows.shadowOf(RuntimeEnvironment.application).setLatestPopupWindow(this.realPopupWindow);
    }

    @Implementation
    public void showAsDropDown(View anchor, int xoff, int yoff) {
        this.xOffset = xoff;
        this.yOffset = yoff;
        this.showAsDropDown(anchor);
    }

    @Implementation
    public void showAtLocation(View parent, int gravity, int x, int y) {
        this.showAsDropDown(parent);
    }

    public boolean dispatchTouchEvent(MotionEvent e) {
        return this.onTouchInterceptor != null && this.onTouchInterceptor.onTouch(this.realPopupWindow.getContentView(), e);
    }

    private WindowManager getWindowManager() {
        return (WindowManager)this.context.getSystemService("window");
    }

    public int getXOffset() {
        return this.xOffset;
    }

    public int getYOffset() {
        return this.yOffset;
    }

    public static PopupWindow getLatestPopupWindow() {
        return Shadows.shadowOf(RuntimeEnvironment.application).getLatestPopupWindow();
    }
}

