/*
 * Decompiled with CFR 0.152.
 */
package org.robolectric.shadows;

import android.media.AudioTrack;
import android.util.Log;
import androidx.annotation.NonNull;
import java.nio.Buffer;
import java.nio.ByteBuffer;
import org.robolectric.annotation.Implementation;
import org.robolectric.annotation.Implements;

@Implements(value=AudioTrack.class, looseSignatures=true)
public class ShadowAudioTrack {
    protected static final int DEFAULT_MIN_BUFFER_SIZE = 1024;
    private static final String TAG = "ShadowAudioTrack";
    private static int minBufferSize = 1024;

    public static void setMinBufferSize(int bufferSize) {
        minBufferSize = bufferSize;
    }

    @Implementation
    protected static int native_get_min_buff_size(int sampleRateInHz, int channelConfig, int audioFormat) {
        return minBufferSize;
    }

    @Implementation(minSdk=23)
    protected final int native_write_byte(byte[] audioData, int offsetInBytes, int sizeInBytes, int format, boolean isBlocking) {
        return sizeInBytes;
    }

    @Implementation(minSdk=21)
    protected int write(@NonNull ByteBuffer audioData, int sizeInBytes, int writeMode) {
        if (writeMode != 0 && writeMode != 1) {
            Log.e((String)TAG, (String)"ShadowAudioTrack.write() called with invalid blocking mode");
            return -2;
        }
        if (sizeInBytes < 0 || sizeInBytes > audioData.remaining()) {
            Log.e((String)TAG, (String)new StringBuilder(69).append("ShadowAudioTrack.write() called with invalid size (").append(sizeInBytes).append(") value").toString());
            return -2;
        }
        ((Buffer)audioData).position(audioData.position() + sizeInBytes);
        return sizeInBytes;
    }
}

