/*
 * Decompiled with CFR 0.152.
 */
package org.robolectric.shadows;

import android.content.res.AssetManager;
import android.content.res.Resources;
import android.graphics.Bitmap;
import android.graphics.BitmapFactory;
import android.graphics.Point;
import android.graphics.Rect;
import android.net.Uri;
import android.util.TypedValue;
import java.io.BufferedInputStream;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileDescriptor;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.URLConnection;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import org.robolectric.RuntimeEnvironment;
import org.robolectric.annotation.Implementation;
import org.robolectric.annotation.Implements;
import org.robolectric.annotation.Resetter;
import org.robolectric.shadow.api.Shadow;
import org.robolectric.shadows.ImageUtil;
import org.robolectric.shadows.ShadowAssetInputStream;
import org.robolectric.shadows.ShadowBitmap;
import org.robolectric.util.Join;
import org.robolectric.util.Logger;
import org.robolectric.util.NamedStream;
import org.robolectric.util.ReflectionHelpers;

@Implements(value=BitmapFactory.class)
public class ShadowBitmapFactory {
    private static Map<String, Point> widthAndHeightMap = new HashMap<String, Point>();

    @Implementation
    protected static Bitmap decodeResourceStream(Resources res, TypedValue value, InputStream is, Rect pad, BitmapFactory.Options opts) {
        Bitmap bitmap = (Bitmap)Shadow.directlyOn(BitmapFactory.class, (String)"decodeResourceStream", (ReflectionHelpers.ClassParameter[])new ReflectionHelpers.ClassParameter[]{ReflectionHelpers.ClassParameter.from(Resources.class, (Object)res), ReflectionHelpers.ClassParameter.from(TypedValue.class, (Object)value), ReflectionHelpers.ClassParameter.from(InputStream.class, (Object)is), ReflectionHelpers.ClassParameter.from(Rect.class, (Object)pad), ReflectionHelpers.ClassParameter.from(BitmapFactory.Options.class, (Object)opts)});
        if (value != null && value.string != null && value.string.toString().contains(".9.")) {
            ReflectionHelpers.callInstanceMethod((Object)bitmap, (String)"setNinePatchChunk", (ReflectionHelpers.ClassParameter[])new ReflectionHelpers.ClassParameter[]{ReflectionHelpers.ClassParameter.from(byte[].class, (Object)new byte[0])});
        }
        return bitmap;
    }

    @Implementation
    protected static Bitmap decodeResource(Resources res, int id2, BitmapFactory.Options options) {
        if (id2 == 0) {
            return null;
        }
        TypedValue value = new TypedValue();
        InputStream is = res.openRawResource(id2, value);
        Point imageSizeFromStream = ImageUtil.getImageSizeFromStream(is);
        String string = String.valueOf(res.getResourceName(id2));
        Bitmap bitmap = ShadowBitmapFactory.create(string.length() != 0 ? "resource:".concat(string) : new String("resource:"), options, imageSizeFromStream);
        ShadowBitmap shadowBitmap = (ShadowBitmap)Shadow.extract((Object)bitmap);
        shadowBitmap.createdFromResId = id2;
        return bitmap;
    }

    @Implementation
    protected static Bitmap decodeFile(String pathName) {
        return ShadowBitmapFactory.decodeFile(pathName, null);
    }

    @Implementation
    protected static Bitmap decodeFile(String pathName, BitmapFactory.Options options) {
        Point imageSizeFromStream = null;
        if (pathName != null && new File(pathName).exists()) {
            try (FileInputStream fileInputStream = new FileInputStream(pathName);
                 BufferedInputStream bufferedInputStream = new BufferedInputStream(fileInputStream);){
                imageSizeFromStream = ImageUtil.getImageSizeFromStream(bufferedInputStream);
            }
            catch (IOException e) {
                Logger.warn((String)"Error getting size of bitmap file", (Object[])new Object[]{e});
            }
        }
        String string = String.valueOf(pathName);
        Bitmap bitmap = ShadowBitmapFactory.create(string.length() != 0 ? "file:".concat(string) : new String("file:"), options, imageSizeFromStream);
        ShadowBitmap shadowBitmap = (ShadowBitmap)Shadow.extract((Object)bitmap);
        shadowBitmap.createdFromPath = pathName;
        return bitmap;
    }

    @Implementation
    protected static Bitmap decodeFileDescriptor(FileDescriptor fd, Rect outPadding, BitmapFactory.Options opts) {
        Object bufferedInputStream;
        Point imageSizeFromStream = null;
        if (fd != null && fd.valid()) {
            try (FileInputStream fileInputStream = new FileInputStream(fd);){
                bufferedInputStream = new BufferedInputStream(fileInputStream);
                try {
                    imageSizeFromStream = ImageUtil.getImageSizeFromStream((InputStream)bufferedInputStream);
                }
                finally {
                    ((BufferedInputStream)bufferedInputStream).close();
                }
            }
            catch (IOException e) {
                Logger.warn((String)"Error getting size of bitmap file", (Object[])new Object[]{e});
            }
        }
        bufferedInputStream = String.valueOf(fd);
        Bitmap bitmap = ShadowBitmapFactory.create(new StringBuilder(3 + String.valueOf(bufferedInputStream).length()).append("fd:").append((String)bufferedInputStream).toString(), opts, imageSizeFromStream);
        ShadowBitmap shadowBitmap = (ShadowBitmap)Shadow.extract((Object)bitmap);
        shadowBitmap.createdFromFileDescriptor = fd;
        return bitmap;
    }

    @Implementation
    protected static Bitmap decodeStream(InputStream is) {
        return ShadowBitmapFactory.decodeStream(is, null, null);
    }

    @Implementation
    protected static Bitmap decodeStream(InputStream is, Rect outPadding, BitmapFactory.Options opts) {
        byte[] ninePatchChunk = null;
        if (is instanceof AssetManager.AssetInputStream) {
            ShadowAssetInputStream sais = (ShadowAssetInputStream)Shadow.extract((Object)is);
            if (sais.isNinePatch()) {
                ninePatchChunk = new byte[]{};
            }
            if (sais.getDelegate() != null) {
                is = sais.getDelegate();
            }
        }
        try {
            if (is != null) {
                is.reset();
            }
        }
        catch (IOException sais) {
            // empty catch block
        }
        String name = is instanceof NamedStream ? is.toString().replace("stream for ", "") : null;
        Point imageSize = is instanceof NamedStream ? null : ImageUtil.getImageSizeFromStream(is);
        Bitmap bitmap = ShadowBitmapFactory.create(name, opts, imageSize);
        ReflectionHelpers.callInstanceMethod((Object)bitmap, (String)"setNinePatchChunk", (ReflectionHelpers.ClassParameter[])new ReflectionHelpers.ClassParameter[]{ReflectionHelpers.ClassParameter.from(byte[].class, (Object)ninePatchChunk)});
        ShadowBitmap shadowBitmap = (ShadowBitmap)Shadow.extract((Object)bitmap);
        shadowBitmap.createdFromStream = is;
        try {
            if (is != null && opts != null) {
                is.reset();
                opts.outMimeType = URLConnection.guessContentTypeFromStream(is);
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return bitmap;
    }

    @Implementation
    protected static Bitmap decodeByteArray(byte[] data, int offset, int length) {
        Bitmap bitmap = ShadowBitmapFactory.decodeByteArray(data, offset, length, new BitmapFactory.Options());
        ShadowBitmap shadowBitmap = (ShadowBitmap)Shadow.extract((Object)bitmap);
        shadowBitmap.createdFromBytes = data;
        return bitmap;
    }

    @Implementation
    protected static Bitmap decodeByteArray(byte[] data, int offset, int length, BitmapFactory.Options opts) {
        String desc = new String(data, StandardCharsets.UTF_8);
        if (offset != 0 || length != data.length) {
            String string = String.valueOf(desc);
            desc = new StringBuilder(31 + String.valueOf(string).length()).append(string).append(" bytes ").append(offset).append("..").append(length).toString();
        }
        Point imageSize = ImageUtil.getImageSizeFromStream(new ByteArrayInputStream(data, offset, length));
        return ShadowBitmapFactory.create(desc, opts, imageSize);
    }

    static Bitmap create(String name) {
        return ShadowBitmapFactory.create(name, null);
    }

    public static Bitmap create(String name, BitmapFactory.Options options) {
        return ShadowBitmapFactory.create(name, options, null);
    }

    public static Bitmap create(String name, BitmapFactory.Options options, Point widthAndHeight) {
        String string;
        Bitmap bitmap = (Bitmap)Shadow.newInstanceOf(Bitmap.class);
        ShadowBitmap shadowBitmap = (ShadowBitmap)Shadow.extract((Object)bitmap);
        if (name == null) {
            string = "Bitmap";
        } else {
            String string2 = String.valueOf(name);
            string = string2.length() != 0 ? "Bitmap for ".concat(string2) : new String("Bitmap for ");
        }
        shadowBitmap.appendDescription(string);
        Bitmap.Config config = options != null && options.inPreferredConfig != null ? options.inPreferredConfig : Bitmap.Config.ARGB_8888;
        shadowBitmap.setConfig(config);
        String optionsString = ShadowBitmapFactory.stringify(options);
        if (!optionsString.isEmpty()) {
            shadowBitmap.appendDescription(" with options ");
            shadowBitmap.appendDescription(optionsString);
        }
        Point p = new Point(ShadowBitmapFactory.selectWidthAndHeight(name, widthAndHeight));
        if (options != null && options.inSampleSize > 1) {
            p.x /= options.inSampleSize;
            p.y /= options.inSampleSize;
            p.x = p.x == 0 ? 1 : p.x;
            p.y = p.y == 0 ? 1 : p.y;
        }
        shadowBitmap.setWidth(p.x);
        shadowBitmap.setHeight(p.y);
        shadowBitmap.setPixels(new int[p.x * p.y], 0, 0, 0, 0, p.x, p.y);
        if (options != null) {
            options.outWidth = p.x;
            options.outHeight = p.y;
        }
        return bitmap;
    }

    public static void provideWidthAndHeightHints(Uri uri, int width, int height) {
        widthAndHeightMap.put(uri.toString(), new Point(width, height));
    }

    public static void provideWidthAndHeightHints(int resourceId, int width, int height) {
        String string = String.valueOf(RuntimeEnvironment.application.getResources().getResourceName(resourceId));
        widthAndHeightMap.put(string.length() != 0 ? "resource:".concat(string) : new String("resource:"), new Point(width, height));
    }

    public static void provideWidthAndHeightHints(String file, int width, int height) {
        String string = String.valueOf(file);
        widthAndHeightMap.put(string.length() != 0 ? "file:".concat(string) : new String("file:"), new Point(width, height));
    }

    public static void provideWidthAndHeightHints(FileDescriptor fd, int width, int height) {
        String string = String.valueOf(fd);
        widthAndHeightMap.put(new StringBuilder(3 + String.valueOf(string).length()).append("fd:").append(string).toString(), new Point(width, height));
    }

    private static String stringify(BitmapFactory.Options options) {
        if (options == null) {
            return "";
        }
        ArrayList<String> opts = new ArrayList<String>();
        if (options.inJustDecodeBounds) {
            opts.add("inJustDecodeBounds");
        }
        if (options.inSampleSize > 1) {
            int n = options.inSampleSize;
            opts.add(new StringBuilder(24).append("inSampleSize=").append(n).toString());
        }
        return Join.join((String)", ", opts);
    }

    @Resetter
    public static void reset() {
        widthAndHeightMap.clear();
    }

    private static Point selectWidthAndHeight(String name, Point widthAndHeight) {
        Point widthAndHeightFromMap = widthAndHeightMap.get(name);
        if (widthAndHeightFromMap != null) {
            return widthAndHeightFromMap;
        }
        if (widthAndHeight != null) {
            return widthAndHeight;
        }
        return new Point(100, 100);
    }
}

