/*
 * Decompiled with CFR 0.152.
 */
package org.robolectric.shadows;

import android.hardware.location.ContextHubClient;
import android.hardware.location.ContextHubInfo;
import android.hardware.location.ContextHubManager;
import java.util.ArrayList;
import java.util.List;
import org.robolectric.annotation.HiddenApi;
import org.robolectric.annotation.Implementation;
import org.robolectric.annotation.Implements;
import org.robolectric.util.ReflectionHelpers;

@Implements(value=ContextHubManager.class, minSdk=24, isInAndroidSdk=false, looseSignatures=true)
public class ShadowContextHubManager {
    private static final List<ContextHubInfo> contextHubInfoList = new ArrayList<ContextHubInfo>();

    @Implementation(minSdk=28)
    @HiddenApi
    protected List<ContextHubInfo> getContextHubs() {
        return contextHubInfoList;
    }

    @Implementation(minSdk=28)
    @HiddenApi
    protected Object createClient(Object contextHubInfo, Object contextHubClientCallback) {
        return ReflectionHelpers.newInstance(ContextHubClient.class);
    }

    @Implementation(minSdk=28)
    @HiddenApi
    protected Object createClient(Object contextHubInfo, Object contextHubClientCallback, Object executor) {
        return ReflectionHelpers.newInstance(ContextHubClient.class);
    }

    @Implementation
    @HiddenApi
    protected int[] getContextHubHandles() {
        int[] handles = new int[contextHubInfoList.size()];
        for (int i = 0; i < handles.length; ++i) {
            handles[i] = i;
        }
        return handles;
    }

    @Implementation
    @HiddenApi
    protected ContextHubInfo getContextHubInfo(int hubHandle) {
        if (hubHandle < 0 || hubHandle >= contextHubInfoList.size()) {
            return null;
        }
        return contextHubInfoList.get(hubHandle);
    }

    static {
        contextHubInfoList.add(new ContextHubInfo());
    }
}

