/*
 * Decompiled with CFR 0.152.
 */
package org.robolectric.shadows;

import android.annotation.SystemApi;
import android.content.ComponentName;
import android.content.Context;
import android.content.Intent;
import android.content.pm.ActivityInfo;
import android.content.pm.CrossProfileApps;
import android.content.pm.ICrossProfileApps;
import android.content.pm.PackageManager;
import android.graphics.drawable.ColorDrawable;
import android.graphics.drawable.Drawable;
import android.os.Process;
import android.os.UserHandle;
import android.text.TextUtils;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Iterables;
import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import javax.annotation.Nullable;
import org.robolectric.annotation.Implementation;
import org.robolectric.annotation.Implements;

@Implements(value=CrossProfileApps.class, minSdk=28)
public class ShadowCrossProfileApps {
    private final Set<UserHandle> targetUserProfiles = new LinkedHashSet<UserHandle>();
    private final List<StartedMainActivity> startedMainActivities = new ArrayList<StartedMainActivity>();
    private final List<StartedActivity> startedActivities = Collections.synchronizedList(new ArrayList());
    private Context context;
    private PackageManager packageManager;

    @Implementation
    protected void __constructor__(Context context, ICrossProfileApps service) {
        this.context = context;
        this.packageManager = context.getPackageManager();
    }

    @Implementation
    protected List<UserHandle> getTargetUserProfiles() {
        return ImmutableList.copyOf(this.targetUserProfiles);
    }

    @Implementation
    protected Drawable getProfileSwitchingIconDrawable(UserHandle userHandle) {
        this.verifyCanAccessUser(userHandle);
        return new ColorDrawable(userHandle.getIdentifier());
    }

    @Implementation
    protected CharSequence getProfileSwitchingLabel(UserHandle userHandle) {
        this.verifyCanAccessUser(userHandle);
        String string = String.valueOf(userHandle);
        return new StringBuilder(10 + String.valueOf(string).length()).append("Switch to ").append(string).toString();
    }

    @Implementation
    protected void startMainActivity(ComponentName componentName, UserHandle targetUser) {
        this.verifyCanAccessUser(targetUser);
        this.verifyActivityInManifest(componentName, true);
        this.startedMainActivities.add(new StartedMainActivity(componentName, targetUser));
        this.startedActivities.add(new StartedActivity(componentName, targetUser));
    }

    @Implementation(minSdk=29)
    @SystemApi
    protected void startActivity(ComponentName componentName, UserHandle targetUser) {
        this.verifyCanAccessUser(targetUser);
        this.verifyActivityInManifest(componentName, false);
        this.verifyHasInteractAcrossProfilesPermission();
        this.startedActivities.add(new StartedActivity(componentName, targetUser));
    }

    public void addTargetUserProfile(UserHandle userHandle) {
        if (userHandle.equals((Object)Process.myUserHandle())) {
            throw new IllegalArgumentException("Cannot target current user");
        }
        this.targetUserProfiles.add(userHandle);
    }

    public void removeTargetUserProfile(UserHandle userHandle) {
        if (userHandle.equals((Object)Process.myUserHandle())) {
            throw new IllegalArgumentException("Cannot target current user");
        }
        this.targetUserProfiles.remove(userHandle);
    }

    public void clearTargetUserProfiles() {
        this.targetUserProfiles.clear();
    }

    @Nullable
    @Deprecated
    public StartedMainActivity peekNextStartedMainActivity() {
        if (this.startedMainActivities.isEmpty()) {
            return null;
        }
        return (StartedMainActivity)Iterables.getLast(this.startedMainActivities);
    }

    @Nullable
    public StartedActivity peekNextStartedActivity() {
        if (this.startedActivities.isEmpty()) {
            return null;
        }
        return (StartedActivity)Iterables.getLast(this.startedActivities);
    }

    @Nullable
    public StartedActivity getNextStartedActivity() {
        if (this.startedActivities.isEmpty()) {
            return null;
        }
        return this.startedActivities.remove(this.startedActivities.size() - 1);
    }

    public void clearNextStartedActivities() {
        this.startedActivities.clear();
    }

    private void verifyCanAccessUser(UserHandle userHandle) {
        if (!this.targetUserProfiles.contains(userHandle)) {
            String string = String.valueOf(userHandle);
            throw new SecurityException(new StringBuilder(69 + String.valueOf(string).length()).append("Not allowed to access ").append(string).append(" (did you forget to call addTargetUserProfile?)").toString());
        }
    }

    protected void verifyHasInteractAcrossProfilesPermission() {
        if (this.context.checkSelfPermission("android.permission.INTERACT_ACROSS_PROFILES") != 0) {
            throw new SecurityException("Attempt to launch activity without required android.permission.INTERACT_ACROSS_PROFILES permission");
        }
    }

    private void verifyActivityInManifest(ComponentName component, boolean requireMainActivity) {
        Intent launchIntent = new Intent();
        if (requireMainActivity) {
            launchIntent.setAction("android.intent.action.MAIN").addCategory("android.intent.category.LAUNCHER").addFlags(0x10200000).setPackage(component.getPackageName());
        } else {
            launchIntent.setComponent(component);
        }
        boolean existsMatchingActivity = Iterables.any((Iterable)this.packageManager.queryIntentActivities(launchIntent, 786432), resolveInfo -> {
            ActivityInfo activityInfo = resolveInfo.activityInfo;
            return TextUtils.equals((CharSequence)activityInfo.packageName, (CharSequence)component.getPackageName()) && TextUtils.equals((CharSequence)activityInfo.name, (CharSequence)component.getClassName()) && activityInfo.exported;
        });
        if (!existsMatchingActivity) {
            String string = String.valueOf(component);
            throw new SecurityException(new StringBuilder(97 + String.valueOf(string).length()).append("Attempt to launch activity without  category Intent.CATEGORY_LAUNCHER or activity is not exported").append(string).toString());
        }
    }

    public static final class StartedActivity {
        private final ComponentName componentName;
        private final UserHandle userHandle;

        public StartedActivity(ComponentName componentName, UserHandle userHandle) {
            this.componentName = (ComponentName)Preconditions.checkNotNull((Object)componentName);
            this.userHandle = (UserHandle)Preconditions.checkNotNull((Object)userHandle);
        }

        public ComponentName getComponentName() {
            return this.componentName;
        }

        public UserHandle getUserHandle() {
            return this.userHandle;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            StartedActivity that = (StartedActivity)o;
            return Objects.equals(this.componentName, that.componentName) && Objects.equals(this.userHandle, that.userHandle);
        }

        public int hashCode() {
            return Objects.hash(this.componentName, this.userHandle);
        }
    }

    @Deprecated
    public static class StartedMainActivity {
        private final ComponentName componentName;
        private final UserHandle userHandle;

        public StartedMainActivity(ComponentName componentName, UserHandle userHandle) {
            this.componentName = (ComponentName)Preconditions.checkNotNull((Object)componentName);
            this.userHandle = (UserHandle)Preconditions.checkNotNull((Object)userHandle);
        }

        public ComponentName getComponentName() {
            return this.componentName;
        }

        public UserHandle getUserHandle() {
            return this.userHandle;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            StartedMainActivity that = (StartedMainActivity)o;
            return Objects.equals(this.componentName, that.componentName) && Objects.equals(this.userHandle, that.userHandle);
        }

        public int hashCode() {
            return Objects.hash(this.componentName, this.userHandle);
        }
    }
}

