/*
 * Decompiled with CFR 0.152.
 */
package org.robolectric.shadows;

import android.content.Context;
import android.content.Intent;
import android.content.pm.UserInfo;
import android.os.Bundle;
import android.os.IUserManager;
import android.os.Parcelable;
import android.os.Process;
import android.os.UserHandle;
import android.os.UserManager;
import com.google.common.base.Preconditions;
import com.google.common.collect.BiMap;
import com.google.common.collect.HashBiMap;
import com.google.common.collect.ImmutableList;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.robolectric.annotation.HiddenApi;
import org.robolectric.annotation.Implementation;
import org.robolectric.annotation.Implements;
import org.robolectric.annotation.RealObject;
import org.robolectric.annotation.Resetter;
import org.robolectric.shadow.api.Shadow;
import org.robolectric.shadows.ShadowProcess;
import org.robolectric.util.ReflectionHelpers;

@Implements(value=UserManager.class, minSdk=17)
public class ShadowUserManager {
    public static final int DEFAULT_SECONDARY_USER_ID = 10;
    public static final int FLAG_PRIMARY = 1;
    public static final int FLAG_ADMIN = 2;
    public static final int FLAG_GUEST = 4;
    public static final int FLAG_RESTRICTED = 8;
    public static final int FLAG_DEMO = 512;
    public static final int FLAG_MANAGED_PROFILE = 32;
    private static boolean isMultiUserSupported = false;
    protected static Map<Integer, Integer> userPidMap = new HashMap<Integer, Integer>();
    @RealObject
    private UserManager realObject;
    private boolean userUnlocked = true;
    private boolean managedProfile = false;
    private boolean isSystemUser = true;
    private Map<Integer, Bundle> userRestrictions = new HashMap<Integer, Bundle>();
    protected BiMap<Integer, Long> userSerialNumbers = HashBiMap.create();
    private Map<String, Bundle> applicationRestrictions = new HashMap<String, Bundle>();
    protected Map<Integer, UserState> userState = new HashMap<Integer, UserState>();
    protected Map<Integer, UserInfo> userInfoMap = new HashMap<Integer, UserInfo>();
    private final Map<Integer, Boolean> profileIsLocked = new HashMap<Integer, Boolean>();
    protected Map<Integer, List<UserHandle>> userProfilesListMap = new HashMap<Integer, List<UserHandle>>();
    private String seedAccountType;
    private Context context;
    private boolean enforcePermissions;
    private int userSwitchability = 0;

    @Implementation
    protected void __constructor__(Context context, IUserManager service) {
        this.context = context;
        Shadow.invokeConstructor(UserManager.class, (Object)this.realObject, (ReflectionHelpers.ClassParameter[])new ReflectionHelpers.ClassParameter[]{ReflectionHelpers.ClassParameter.from(Context.class, (Object)context), ReflectionHelpers.ClassParameter.from(IUserManager.class, (Object)service)});
        this.addUser(0, "system_user", 3);
    }

    @Implementation(minSdk=18)
    protected Bundle getApplicationRestrictions(String packageName) {
        Bundle bundle = this.applicationRestrictions.get(packageName);
        return bundle != null ? bundle : new Bundle();
    }

    public void setApplicationRestrictions(String packageName, Bundle restrictions) {
        this.applicationRestrictions.put(packageName, restrictions);
    }

    @Deprecated
    public long addUserProfile(UserHandle userHandle) {
        this.addProfile(UserHandle.myUserId(), userHandle.getIdentifier(), "", 0);
        return (Long)this.userSerialNumbers.get((Object)userHandle.getIdentifier());
    }

    @Implementation(minSdk=21)
    protected List<UserHandle> getUserProfiles() {
        return ImmutableList.copyOf((Collection)this.userProfilesListMap.get(UserHandle.myUserId()));
    }

    @Implementation(minSdk=21)
    protected List<UserInfo> getProfiles(int userHandle) {
        if (this.userProfilesListMap.containsKey(userHandle)) {
            ArrayList<UserInfo> infos = new ArrayList<UserInfo>();
            for (UserHandle profileHandle : this.userProfilesListMap.get(userHandle)) {
                infos.add(this.userInfoMap.get(profileHandle.getIdentifier()));
            }
            return infos;
        }
        return (List)Shadow.directlyOn((Object)this.realObject, UserManager.class, (String)"getProfiles", (ReflectionHelpers.ClassParameter[])new ReflectionHelpers.ClassParameter[]{ReflectionHelpers.ClassParameter.from(Integer.TYPE, (Object)userHandle)});
    }

    @Implementation(minSdk=21)
    protected UserInfo getProfileParent(int userId) {
        if (this.enforcePermissions && !this.hasManageUsersPermission()) {
            throw new SecurityException("Requires MANAGE_USERS permission");
        }
        UserInfo profile = this.getUserInfo(userId);
        if (profile == null) {
            return null;
        }
        int parentUserId = profile.profileGroupId;
        if (parentUserId == userId || parentUserId == -10000) {
            return null;
        }
        return this.getUserInfo(parentUserId);
    }

    public void addProfile(int userHandle, int profileUserHandle, String profileName, int profileFlags) {
        if (!this.userSerialNumbers.containsKey((Object)profileUserHandle)) {
            this.userSerialNumbers.put((Object)profileUserHandle, (Object)profileUserHandle);
        }
        this.userInfoMap.put(profileUserHandle, new UserInfo(profileUserHandle, profileName, profileFlags));
        this.userProfilesListMap.putIfAbsent(userHandle, new ArrayList());
        List<UserHandle> list = this.userProfilesListMap.get(userHandle);
        UserHandle handle = new UserHandle(profileUserHandle);
        if (!list.contains(handle)) {
            list.add(handle);
        }
    }

    public void setUserUnlocked(boolean userUnlocked) {
        this.userUnlocked = userUnlocked;
    }

    @Implementation(minSdk=24)
    protected boolean isUserUnlocked() {
        return this.userUnlocked;
    }

    @Implementation(minSdk=24)
    protected boolean isUserUnlocked(UserHandle handle) {
        this.checkPermissions();
        UserState state = this.userState.get(handle.getIdentifier());
        return state == UserState.STATE_RUNNING_UNLOCKED;
    }

    @Implementation(minSdk=21)
    protected boolean isManagedProfile() {
        if (this.enforcePermissions && !this.hasManageUsersPermission()) {
            throw new SecurityException("You need MANAGE_USERS permission to: check if specified user a managed profile outside your profile group");
        }
        return this.managedProfile;
    }

    @Implementation(minSdk=24)
    protected boolean isManagedProfile(int userHandle) {
        if (this.enforcePermissions && !this.hasManageUsersPermission()) {
            throw new SecurityException("You need MANAGE_USERS permission to: check if specified user a managed profile outside your profile group");
        }
        UserInfo info = this.getUserInfo(userHandle);
        return info != null && (info.flags & 0x20) == 32;
    }

    public void enforcePermissionChecks(boolean enforcePermissions) {
        this.enforcePermissions = enforcePermissions;
    }

    public void setManagedProfile(boolean managedProfile) {
        this.managedProfile = managedProfile;
    }

    @Implementation(minSdk=21)
    protected boolean hasUserRestriction(String restrictionKey, UserHandle userHandle) {
        Bundle bundle = this.userRestrictions.get(userHandle.getIdentifier());
        return bundle != null && bundle.getBoolean(restrictionKey);
    }

    public void setUserRestriction(UserHandle userHandle, String restrictionKey, boolean value) {
        Bundle bundle = this.getUserRestrictionsForUser(userHandle);
        bundle.putBoolean(restrictionKey, value);
    }

    public void clearUserRestrictions(UserHandle userHandle) {
        this.userRestrictions.remove(userHandle.getIdentifier());
    }

    @Implementation(minSdk=18)
    protected Bundle getUserRestrictions(UserHandle userHandle) {
        return new Bundle(this.getUserRestrictionsForUser(userHandle));
    }

    private Bundle getUserRestrictionsForUser(UserHandle userHandle) {
        Bundle bundle = this.userRestrictions.get(userHandle.getIdentifier());
        if (bundle == null) {
            bundle = new Bundle();
            this.userRestrictions.put(userHandle.getIdentifier(), bundle);
        }
        return bundle;
    }

    @Implementation
    protected long getSerialNumberForUser(UserHandle userHandle) {
        Long result = (Long)this.userSerialNumbers.get((Object)userHandle.getIdentifier());
        return result == null ? -1L : result;
    }

    public void setSerialNumberForUser(UserHandle userHandle, long serialNumber) {
        this.userSerialNumbers.put((Object)userHandle.getIdentifier(), (Object)serialNumber);
    }

    @Implementation
    protected UserHandle getUserForSerialNumber(long serialNumber) {
        Integer userHandle = (Integer)this.userSerialNumbers.inverse().get((Object)serialNumber);
        return userHandle == null ? null : new UserHandle(userHandle.intValue());
    }

    @Implementation
    protected int getUserSerialNumber(int userHandle) {
        Long result = (Long)this.userSerialNumbers.get((Object)userHandle);
        return result != null ? result.intValue() : -1;
    }

    @Implementation(minSdk=29)
    protected String getUserName() {
        UserInfo user = this.getUserInfo(UserHandle.myUserId());
        return user == null ? "" : user.name;
    }

    @HiddenApi
    @Implementation(minSdk=17)
    protected int getUserHandle(int serialNumber) {
        Integer userHandle = (Integer)this.userSerialNumbers.inverse().get((Object)serialNumber);
        return userHandle == null ? -1 : userHandle;
    }

    private boolean hasManageUsersPermission() {
        return this.context.getPackageManager().checkPermission("android.permission.MANAGE_USERS", this.context.getPackageName()) == 0;
    }

    private boolean hasModifyQuietModePermission() {
        return this.context.getPackageManager().checkPermission("android.permission.MODIFY_QUIET_MODE", this.context.getPackageName()) == 0;
    }

    private void checkPermissions() {
    }

    @Implementation(minSdk=25)
    protected boolean isDemoUser() {
        return this.getUserInfo(UserHandle.myUserId()).isDemo();
    }

    @Deprecated
    public void setIsDemoUser(boolean isDemoUser) {
        UserInfo userInfo = this.getUserInfo(UserHandle.myUserId());
        userInfo.flags = isDemoUser ? (userInfo.flags |= 0x200) : (userInfo.flags &= 0xFFFFFDFF);
    }

    @Implementation(minSdk=23)
    protected boolean isSystemUser() {
        if (!this.isSystemUser) {
            return false;
        }
        return (Boolean)Shadow.directlyOn((Object)this.realObject, UserManager.class, (String)"isSystemUser", (ReflectionHelpers.ClassParameter[])new ReflectionHelpers.ClassParameter[0]);
    }

    @Deprecated
    public void setIsSystemUser(boolean isSystemUser) {
        this.isSystemUser = isSystemUser;
    }

    @Deprecated
    public void setIsPrimaryUser(boolean isPrimaryUser) {
        UserInfo userInfo = this.getUserInfo(UserHandle.myUserId());
        userInfo.flags = isPrimaryUser ? (userInfo.flags |= 1) : (userInfo.flags &= 0xFFFFFFFE);
    }

    @Implementation(minSdk=18)
    protected boolean isLinkedUser() {
        return this.isRestrictedProfile();
    }

    @Deprecated
    public void setIsLinkedUser(boolean isLinkedUser) {
        this.setIsRestrictedProfile(isLinkedUser);
    }

    @Implementation(minSdk=28)
    protected boolean isRestrictedProfile() {
        return this.getUserInfo(UserHandle.myUserId()).isRestricted();
    }

    public void setIsRestrictedProfile(boolean isRestrictedProfile) {
        UserInfo userInfo = this.getUserInfo(UserHandle.myUserId());
        userInfo.flags = isRestrictedProfile ? (userInfo.flags |= 8) : (userInfo.flags &= 0xFFFFFFF7);
    }

    @Deprecated
    public void setIsGuestUser(boolean isGuestUser) {
        UserInfo userInfo = this.getUserInfo(UserHandle.myUserId());
        userInfo.flags = isGuestUser ? (userInfo.flags |= 4) : (userInfo.flags &= 0xFFFFFFFB);
    }

    @Implementation
    protected boolean isUserRunning(UserHandle handle) {
        this.checkPermissions();
        UserState state = this.userState.get(handle.getIdentifier());
        return state == UserState.STATE_RUNNING_LOCKED || state == UserState.STATE_RUNNING_UNLOCKED || state == UserState.STATE_RUNNING_UNLOCKING;
    }

    @Implementation
    protected boolean isUserRunningOrStopping(UserHandle handle) {
        this.checkPermissions();
        UserState state = this.userState.get(handle.getIdentifier());
        return state == UserState.STATE_RUNNING_LOCKED || state == UserState.STATE_RUNNING_UNLOCKED || state == UserState.STATE_RUNNING_UNLOCKING || state == UserState.STATE_STOPPING;
    }

    public void setUserState(UserHandle handle, UserState state) {
        this.userState.put(handle.getIdentifier(), state);
    }

    @Implementation(minSdk=26)
    protected boolean isQuietModeEnabled(UserHandle userHandle) {
        if (!this.isManagedProfileWithoutPermission(userHandle)) {
            return false;
        }
        UserInfo info = this.getUserInfo(userHandle.getIdentifier());
        return (info.flags & 0x80) == 128;
    }

    @Implementation(minSdk=29)
    protected boolean requestQuietModeEnabled(boolean enableQuietMode, UserHandle userHandle) {
        if (this.enforcePermissions && !this.hasManageUsersPermission() && !this.hasModifyQuietModePermission()) {
            throw new SecurityException("Requires MANAGE_USERS or MODIFY_QUIET_MODE permission");
        }
        Preconditions.checkArgument((boolean)this.isManagedProfileWithoutPermission(userHandle));
        int userProfileHandle = userHandle.getIdentifier();
        UserInfo info = this.getUserInfo(userHandle.getIdentifier());
        if (enableQuietMode) {
            this.userState.put(userProfileHandle, UserState.STATE_SHUTDOWN);
            info.flags |= 0x80;
        } else {
            if (this.profileIsLocked.getOrDefault(userProfileHandle, false).booleanValue()) {
                return false;
            }
            this.userState.put(userProfileHandle, UserState.STATE_RUNNING_UNLOCKED);
            info.flags &= 0xFFFFFF7F;
        }
        this.sendQuietModeBroadcast(enableQuietMode ? "android.intent.action.MANAGED_PROFILE_UNAVAILABLE" : "android.intent.action.MANAGED_PROFILE_AVAILABLE", userHandle);
        return true;
    }

    protected void sendQuietModeBroadcast(String action, UserHandle profileHandle) {
        Intent intent = new Intent(action);
        intent.putExtra("android.intent.extra.USER", (Parcelable)profileHandle);
        intent.setFlags(0x50000000);
        this.context.sendBroadcast(intent);
    }

    private boolean isManagedProfileWithoutPermission(UserHandle userHandle) {
        UserInfo info = this.getUserInfo(userHandle.getIdentifier());
        return info != null && (info.flags & 0x20) == 32;
    }

    public void setProfileIsLocked(UserHandle profileHandle, boolean isLocked) {
        this.profileIsLocked.put(profileHandle.getIdentifier(), isLocked);
    }

    @Implementation
    protected List<UserInfo> getUsers() {
        return new ArrayList<UserInfo>(this.userInfoMap.values());
    }

    @Implementation
    protected UserInfo getUserInfo(int userHandle) {
        return this.userInfoMap.get(userHandle);
    }

    @Deprecated
    public void setCanSwitchUser(boolean canSwitchUser) {
        this.setUserSwitchability(canSwitchUser ? 0 : 2);
    }

    @Implementation(minSdk=29)
    protected String getSeedAccountType() {
        return this.seedAccountType;
    }

    public void setSeedAccountType(String seedAccountType) {
        this.seedAccountType = seedAccountType;
    }

    @Implementation(minSdk=17)
    protected boolean removeUser(int userHandle) {
        this.userInfoMap.remove(userHandle);
        this.userProfilesListMap.remove(userHandle);
        UserHandle profielHandle = new UserHandle(userHandle);
        for (List<UserHandle> list : this.userProfilesListMap.values()) {
            if (list.remove(profielHandle)) break;
        }
        return true;
    }

    @Implementation(minSdk=29)
    protected boolean removeUser(UserHandle user) {
        return this.removeUser(user.getIdentifier());
    }

    @Implementation(minSdk=24)
    protected static boolean supportsMultipleUsers() {
        return isMultiUserSupported;
    }

    public void setSupportsMultipleUsers(boolean isMultiUserSupported) {
        ShadowUserManager.isMultiUserSupported = isMultiUserSupported;
    }

    public void switchUser(int userId) {
        if (!this.userInfoMap.containsKey(userId)) {
            throw new UnsupportedOperationException("Must add user before switching to it");
        }
        ShadowProcess.setUid(userPidMap.get(userId));
    }

    public UserHandle addUser(int id2, String name, int flags) {
        UserHandle userHandle;
        UserHandle userHandle2 = userHandle = id2 == 0 ? Process.myUserHandle() : new UserHandle(id2);
        if (!this.userSerialNumbers.containsKey((Object)id2)) {
            this.userSerialNumbers.put((Object)id2, (Object)id2);
        }
        this.userState.put(id2, UserState.STATE_SHUTDOWN);
        this.userInfoMap.put(id2, new UserInfo(id2, name, flags));
        if (!this.userProfilesListMap.containsKey(id2)) {
            this.userProfilesListMap.put(id2, new ArrayList());
            this.userProfilesListMap.get(id2).add(new UserHandle(id2));
            userPidMap.put(id2, id2 == 0 ? Process.myUid() : id2 * 100000 + ShadowProcess.getRandomApplicationUid());
        }
        return userHandle;
    }

    @Implementation(minSdk=24, maxSdk=29)
    protected boolean canSwitchUsers() {
        return this.getUserSwitchability() == 0;
    }

    @Implementation(minSdk=29)
    protected int getUserSwitchability() {
        return this.userSwitchability;
    }

    public void setUserSwitchability(int switchability) {
        this.userSwitchability = switchability;
    }

    @Resetter
    public static void reset() {
        if (userPidMap != null && !userPidMap.isEmpty()) {
            ShadowProcess.setUid(userPidMap.get(0));
            userPidMap.clear();
            userPidMap.put(0, Process.myUid());
        }
    }

    public static enum UserState {
        STATE_BOOTING,
        STATE_RUNNING_LOCKED,
        STATE_RUNNING_UNLOCKING,
        STATE_RUNNING_UNLOCKED,
        STATE_STOPPING,
        STATE_SHUTDOWN;

    }
}

