/*
 * Decompiled with CFR 0.152.
 */
package jcifs.smb;

import java.io.IOException;
import java.io.InputStream;
import jcifs.smb.ServerMessageBlock;
import jcifs.util.Hexdump;

abstract class AndXServerMessageBlock
extends ServerMessageBlock {
    private static final int ANDX_COMMAND_OFFSET = 1;
    private static final int ANDX_RESERVED_OFFSET = 2;
    private static final int ANDX_OFFSET_OFFSET = 3;
    private byte andxCommand = (byte)-1;
    private int andxOffset = 0;
    ServerMessageBlock andx = null;

    AndXServerMessageBlock() {
    }

    AndXServerMessageBlock(ServerMessageBlock andx) {
        this.andx = andx;
        if (andx != null) {
            this.andxCommand = andx.command;
        }
    }

    abstract int readBytesDirectWireFormat(InputStream var1, int var2, byte[] var3, int var4) throws IOException;

    int getBatchLimit(byte command) {
        return 0;
    }

    int writeWireFormat(byte[] dst, int dstIndex) {
        int start = this.headerStart = dstIndex;
        dstIndex += this.writeHeaderWireFormat(dst, dstIndex);
        dstIndex += this.writeAndXWireFormat(dst, dstIndex);
        this.length = dstIndex - start;
        if (this.digest != null) {
            this.digest.sign(dst, this.headerStart, this.length, this, this.response);
        }
        return this.length;
    }

    int readWireFormat(InputStream in, byte[] buffer, int bufferIndex) throws IOException {
        int start = bufferIndex;
        if (in.read(buffer, bufferIndex, 32) != 32) {
            throw new IOException("unexpected EOF reading smb header");
        }
        bufferIndex += this.readHeaderWireFormat(buffer, bufferIndex);
        bufferIndex += this.readAndXWireFormat(in, buffer, bufferIndex);
        this.length = bufferIndex - start;
        return this.length;
    }

    int writeAndXWireFormat(byte[] dst, int dstIndex) {
        int start = dstIndex;
        this.wordCount = this.writeParameterWordsWireFormat(dst, start + 3 + 2);
        this.wordCount += 4;
        this.wordCount /= 2;
        dst[start] = (byte)(this.wordCount & 0xFF);
        this.byteCount = this.writeBytesWireFormat(dst, (dstIndex += this.wordCount + 1) + 2);
        dst[dstIndex++] = (byte)(this.byteCount & 0xFF);
        dst[dstIndex++] = (byte)(this.byteCount >> 8 & 0xFF);
        dstIndex += this.byteCount;
        if (this.andx == null || !USE_BATCHING || this.batchLevel >= this.getBatchLimit(this.andx.command)) {
            this.andxCommand = (byte)-1;
            this.andx = null;
            dst[start + 1] = -1;
            dst[start + 2] = 0;
            dst[start + 3] = 0;
            dst[start + 3 + 1] = 0;
            return dstIndex - start;
        }
        this.andx.batchLevel = this.batchLevel + 1;
        dst[start + 1] = this.andxCommand;
        dst[start + 2] = 0;
        this.andxOffset = dstIndex - this.headerStart;
        AndXServerMessageBlock.writeInt2(this.andxOffset, dst, start + 3);
        this.andx.useUnicode = this.useUnicode;
        if (this.andx instanceof AndXServerMessageBlock) {
            this.andx.uid = this.uid;
            dstIndex += ((AndXServerMessageBlock)this.andx).writeAndXWireFormat(dst, dstIndex);
        } else {
            int andxStart = dstIndex;
            this.andx.wordCount = this.andx.writeParameterWordsWireFormat(dst, dstIndex);
            this.andx.wordCount /= 2;
            dst[andxStart] = (byte)(this.andx.wordCount & 0xFF);
            this.andx.byteCount = this.andx.writeBytesWireFormat(dst, (dstIndex += this.andx.wordCount + 1) + 2);
            dst[dstIndex++] = (byte)(this.andx.byteCount & 0xFF);
            dst[dstIndex++] = (byte)(this.andx.byteCount >> 8 & 0xFF);
            dstIndex += this.andx.byteCount;
        }
        return dstIndex - start;
    }

    int readAndXWireFormat(InputStream in, byte[] buffer, int bufferIndex) throws IOException {
        int start = bufferIndex;
        this.wordCount = in.read();
        if (this.wordCount == -1) {
            throw new IOException("unexpected EOF reading smb wordCount");
        }
        buffer[bufferIndex++] = (byte)(this.wordCount & 0xFF);
        if (this.wordCount != 0) {
            if (in.read(buffer, bufferIndex, this.wordCount * 2) != this.wordCount * 2) {
                throw new IOException("unexpected EOF reading andx parameter words");
            }
            this.andxCommand = buffer[bufferIndex];
            this.andxOffset = AndXServerMessageBlock.readInt2(buffer, bufferIndex += 2);
            bufferIndex += 2;
            if (this.andxOffset == 0) {
                this.andxCommand = (byte)-1;
            }
            if (this.wordCount > 2) {
                bufferIndex += this.readParameterWordsWireFormat(buffer, bufferIndex);
            }
        }
        if (in.read(buffer, bufferIndex, 2) != 2) {
            throw new IOException("unexpected EOF reading smb byteCount");
        }
        this.byteCount = AndXServerMessageBlock.readInt2(buffer, bufferIndex);
        bufferIndex += 2;
        if (this.byteCount != 0) {
            int n = this.readBytesDirectWireFormat(in, this.byteCount, buffer, bufferIndex);
            if (n == 0) {
                if (in.read(buffer, bufferIndex, this.byteCount) != this.byteCount) {
                    throw new IOException("unexpected EOF reading andx bytes");
                }
                n = this.readBytesWireFormat(buffer, bufferIndex);
            }
            bufferIndex += this.byteCount;
        }
        if (this.errorCode != 0 || this.andxCommand == -1) {
            this.andxCommand = (byte)-1;
            this.andx = null;
        } else {
            if (this.andx == null) {
                this.andxCommand = (byte)-1;
                throw new IOException("no andx command supplied with response");
            }
            bufferIndex += in.read(buffer, bufferIndex, this.andxOffset - (bufferIndex - this.headerStart));
            this.andx.headerStart = this.headerStart;
            this.andx.command = this.andxCommand;
            this.andx.errorCode = this.errorCode;
            this.andx.flags = this.flags;
            this.andx.flags2 = this.flags2;
            this.andx.tid = this.tid;
            this.andx.pid = this.pid;
            this.andx.uid = this.uid;
            this.andx.mid = this.mid;
            this.andx.useUnicode = this.useUnicode;
            if (this.andx instanceof AndXServerMessageBlock) {
                bufferIndex += ((AndXServerMessageBlock)this.andx).readAndXWireFormat(in, buffer, this.andxOffset - this.headerStart);
            } else {
                this.andx.wordCount = in.read();
                if (this.andx.wordCount == -1) {
                    throw new IOException("unexpected EOF reading smb wordCount");
                }
                buffer[bufferIndex++] = (byte)(this.andx.wordCount & 0xFF);
                if (this.andx.wordCount != 0) {
                    if (in.read(buffer, bufferIndex, this.andx.wordCount * 2) != this.andx.wordCount * 2) {
                        throw new IOException("unexpected EOF reading andx parameter words");
                    }
                    if (this.andx.wordCount > 2) {
                        bufferIndex += this.andx.readParameterWordsWireFormat(buffer, bufferIndex);
                    }
                }
                if (in.read(buffer, bufferIndex, 2) != 2) {
                    throw new IOException("unexpected EOF reading smb byteCount");
                }
                this.andx.byteCount = AndXServerMessageBlock.readInt2(buffer, bufferIndex);
                bufferIndex += 2;
                if (this.andx.byteCount != 0) {
                    if (in.read(buffer, bufferIndex, this.andx.byteCount) != this.andx.byteCount) {
                        throw new IOException("unexpected EOF reading andx bytes");
                    }
                    this.andx.readBytesWireFormat(buffer, bufferIndex);
                    bufferIndex += this.andx.byteCount;
                }
            }
            this.andx.received = true;
        }
        return bufferIndex - start;
    }

    public String toString() {
        return new String(super.toString() + ",andxCommand=0x" + Hexdump.toHexString(this.andxCommand, 2) + ",andxOffset=" + this.andxOffset);
    }
}

