/*
 * Decompiled with CFR 0.152.
 */
package jcifs.smb;

import java.io.UnsupportedEncodingException;
import java.util.Date;
import jcifs.smb.ServerMessageBlock;
import jcifs.util.Hexdump;
import jcifs.util.LogStream;

class SmbComNegotiateResponse
extends ServerMessageBlock {
    int dialectIndex;
    int securityMode;
    int security;
    int maxMpxCount;
    int maxNumberVcs;
    int maxBufferSize;
    int maxRawSize;
    int sessionKey;
    int capabilities;
    int serverTimeZone;
    int encryptionKeyLength;
    boolean encryptedPasswords;
    boolean signaturesEnabled;
    boolean signaturesRequired;
    long serverTime;
    byte[] encryptionKey;
    String oemDomainName;

    SmbComNegotiateResponse() {
    }

    int writeParameterWordsWireFormat(byte[] dst, int dstIndex) {
        return 0;
    }

    int writeBytesWireFormat(byte[] dst, int dstIndex) {
        return 0;
    }

    int readParameterWordsWireFormat(byte[] buffer, int bufferIndex) {
        int start = bufferIndex;
        this.dialectIndex = SmbComNegotiateResponse.readInt2(buffer, bufferIndex);
        bufferIndex += 2;
        if (this.dialectIndex > 10) {
            return bufferIndex - start;
        }
        this.securityMode = buffer[bufferIndex++] & 0xFF;
        this.security = this.securityMode & 1;
        this.encryptedPasswords = (this.securityMode & 2) == 2;
        this.signaturesEnabled = (this.securityMode & 4) == 4;
        this.signaturesRequired = (this.securityMode & 8) == 8;
        this.maxMpxCount = SmbComNegotiateResponse.readInt2(buffer, bufferIndex);
        this.maxNumberVcs = SmbComNegotiateResponse.readInt2(buffer, bufferIndex += 2);
        this.maxBufferSize = SmbComNegotiateResponse.readInt4(buffer, bufferIndex += 2);
        this.maxRawSize = SmbComNegotiateResponse.readInt4(buffer, bufferIndex += 4);
        this.sessionKey = SmbComNegotiateResponse.readInt4(buffer, bufferIndex += 4);
        this.capabilities = SmbComNegotiateResponse.readInt4(buffer, bufferIndex += 4);
        this.serverTime = SmbComNegotiateResponse.readTime(buffer, bufferIndex += 4);
        this.serverTimeZone = SmbComNegotiateResponse.readInt2(buffer, bufferIndex += 8);
        bufferIndex += 2;
        this.encryptionKeyLength = buffer[bufferIndex++] & 0xFF;
        return bufferIndex - start;
    }

    int readBytesWireFormat(byte[] buffer, int bufferIndex) {
        int start = bufferIndex;
        this.encryptionKey = new byte[this.encryptionKeyLength];
        System.arraycopy(buffer, bufferIndex, this.encryptionKey, 0, this.encryptionKeyLength);
        bufferIndex += this.encryptionKeyLength;
        if (this.byteCount > this.encryptionKeyLength) {
            int len;
            block10: {
                len = 0;
                if ((this.flags2 & 0x8000) == 32768) {
                    while (buffer[bufferIndex + len] != 0 || buffer[bufferIndex + len + 1] != 0) {
                        if ((len += 2) <= 256) continue;
                        throw new RuntimeException("zero termination not found");
                    }
                    try {
                        this.oemDomainName = new String(buffer, bufferIndex, len, "UnicodeLittle");
                    }
                    catch (UnsupportedEncodingException uee) {
                        if (LogStream.level > 1) {
                            uee.printStackTrace(log);
                        }
                        break block10;
                    }
                }
                while (buffer[bufferIndex + len] != 0) {
                    if (++len <= 256) continue;
                    throw new RuntimeException("zero termination not found");
                }
                try {
                    this.oemDomainName = new String(buffer, bufferIndex, len, ServerMessageBlock.OEM_ENCODING);
                }
                catch (UnsupportedEncodingException uee) {
                    // empty catch block
                }
            }
            bufferIndex += len;
        } else {
            this.oemDomainName = new String();
        }
        return bufferIndex - start;
    }

    public String toString() {
        return new String("SmbComNegotiateResponse[" + super.toString() + ",wordCount=" + this.wordCount + ",dialectIndex=" + this.dialectIndex + ",securityMode=0x" + Hexdump.toHexString(this.securityMode, 1) + ",security=" + (this.security == 0 ? "share" : "user") + ",encryptedPasswords=" + this.encryptedPasswords + ",maxMpxCount=" + this.maxMpxCount + ",maxNumberVcs=" + this.maxNumberVcs + ",maxBufferSize=" + this.maxBufferSize + ",maxRawSize=" + this.maxRawSize + ",sessionKey=0x" + Hexdump.toHexString(this.sessionKey, 8) + ",capabilities=0x" + Hexdump.toHexString(this.capabilities, 8) + ",serverTime=" + new Date(this.serverTime) + ",serverTimeZone=" + this.serverTimeZone + ",encryptionKeyLength=" + this.encryptionKeyLength + ",byteCount=" + this.byteCount + ",encryptionKey=0x" + Hexdump.toHexString(this.encryptionKey, 0, this.encryptionKeyLength * 2) + ",oemDomainName=" + this.oemDomainName + "]");
    }
}

