/*
 * Decompiled with CFR 0.152.
 */
package org.savara.protocol.model.change;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Vector;
import org.savara.common.logging.FeedbackHandler;
import org.savara.contract.model.Contract;
import org.savara.protocol.model.change.ModelChangeContext;
import org.savara.protocol.util.JournalProxy;
import org.scribble.common.logging.Journal;
import org.scribble.protocol.model.AbstractModelObjectVisitor;
import org.scribble.protocol.model.ModelObject;
import org.scribble.protocol.model.Parameter;
import org.scribble.protocol.model.ParameterDefinition;
import org.scribble.protocol.model.Protocol;
import org.scribble.protocol.model.ProtocolImport;
import org.scribble.protocol.model.ProtocolModel;
import org.scribble.protocol.model.ProtocolReference;
import org.scribble.protocol.model.Role;
import org.scribble.protocol.model.RoleList;
import org.scribble.protocol.model.Run;
import org.scribble.protocol.model.Visitor;
import org.scribble.protocol.util.ProtocolModelUtil;
import org.scribble.protocol.util.RunUtil;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ModelChangeUtils {
    public static void addContract(ModelChangeContext context, Role role, Contract contract) {
        HashMap<String, Contract> contracts = (HashMap<String, Contract>)context.getProperties().get(Contract.class.getName());
        if (contracts == null) {
            contracts = new HashMap<String, Contract>();
            context.getProperties().put(Contract.class.getName(), contracts);
        }
        if (role != null && contract != null) {
            ModelChangeUtils.addRoleContract(role, contract, contracts);
        }
    }

    protected static List<Role> getRoles(final Protocol conv) {
        final Vector<Role> roles = new Vector<Role>();
        conv.visit((Visitor)new AbstractModelObjectVisitor(){

            public boolean process(ModelObject obj) {
                boolean ret = true;
                if (obj instanceof RoleList) {
                    roles.addAll(((RoleList)obj).getRoles());
                } else if (obj instanceof Protocol && obj != conv) {
                    ret = false;
                }
                return ret;
            }
        });
        return roles;
    }

    protected static void addRoleContract(Role role, Contract contract, Map<String, Contract> contracts) {
        if (role != null && contract != null) {
            contracts.put(role.getName(), contract);
        }
    }

    protected static void removeRoleContract(Role role, Map<String, Contract> contracts) {
        if (role != null) {
            contracts.remove(role.getName());
        }
    }

    public static void removeContracts(ModelChangeContext context, Protocol conv, boolean root) {
        Map contracts = (Map)context.getProperties().get(Contract.class.getName());
        if (contracts != null) {
            if (conv.getRole() != null && root) {
                ModelChangeUtils.removeRoleContract(conv.getRole(), contracts);
            }
            List<Role> roles = ModelChangeUtils.getRoles(conv);
            for (Role r : roles) {
                ModelChangeUtils.removeRoleContract(r, contracts);
            }
        }
    }

    public static Contract getContract(ModelChangeContext context, Role role) {
        Contract ret = null;
        if (context.getProperties().containsKey(Contract.class.getName())) {
            Map contracts = (Map)context.getProperties().get(Contract.class.getName());
            ret = (Contract)contracts.get(role.getName());
        }
        return ret;
    }

    public static void pushRoleContractMapping(ModelChangeContext context, Run run, FeedbackHandler journal) {
        if (context.getProperties().containsKey(Contract.class.getName())) {
            Contract c;
            Map contracts = (Map)context.getProperties().get(Contract.class.getName());
            Protocol defn = RunUtil.getInnerProtocol((Protocol)run.enclosingProtocol(), (ProtocolReference)run.getProtocolReference());
            if (run.enclosingProtocol().getRole() != null && defn != null && defn.getRole() != null && (c = (Contract)contracts.remove(run.enclosingProtocol().getRole().getName())) != null) {
                contracts.put(defn.getRole().getName(), c);
            }
            if (defn == null) {
                ProtocolImport pi = ProtocolModelUtil.getProtocolImport((ProtocolModel)run.getModel(), (ProtocolReference)run.getProtocolReference());
                if (pi == null) {
                    journal.error("Referenced protocol '" + run.getProtocolReference().getName() + "' not found within model or in import statements", run.getProperties());
                } else {
                    ProtocolModel pm = context.getProtocolContext().getProtocolModel(pi, (Journal)new JournalProxy(journal));
                    if (pm != null) {
                        defn = pm.getProtocol();
                    } else {
                        journal.error("Referenced protocol '" + run.getProtocolReference().getName() + "' could not be loaded from location '" + pi.getLocation() + "'", run.getProperties());
                    }
                }
            }
            if (defn != null) {
                if (defn.getParameterDefinitions().size() == run.getParameters().size()) {
                    for (int i = 0; i < run.getParameters().size(); ++i) {
                        Parameter p = (Parameter)run.getParameters().get(i);
                        ParameterDefinition pd = (ParameterDefinition)defn.getParameterDefinitions().get(i);
                        Contract c2 = (Contract)contracts.remove(p.getName());
                        if (c2 == null) continue;
                        contracts.put(pd.getName(), c2);
                    }
                } else {
                    journal.error("Referenced protocol '" + run.getProtocolReference().getName() + "' is expecting a different number of parameters", run.getProperties());
                }
            }
        }
    }

    public static void popRoleContractMapping(ModelChangeContext context, Run run, FeedbackHandler journal) {
        if (context.getProperties().containsKey(Contract.class.getName())) {
            Contract c;
            Map contracts = (Map)context.getProperties().get(Contract.class.getName());
            Protocol defn = RunUtil.getInnerProtocol((Protocol)run.enclosingProtocol(), (ProtocolReference)run.getProtocolReference());
            if (run.enclosingProtocol().getRole() != null && defn != null && defn.getRole() != null && (c = (Contract)contracts.remove(defn.getRole().getName())) != null) {
                contracts.put(run.enclosingProtocol().getRole().getName(), c);
            }
            if (defn == null) {
                ProtocolImport pi = ProtocolModelUtil.getProtocolImport((ProtocolModel)run.getModel(), (ProtocolReference)run.getProtocolReference());
                if (pi == null) {
                    journal.error("Referenced protocol '" + run.getProtocolReference().getName() + "' not found within model or in import statements", run.getProperties());
                } else {
                    ProtocolModel pm = context.getProtocolContext().getProtocolModel(pi, (Journal)new JournalProxy(journal));
                    if (pm != null) {
                        defn = pm.getProtocol();
                    } else {
                        journal.error("Referenced protocol '" + run.getProtocolReference().getName() + "' could not be loaded from location '" + pi.getLocation() + "'", run.getProperties());
                    }
                }
            }
            if (defn != null) {
                if (defn.getParameterDefinitions().size() == run.getParameters().size()) {
                    for (int i = 0; i < run.getParameters().size(); ++i) {
                        Parameter p = (Parameter)run.getParameters().get(i);
                        ParameterDefinition pd = (ParameterDefinition)defn.getParameterDefinitions().get(i);
                        Contract c2 = (Contract)contracts.remove(pd.getName());
                        if (c2 == null) continue;
                        contracts.put(p.getName(), c2);
                    }
                } else {
                    journal.error("Referenced protocol '" + run.getProtocolReference().getName() + "' is expecting a different number of parameters", run.getProperties());
                }
            }
        }
    }
}

