/*
 * Decompiled with CFR 0.152.
 */
package org.savara.protocol.model.change;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.savara.common.logging.FeedbackHandler;
import org.savara.protocol.model.change.ModelChangeContext;
import org.savara.protocol.model.change.ModelChangeRule;
import org.scribble.protocol.ProtocolContext;
import org.scribble.protocol.model.ModelObject;
import org.scribble.protocol.model.ProtocolModel;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractModelChangeContext
implements ModelChangeContext {
    private Object m_parent = null;
    private ProtocolContext m_context = null;
    private FeedbackHandler m_feedbackHandler = null;
    private Map<String, Object> m_properties = new HashMap<String, Object>();

    public AbstractModelChangeContext(ProtocolContext context, FeedbackHandler journal) {
        this.m_context = context;
        this.m_feedbackHandler = journal;
    }

    @Override
    public ProtocolContext getProtocolContext() {
        return this.m_context;
    }

    @Override
    public FeedbackHandler getFeedbackHandler() {
        return this.m_feedbackHandler;
    }

    public abstract List<ModelChangeRule> getRules();

    @Override
    public Object getParent() {
        return this.m_parent;
    }

    @Override
    public void setParent(Object parent) {
        this.m_parent = parent;
    }

    @Override
    public boolean insert(ProtocolModel model, ModelObject mobj, ModelObject ref) {
        boolean ret = false;
        List<ModelChangeRule> rules = this.getRules();
        for (int i = 0; !ret && i < rules.size(); ++i) {
            if (!rules.get(i).isInsertSupported(this, model, mobj, ref)) continue;
            ret = rules.get(i).insert(this, model, mobj, ref);
        }
        return ret;
    }

    @Override
    public boolean delete(ProtocolModel model, ModelObject mobj) {
        boolean ret = false;
        List<ModelChangeRule> rules = this.getRules();
        for (int i = 0; !ret && i < rules.size(); ++i) {
            if (!rules.get(i).isDeleteSupported(this, model, mobj)) continue;
            ret = rules.get(i).delete(this, model, mobj);
        }
        return ret;
    }

    @Override
    public boolean update(ProtocolModel model, ModelObject fromObj, ModelObject toObj) {
        boolean ret = false;
        List<ModelChangeRule> rules = this.getRules();
        for (int i = 0; !ret && i < rules.size(); ++i) {
            if (!rules.get(i).isUpdateSupported(this, model, fromObj, toObj)) continue;
            ret = rules.get(i).update(this, model, fromObj, toObj);
        }
        return ret;
    }

    @Override
    public Map<String, Object> getProperties() {
        return this.m_properties;
    }
}

