/*
 * Decompiled with CFR 0.152.
 */
package org.savara.scenario.osgi;

import java.util.Dictionary;
import java.util.Properties;
import java.util.logging.Logger;
import org.osgi.framework.BundleActivator;
import org.osgi.framework.BundleContext;
import org.osgi.framework.ServiceReference;
import org.osgi.util.tracker.ServiceTracker;
import org.savara.scenario.simulation.DefaultScenarioSimulator;
import org.savara.scenario.simulation.RoleSimulator;
import org.savara.scenario.simulation.RoleSimulatorFactory;
import org.savara.scenario.simulation.ScenarioSimulator;

public class Activator
implements BundleActivator {
    private ServiceTracker m_roleSimulatorTracker = null;
    private static final Logger logger = Logger.getLogger(Activator.class.getName());

    public void start(BundleContext context) throws Exception {
        Properties props = new Properties();
        DefaultScenarioSimulator ssim = new DefaultScenarioSimulator();
        context.registerService(ScenarioSimulator.class.getName(), (Object)ssim, (Dictionary)props);
        logger.info("Registered Scenario Simulator");
        ServiceReference sref = context.getServiceReference(RoleSimulator.class.getName());
        if (sref != null) {
            RoleSimulator rs = (RoleSimulator)context.getService(sref);
            RoleSimulatorFactory.register(rs);
        } else {
            this.m_roleSimulatorTracker = new ServiceTracker(context, RoleSimulator.class.getName(), null){

                public Object addingService(ServiceReference ref) {
                    Object ret = super.addingService(ref);
                    logger.fine("Role simulator being registered: " + ret);
                    RoleSimulatorFactory.register((RoleSimulator)ret);
                    return ret;
                }
            };
            this.m_roleSimulatorTracker.open();
        }
    }

    public void stop(BundleContext context) throws Exception {
    }
}

