/*
 * Decompiled with CFR 0.152.
 */
package scala.actors.remote;

import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.EOFException;
import java.io.IOException;
import scala.ScalaObject;
import scala.ScalaObject$class;
import scala.actors.remote.Service;

public abstract class Serializer
implements ScalaObject {
    private Service service;

    public Serializer(Service service) {
        this.service = service;
    }

    public void writeObject(DataOutputStream outputStream, Object obj) throws IOException {
        byte[] bytes = this.serialize(obj);
        this.writeBytes(outputStream, bytes);
    }

    public void writeBytes(DataOutputStream outputStream, byte[] bytes) throws IOException {
        int length2 = bytes.length;
        outputStream.writeInt(length2);
        outputStream.write(bytes, 0, length2);
        outputStream.flush();
    }

    public Object readObject(DataInputStream inputStream) throws IOException, ClassNotFoundException {
        byte[] bytes = this.readBytes(inputStream);
        return this.deserialize(bytes);
    }

    public byte[] readBytes(DataInputStream inputStream) throws IOException {
        try {
            int length2 = inputStream.readInt();
            byte[] bytes = new byte[length2];
            inputStream.readFully(bytes, 0, length2);
            return bytes;
        }
        catch (NullPointerException nullPointerException) {
            throw new EOFException("Connection closed.");
        }
    }

    public abstract Object deserialize(byte[] var1);

    public abstract byte[] serialize(Object var1);

    public /* synthetic */ Service service() {
        return this.service;
    }

    public int $tag() {
        return ScalaObject$class.$tag(this);
    }
}

