/*
 * Decompiled with CFR 0.152.
 */
package sbt.io;

import java.io.File;
import java.io.Serializable;
import java.net.URL;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import sbt.io.DescendantOrSelfPathFinder$;
import sbt.io.FileFilter;
import sbt.io.IO$;
import sbt.io.Mapper;
import sbt.io.Path;
import sbt.nio.file.AnyPath$;
import sbt.nio.file.FileAttributes;
import sbt.nio.file.FileTreeView;
import sbt.nio.file.FileTreeView$;
import sbt.nio.file.FileTreeView$Ops$;
import sbt.nio.file.Glob$;
import sbt.nio.file.RelativeGlob;
import scala.Function0;
import scala.Function1;
import scala.Function2;
import scala.Function4;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.collection.Iterable;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.TraversableOnce;
import scala.collection.immutable.Vector;
import scala.collection.mutable.ArrayOps;
import scala.collection.mutable.Set;
import scala.package$;
import scala.reflect.ClassTag$;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;

public final class Path$
extends Mapper {
    public static Path$ MODULE$;
    private final char sep;
    private final Vector<LinkOption> defaultLinkOptions;
    private final Function4<File, FileFilter, Set<File>, Object, BoxedUnit> defaultDescendantHandler;
    private final Function2<File, FileFilter, Seq<File>> defaultChildHandler;

    static {
        new Path$();
    }

    public File apply(File f) {
        return f;
    }

    public File apply(String f) {
        return new File(f);
    }

    public File fileProperty(String name) {
        return new File(System.getProperty(name));
    }

    public File userHome() {
        return this.fileProperty("user.home");
    }

    public File absolute(File file) {
        return new File(file.toURI().normalize()).getAbsoluteFile();
    }

    public String makeString(Seq<File> paths) {
        return this.makeString(paths, File.pathSeparator);
    }

    public String makeString(Seq<File> paths, String sep) {
        Seq separated = (Seq)paths.map((Function1 & Serializable & scala.Serializable)x$1 -> x$1.getAbsolutePath(), Seq$.MODULE$.canBuildFrom());
        separated.find((Function1 & Serializable & scala.Serializable)x$2 -> BoxesRunTime.boxToBoolean((boolean)x$2.contains(sep))).foreach((Function1 & Serializable & scala.Serializable)p -> scala.sys.package$.MODULE$.error(new StringBuilder(29).append("Path '").append((String)p).append("' contains separator '").append(sep).append("'").toString()));
        return separated.mkString(sep);
    }

    public boolean newerThan(File a, File b) {
        return a.exists() && (!b.exists() || IO$.MODULE$.getModifiedTimeOrZero(a) > IO$.MODULE$.getModifiedTimeOrZero(b));
    }

    public char sep() {
        return this.sep;
    }

    public URL[] toURLs(Seq<File> files) {
        return (URL[])((TraversableOnce)files.map((Function1 & Serializable & scala.Serializable)x$3 -> x$3.toURI().toURL(), Seq$.MODULE$.canBuildFrom())).toArray(ClassTag$.MODULE$.apply(URL.class));
    }

    public Vector<LinkOption> defaultLinkOptions() {
        return this.defaultLinkOptions;
    }

    public Function4<File, FileFilter, Set<File>, Object, BoxedUnit> defaultDescendantHandler() {
        return this.defaultDescendantHandler;
    }

    public Function2<File, FileFilter, Seq<File>> defaultChildHandler() {
        return this.defaultChildHandler;
    }

    private Path$() {
        Function2 & Serializable & scala.Serializable intersect;
        MODULE$ = this;
        this.sep = File.separatorChar;
        this.defaultLinkOptions = package$.MODULE$.Vector().empty();
        Function4 & Serializable & scala.Serializable intersect2 = this.defaultDescendantHandler = "nio".equals(scala.sys.package$.MODULE$.props().getOrElse((Object)"sbt.pathfinder", (Function0 & Serializable & scala.Serializable)() -> "")) ? (Function4 & Serializable & scala.Serializable)(file, filter, fileSet, depth) -> {
            DescendantOrSelfPathFinder$.MODULE$.nio(file, filter, (Set<File>)fileSet, BoxesRunTime.unboxToInt((Object)depth));
            return BoxedUnit.UNIT;
        } : (Function4 & Serializable & scala.Serializable)(file, filter, fileSet, depth) -> {
            DescendantOrSelfPathFinder$.MODULE$.default(file, filter, (Set<File>)fileSet, BoxesRunTime.unboxToInt((Object)depth));
            return BoxedUnit.UNIT;
        };
        if ("nio".equals(scala.sys.package$.MODULE$.props().getOrElse((Object)"sbt.pathfinder", (Function0 & Serializable & scala.Serializable)() -> ""))) {
            intersect = (Function2 & Serializable & scala.Serializable)(file, filter) -> new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])IO$.MODULE$.wrapNull(file.listFiles((java.io.FileFilter)filter)))).toSeq();
        } else {
            FileTreeView<Tuple2<Path, FileAttributes>> fileTreeView = FileTreeView$.MODULE$.default();
            intersect = (Function2 & Serializable & scala.Serializable)(file, filter) -> (Seq)FileTreeView$Ops$.MODULE$.list$extension0(FileTreeView$.MODULE$.Ops(fileTreeView), Glob$.MODULE$.apply(file.toPath(), (RelativeGlob)AnyPath$.MODULE$)).flatMap((Function1 & Serializable & scala.Serializable)x0$1 -> {
                Path path;
                FileAttributes attrs;
                block3: {
                    Tuple2 tuple2;
                    block2: {
                        tuple2 = x0$1;
                        if (tuple2 == null) break block2;
                        Path path2 = (Path)tuple2._1();
                        attrs = (FileAttributes)tuple2._2();
                        if (path2 == null) break block2;
                        path = path2;
                        if (attrs != null) break block3;
                    }
                    throw new MatchError((Object)tuple2);
                }
                FileAttributes fileAttributes = attrs;
                Iterable iterable = filter.accept(new Path.AttributedFile(path, fileAttributes)) ? Option$.MODULE$.option2Iterable((Option)new Some((Object)path.toFile())) : Option$.MODULE$.option2Iterable((Option)None$.MODULE$);
                return iterable;
            }, Seq$.MODULE$.canBuildFrom());
        }
        this.defaultChildHandler = intersect;
    }
}

