/*
 * Decompiled with CFR 0.152.
 */
package sbt.internal.util;

import java.io.PrintStream;
import java.io.Serializable;
import sbt.internal.util.ConsoleAppender$;
import sbt.internal.util.ProgressEvent;
import sbt.internal.util.ProgressState;
import sbt.internal.util.Prompt;
import sbt.internal.util.Prompt$Batch$;
import sbt.internal.util.Prompt$Running$;
import sbt.internal.util.Prompt$Watch$;
import sbt.internal.util.Terminal;
import scala.Function0;
import scala.Function1;
import scala.Function2;
import scala.Option$;
import scala.Predef$;
import scala.collection.ArrayOps$;
import scala.collection.IterableOnceOps;
import scala.collection.StringOps$;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Seq;
import scala.collection.immutable.Vector;
import scala.math.package$;
import scala.reflect.ClassTag;
import scala.reflect.ClassTag$;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.java8.JFunction0;

public final class ProgressState$ {
    public static final ProgressState$ MODULE$ = new ProgressState$();
    private static final String SERVER_IS_RUNNING = "sbt server is running ";
    private static final int SERVER_IS_RUNNING_LENGTH = MODULE$.SERVER_IS_RUNNING().length() + 3;

    private String SERVER_IS_RUNNING() {
        return SERVER_IS_RUNNING;
    }

    private int SERVER_IS_RUNNING_LENGTH() {
        return SERVER_IS_RUNNING_LENGTH;
    }

    public void updateProgressState(ProgressEvent pe, Terminal terminal) {
        boolean isWatch;
        ProgressState state = terminal.progressState();
        boolean isAskUser = terminal.prompt() instanceof Prompt.AskUser;
        Prompt prompt = terminal.prompt();
        Prompt$Running$ prompt$Running$ = Prompt$Running$.MODULE$;
        boolean isRunning = !(prompt != null ? !prompt.equals(prompt$Running$) : prompt$Running$ != null);
        Prompt prompt2 = terminal.prompt();
        Prompt$Batch$ prompt$Batch$ = Prompt$Batch$.MODULE$;
        boolean isBatch = !(prompt2 != null ? !prompt2.equals(prompt$Batch$) : prompt$Batch$ != null);
        Prompt prompt3 = terminal.prompt();
        Prompt$Watch$ prompt$Watch$ = Prompt$Watch$.MODULE$;
        boolean bl = !(prompt3 != null ? !prompt3.equals(prompt$Watch$) : prompt$Watch$ != null) ? true : (isWatch = false);
        if (terminal.isSupershellEnabled()) {
            ConsoleAppender$.MODULE$.setShowProgress(true);
            if (!BoxesRunTime.unboxToBoolean((Object)pe.skipIfActive().getOrElse((Function0)(JFunction0.mcZ.sp & Serializable)() -> false)) || !isRunning && !isBatch) {
                terminal.withPrintStream((Function1 & Serializable)ps -> {
                    ProgressState$.$anonfun$updateProgressState$2(pe, terminal, state, isWatch, isAskUser, ps);
                    return BoxedUnit.UNIT;
                });
                return;
            }
            if (((IterableOnceOps)state.progressLines().get()).nonEmpty()) {
                state.progressLines().set((Seq<String>)Nil$.MODULE$);
                terminal.withPrintStream((Function1 & Serializable)ps -> {
                    ProgressState$.$anonfun$updateProgressState$10(terminal, ps);
                    return BoxedUnit.UNIT;
                });
                return;
            }
            return;
        }
    }

    public static final /* synthetic */ boolean $anonfun$updateProgressState$4(Terminal terminal$2, String x$7) {
        String string = x$7;
        String string2 = terminal$2.name();
        return !(string != null ? !string.equals(string2) : string2 != null);
    }

    public static final /* synthetic */ int $anonfun$updateProgressState$7(Terminal terminal$2, int x$8, String x$9) {
        return x$8 + terminal$2.lineCount(x$9);
    }

    public static final /* synthetic */ int $anonfun$updateProgressState$8(Terminal terminal$2, int x$10, String x$11) {
        return x$10 + terminal$2.lineCount(x$11);
    }

    public static final /* synthetic */ void $anonfun$updateProgressState$2(ProgressEvent pe$1, Terminal terminal$2, ProgressState state$1, boolean isWatch$1, boolean isAskUser$1, PrintStream ps) {
        Seq seq;
        boolean commandFromThisTerminal = BoxesRunTime.unboxToBoolean((Object)pe$1.channelName().fold((Function0)(JFunction0.mcZ.sp & Serializable)() -> true, (Function1 & Serializable)x$7 -> BoxesRunTime.boxToBoolean((boolean)ProgressState$.$anonfun$updateProgressState$4(terminal$2, x$7))));
        if (commandFromThisTerminal) {
            Vector base = (Vector)pe$1.items().map((Function1 & Serializable)item -> {
                long elapsed = item.elapsedMicros() / 1000000L;
                return new StringBuilder(9).append("  | => ").append(item.name()).append(" ").append(elapsed).append("s").toString();
            });
            int limit = state$1.maxItems();
            if (base.size() > limit + 1) {
                String string = new StringBuilder(22).append("  | ... (").append(base.size() - limit).append(" other tasks)").toString();
                seq = (Seq)base.takeRight(limit).$plus$colon((Object)string);
            } else {
                seq = base;
            }
        } else {
            seq = (Seq)Option$.MODULE$.option2Iterable(pe$1.command()).toSeq().flatMap((Function1 & Serializable)cmd -> {
                int width = terminal$2.getWidth();
                String sanitized = cmd.length() + MODULE$.SERVER_IS_RUNNING_LENGTH() > width ? new StringBuilder(3).append(StringOps$.MODULE$.take$extension(Predef$.MODULE$.augmentString(cmd), width - 3 - MODULE$.SERVER_IS_RUNNING_LENGTH())).append("...").toString() : cmd;
                Nil$ tail = isWatch$1 ? Nil$.MODULE$ : Nil$.MODULE$.$colon$colon((Object)"enter 'cancel' to stop evaluation");
                String string = new StringBuilder(3).append(MODULE$.SERVER_IS_RUNNING()).append(" '").append(sanitized).append("'").toString();
                return tail.$colon$colon((Object)string);
            });
        }
        Seq info = seq;
        int currentLength = BoxesRunTime.unboxToInt((Object)info.foldLeft((Object)BoxesRunTime.boxToInteger((int)0), (Function2 & Serializable)(x$8, x$9) -> BoxesRunTime.boxToInteger((int)ProgressState$.$anonfun$updateProgressState$7(terminal$2, BoxesRunTime.unboxToInt((Object)x$8), x$9))));
        Seq<String> previousLines = state$1.progressLines().getAndSet((Seq<String>)info);
        int prevLength = BoxesRunTime.unboxToInt((Object)previousLines.foldLeft((Object)BoxesRunTime.boxToInteger((int)0), (Function2 & Serializable)(x$10, x$11) -> BoxesRunTime.boxToInteger((int)ProgressState$.$anonfun$updateProgressState$8(terminal$2, BoxesRunTime.unboxToInt((Object)x$10), x$11))));
        int prevSize = prevLength + state$1.padding().get();
        String lastLine = isAskUser$1 ? terminal$2.prompt().render() : (String)terminal$2.getLastLine().getOrElse((Function0 & Serializable)() -> "");
        state$1.padding().set(package$.MODULE$.max(0, prevSize - currentLength));
        byte[] toWrite = (byte[])ArrayOps$.MODULE$.$plus$plus$extension(Predef$.MODULE$.byteArrayOps(state$1.getPrompt(terminal$2)), (Object)state$1.printProgress(terminal$2, lastLine).getBytes("UTF-8"), (ClassTag)ClassTag$.MODULE$.Byte());
        ps.write(toWrite);
        ps.flush();
    }

    public static final /* synthetic */ void $anonfun$updateProgressState$10(Terminal terminal$2, PrintStream ps) {
        String lastLine = (String)terminal$2.getLastLine().getOrElse((Function0 & Serializable)() -> "");
        ps.print(new StringBuilder(0).append(lastLine).append(ConsoleAppender$.MODULE$.ClearScreenAfterCursor()).toString());
        ps.flush();
    }

    private ProgressState$() {
    }
}

