/*
 * Decompiled with CFR 0.152.
 */
package org.scoverage.plugin;

import java.io.File;
import java.util.Arrays;
import java.util.List;
import java.util.function.Function;
import java.util.function.Predicate;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.plugin.logging.Log;
import org.apache.maven.plugins.annotations.Execute;
import org.apache.maven.plugins.annotations.LifecyclePhase;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.maven.project.MavenProject;
import org.scoverage.plugin.SCoverageForkedLifecycleConfigurator;
import scala.collection.Iterable;
import scala.collection.Set;
import scala.collection.immutable.Seq;
import scala.jdk.javaapi.CollectionConverters;
import scoverage.domain.Coverage;
import scoverage.domain.CoverageMetrics;
import scoverage.domain.DoubleFormat;
import scoverage.domain.MeasuredFile;
import scoverage.domain.MeasuredPackage;
import scoverage.reporter.IOUtils;
import scoverage.serialize.Serializer;

@Mojo(name="check", threadSafe=false)
@Execute(lifecycle="scoverage", phase=LifecyclePhase.TEST)
public class SCoverageCheckMojo
extends AbstractMojo {
    @Parameter(property="scoverage.skip", defaultValue="false")
    private boolean skip;
    @Parameter(property="scoverage.dataDirectory", defaultValue="${project.build.directory}/scoverage-data", required=true, readonly=true)
    private File dataDirectory;
    @Parameter(property="scoverage.minimumCoverage", defaultValue="0")
    private Double minimumCoverage;
    @Parameter(property="scoverage.minimumCoverageBranchTotal", defaultValue="0")
    private Double minimumCoverageBranchTotal;
    @Parameter(property="scoverage.minimumCoverageStmtPerPackage", defaultValue="0")
    private Double minimumCoverageStmtPerPackage;
    @Parameter(property="scoverage.minimumCoverageBranchPerPackage", defaultValue="0")
    private Double minimumCoverageBranchPerPackage;
    @Parameter(property="scoverage.minimumCoverageStmtPerFile", defaultValue="0")
    private Double minimumCoverageStmtPerFile;
    @Parameter(property="scoverage.minimumCoverageBranchPerFile", defaultValue="0")
    private Double minimumCoverageBranchPerFile;
    @Parameter(property="scoverage.failOnMinimumCoverage", defaultValue="false")
    private boolean failOnMinimumCoverage;
    @Parameter(property="encoding", defaultValue="${project.build.sourceEncoding}")
    private String encoding;
    @Parameter(defaultValue="${project}", readonly=true, required=true)
    private MavenProject project;
    @Parameter(defaultValue="${reactorProjects}", required=true, readonly=true)
    private List<MavenProject> reactorProjects;

    public void execute() throws MojoFailureException {
        if ("pom".equals(this.project.getPackaging())) {
            this.getLog().info((CharSequence)"Skipping SCoverage execution for project with packaging type 'pom'");
            return;
        }
        if (this.skip) {
            this.getLog().info((CharSequence)"Skipping Scoverage execution");
            return;
        }
        long ts = System.currentTimeMillis();
        SCoverageForkedLifecycleConfigurator.afterForkedLifecycleExit(this.project, this.reactorProjects);
        if (!this.dataDirectory.exists() || !this.dataDirectory.isDirectory()) {
            this.getLog().info((CharSequence)"Cannot perform check, instrumentation not performed - skipping");
            return;
        }
        File coverageFile = Serializer.coverageFile((File)this.dataDirectory);
        if (!coverageFile.exists()) {
            this.getLog().info((CharSequence)"Scoverage data file does not exist. Skipping check");
            return;
        }
        if (!coverageFile.isFile()) {
            this.getLog().info((CharSequence)"Scoverage data file is a directory, not a file. Skipping check");
            return;
        }
        Coverage coverage = Serializer.deserialize((File)coverageFile, (File)this.project.getBasedir());
        List<File> measurementFiles = Arrays.asList(IOUtils.findMeasurementFiles((File)this.dataDirectory));
        Set measurements = IOUtils.invoked((Seq)CollectionConverters.asScala(measurementFiles).toSeq(), (String)this.encoding);
        coverage.apply((Iterable)measurements);
        int branchCount = coverage.branchCount();
        int statementCount = coverage.statementCount();
        int invokedBranchesCount = coverage.invokedBranchesCount();
        int invokedStatementCount = coverage.invokedStatementCount();
        this.getLog().debug((CharSequence)String.format("invokedBranchesCount:%d / branchCount:%d, invokedStatementCount:%d / statementCount:%d", invokedBranchesCount, branchCount, invokedStatementCount, statementCount));
        boolean ok = SCoverageCheckMojo.checkCoverage(this.getLog(), "Total", (CoverageMetrics)coverage, this.minimumCoverage, (double)this.minimumCoverageBranchTotal, true);
        ok = SCoverageCheckMojo.checkCoverage(this.getLog(), "Package:", coverage.packages(), MeasuredPackage::name, (double)this.minimumCoverageStmtPerPackage, this.minimumCoverageBranchPerPackage) && ok;
        boolean bl = ok = SCoverageCheckMojo.checkCoverage(this.getLog(), "File:", coverage.files(), MeasuredFile::filename, (double)this.minimumCoverageStmtPerFile, this.minimumCoverageBranchPerFile) && ok;
        if (!ok && this.failOnMinimumCoverage) {
            throw new MojoFailureException("Coverage minimum was not reached");
        }
        long te = System.currentTimeMillis();
        this.getLog().debug((CharSequence)String.format("Mojo execution time: %d ms", te - ts));
    }

    private static boolean is100(Double d) {
        return Math.abs(100.0 - d) <= 1.0E-5;
    }

    private static <T extends CoverageMetrics> boolean checkCoverage(Log logger, String metricPrefix, Iterable<T> metrics, Function<T, String> toName, double minStmt, double minBranch) {
        return minStmt <= 0.0 && minBranch <= 0.0 || SCoverageCheckMojo.checkAll(metrics, cov -> SCoverageCheckMojo.checkCoverage(logger, metricPrefix + (String)toName.apply(cov), cov, minStmt, minBranch, false));
    }

    private static boolean checkCoverage(Log logger, String metric, CoverageMetrics metrics, double minStmt, double minBranch, boolean logSuccessInfo) {
        boolean stmt = SCoverageCheckMojo.checkCoverage(logger, "Statement:" + metric, minStmt, metrics.statementCoveragePercent(), logSuccessInfo);
        boolean branch = SCoverageCheckMojo.checkCoverage(logger, "Branch:" + metric, minBranch, metrics.branchCoveragePercent(), logSuccessInfo);
        return stmt && branch;
    }

    private static boolean checkCoverage(Log logger, String metric, double minimum, double actual, boolean logSuccessInfo) {
        boolean ok;
        if (minimum <= 0.0) {
            return true;
        }
        if (SCoverageCheckMojo.is100(actual)) {
            SCoverageCheckMojo.logSuccess(logger, String.format("Coverage is 100%%: %s!", metric), logSuccessInfo);
            return true;
        }
        String minimumFormatted = DoubleFormat.twoFractionDigits((double)minimum);
        String actualFormatted = DoubleFormat.twoFractionDigits((double)actual);
        boolean bl = ok = minimum <= actual;
        if (ok) {
            String message = String.format("Coverage is above minimum [%s%% >= %s%%]: %s", actualFormatted, minimumFormatted, metric);
            SCoverageCheckMojo.logSuccess(logger, message, logSuccessInfo);
        } else {
            String message = String.format("Coverage is below minimum [%s%% < %s%%]: %s", actualFormatted, minimumFormatted, metric);
            logger.error((CharSequence)message);
        }
        return ok;
    }

    private static void logSuccess(Log logger, String message, boolean logSuccessInfo) {
        if (logSuccessInfo) {
            logger.info((CharSequence)message);
        } else {
            logger.debug((CharSequence)message);
        }
    }

    private static <T> boolean checkAll(Iterable<T> iterable, Predicate<T> predicate) {
        boolean ok = true;
        for (Object elem : CollectionConverters.asJava(iterable)) {
            ok = predicate.test(elem) && ok;
        }
        return ok;
    }
}

