/*
 * Decompiled with CFR 0.152.
 */
package org.scribble.common.logging;

import java.util.List;
import java.util.Map;
import java.util.Vector;
import org.scribble.common.logging.Journal;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CachedJournal
implements Journal {
    private List<IssueDetails> _issues = new Vector<IssueDetails>();
    private boolean _errors = false;
    private boolean _warnings = false;

    @Override
    public void error(String issue, Map<String, Object> props) {
        this._issues.add(new IssueDetails(IssueType.Error, issue, props));
        this._errors = true;
    }

    @Override
    public void info(String issue, Map<String, Object> props) {
        this._issues.add(new IssueDetails(IssueType.Info, issue, props));
    }

    @Override
    public void warning(String issue, Map<String, Object> props) {
        this._issues.add(new IssueDetails(IssueType.Warning, issue, props));
        this._warnings = true;
    }

    public List<IssueDetails> getIssues() {
        return this._issues;
    }

    public boolean hasErrors() {
        return this._errors;
    }

    public boolean hasWarnings() {
        return this._warnings;
    }

    public void apply(Journal logger) {
        for (IssueDetails id : this._issues) {
            if (id.getIssueType() == IssueType.Error) {
                logger.error(id.getMessage(), id.getProperties());
                continue;
            }
            if (id.getIssueType() == IssueType.Info) {
                logger.info(id.getMessage(), id.getProperties());
                continue;
            }
            if (id.getIssueType() != IssueType.Warning) continue;
            logger.warning(id.getMessage(), id.getProperties());
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public class IssueDetails {
        private IssueType _type = IssueType.Info;
        private String _message = null;
        private Map<String, Object> _properties = null;

        public IssueDetails(IssueType type, String mesg, Map<String, Object> props) {
            this._type = type;
            this._message = mesg;
            this._properties = props;
        }

        public IssueType getIssueType() {
            return this._type;
        }

        public String getMessage() {
            return this._message;
        }

        public Map<String, Object> getProperties() {
            return this._properties;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum IssueType {
        Error,
        Info,
        Warning;

    }
}

