/*
 * Decompiled with CFR 0.152.
 */
package org.scribble.protocol.projection.impl;

import org.scribble.common.logging.Journal;
import org.scribble.protocol.model.Block;
import org.scribble.protocol.model.ModelObject;
import org.scribble.protocol.model.Parameter;
import org.scribble.protocol.model.Protocol;
import org.scribble.protocol.model.ProtocolReference;
import org.scribble.protocol.model.Role;
import org.scribble.protocol.model.Run;
import org.scribble.protocol.projection.impl.ProjectorContext;
import org.scribble.protocol.projection.impl.ProjectorRule;

public class RunProjectorRule
implements ProjectorRule {
    public boolean isSupported(ModelObject obj) {
        return obj.getClass() == Run.class;
    }

    public ModelObject project(ProjectorContext context, ModelObject model, Role role, Journal l) {
        String rename;
        Run ret = new Run();
        Run source = (Run)model;
        ret.derivedFrom((ModelObject)source);
        for (Parameter db : source.getParameters()) {
            if (db.getName().equals(role.getName())) continue;
            Parameter dbcopy = new Parameter(db.getName(), db.getBoundName());
            dbcopy.derivedFrom((ModelObject)db);
            ret.getParameters().add(dbcopy);
        }
        Role mappedRole = role;
        Parameter db = null;
        db = source.getParameter(role.getName());
        if (db != null && (rename = db.getBoundName()) != null) {
            mappedRole = new Role();
            mappedRole.setName(rename);
        }
        if (source.getProtocolReference() != null) {
            Protocol defn = source.getProtocol();
            if (defn != null && defn.getRoles().contains(mappedRole)) {
                if (source.getProtocolReference().isInner()) {
                    context.registerInterest(defn, mappedRole);
                }
                ret.setProtocolReference((ProtocolReference)context.project((ModelObject)source.getProtocolReference(), mappedRole, l));
            } else {
                ret = null;
            }
        }
        if (ret != null && source.getBlock() != null) {
            ret.setBlock((Block)context.project((ModelObject)source.getBlock(), mappedRole, l));
            ret.getBlock().setParent((ModelObject)ret);
        }
        return ret;
    }
}

