/*
 * Decompiled with CFR 0.152.
 */
package org.scribble.protocol.projection.impl;

import java.text.MessageFormat;
import java.util.HashMap;
import java.util.List;
import java.util.PropertyResourceBundle;
import java.util.Vector;
import java.util.logging.Logger;
import org.scribble.common.logging.Journal;
import org.scribble.protocol.model.Activity;
import org.scribble.protocol.model.Block;
import org.scribble.protocol.model.Choice;
import org.scribble.protocol.model.ModelObject;
import org.scribble.protocol.model.Role;
import org.scribble.protocol.projection.impl.ProjectorRule;
import org.scribble.protocol.projection.impl.ProtocolProjectorContext;

public class ChoiceProjectorRule
implements ProjectorRule {
    public static final String ALLOW_OPTIONAL = "scribble.choice.allowOptional";
    private static final Logger LOG = Logger.getLogger(ChoiceProjectorRule.class.getName());

    public boolean isSupported(ModelObject obj) {
        return obj.getClass() == Choice.class;
    }

    public Object project(ProtocolProjectorContext context, ModelObject model, Role role, Journal l) {
        Choice projected = new Choice();
        Choice source = (Choice)model;
        boolean optional = false;
        projected.derivedFrom((ModelObject)source);
        if (source.getRole() != null && source.getRole().equals((Object)role)) {
            projected.setRole(new Role(source.getRole()));
        }
        for (int i = 0; i < source.getPaths().size(); ++i) {
            Block block = (Block)context.project((ModelObject)source.getPaths().get(i), role, l);
            if (block != null) {
                if (block.getContents().size() == 1 && block.getContents().get(0) instanceof Choice && this.isSameRole(projected, (Choice)block.getContents().get(0))) {
                    projected.getPaths().addAll(((Choice)block.getContents().get(0)).getPaths());
                    continue;
                }
                projected.getPaths().add(block);
                continue;
            }
            optional = true;
        }
        return ChoiceProjectorRule.processChoice(context, projected, role, l, optional);
    }

    protected static Object processChoice(ProtocolProjectorContext context, Choice projected, Role role, Journal l, boolean optional) {
        Object ret = null;
        ret = ChoiceProjectorRule.extractCommonBehaviour(context, projected, role, l);
        ChoiceProjectorRule.groupSubpathsWithCommonInitiator(context, projected, role, l);
        for (int i = projected.getPaths().size() - 1; i >= 0; --i) {
            Block b = (Block)projected.getPaths().get(i);
            if (b.size() != 0) continue;
            projected.getPaths().remove(i);
            optional = true;
        }
        if (projected.getPaths().size() == 0) {
            if (ret == projected) {
                ret = null;
            } else {
                ((List)ret).remove(projected);
            }
            projected = null;
        } else if (optional) {
            if (System.getProperty(ALLOW_OPTIONAL, "false").equalsIgnoreCase(Boolean.FALSE.toString())) {
                l.error(MessageFormat.format(PropertyResourceBundle.getBundle("org.scribble.protocol.projection.impl.Messages").getString("_CHOICE_EMPTY_PATH"), role.getName()), projected.getProperties());
            }
            projected.getPaths().add(new Block());
        }
        return ret;
    }

    protected static void groupSubpathsWithCommonInitiator(ProtocolProjectorContext context, Choice projected, Role role, Journal l) {
        List<Object> plist;
        HashMap<Activity, Vector<Block>> pathGroups = new HashMap<Activity, Vector<Block>>();
        for (Block path : projected.getPaths()) {
            if (path.size() <= 0) continue;
            plist = (Vector<Block>)pathGroups.get(path.get(0));
            if (plist == null) {
                plist = new Vector<Block>();
                pathGroups.put(path.get(0), (Vector<Block>)plist);
            }
            plist.add(path);
        }
        for (Activity act : pathGroups.keySet()) {
            plist = (List)pathGroups.get(act);
            if (plist.size() < 2) continue;
            Choice sub = new Choice();
            int pos = -1;
            for (Block b : plist) {
                if (pos == -1) {
                    pos = projected.getPaths().indexOf(b);
                }
                projected.getPaths().remove(b);
                sub.getPaths().add(b);
            }
            Block newPath = new Block();
            projected.getPaths().add(pos, newPath);
            Object processed = ChoiceProjectorRule.processChoice(context, sub, role, l, false);
            if (processed instanceof List) {
                newPath.getContents().addAll((List)processed);
                continue;
            }
            LOG.severe("Should have returned a list with extracted common activity(s) followed by choice");
        }
    }

    protected static Object extractCommonBehaviour(ProtocolProjectorContext context, Choice projected, Role role, Journal l) {
        Object ret = projected;
        boolean checkPaths = true;
        do {
            int i;
            boolean allSame = projected.getPaths().size() > 1;
            for (i = 1; allSame && i < projected.getPaths().size(); ++i) {
                Block b1 = (Block)projected.getPaths().get(0);
                Block b2 = (Block)projected.getPaths().get(i);
                if (b1.size() == 0 || b2.size() == 0) {
                    allSame = false;
                    continue;
                }
                if (b1.get(0).equals(b2.get(0))) continue;
                allSame = false;
            }
            if (allSame) {
                if (!(ret instanceof List)) {
                    ret = new Vector();
                    ((List)ret).add(projected);
                }
                ((List)ret).add(((List)ret).size() - 1, ((Block)projected.getPaths().get(0)).getContents().get(0));
                for (i = 0; i < projected.getPaths().size(); ++i) {
                    ((Block)projected.getPaths().get(i)).getContents().remove(0);
                }
            } else {
                checkPaths = false;
            }
        } while (checkPaths);
        return ret;
    }

    protected boolean isSameRole(Choice c1, Choice c2) {
        if (c1.getRole() == null && c2.getRole() == null) {
            return true;
        }
        return c1.getRole().equals((Object)c2.getRole());
    }
}

